#
# test09.rb
#
# T Horinouchi  2004/11/11

require "numru/dcl"
include NumRu

raise "This program is for DCL 5.3 or later" unless DCL::DCLVERSION >= '5.3'

nx=73
ny=37
xmin=0.0
xmax=360.0
ymin=-90.0
ymax=90.0

ctr = [ 'CYL','MER','MWD','HMR','EK6','KTD','CON','COA','COC','BON',
        'OTG','PST','AZM','AZA']
fct = [ 0.12, 0.12, 0.14, 0.14, 0.14, 0.14,0.11, 0.16, 0.12, 0.12,
        0.40, 0.12, 0.12, 0.17 ]
np = ctr.length  # == fct.length

p = NArray.sfloat(nx*ny)
i = 0
File.foreach('t811231.dat') do |line|
  line.split(" ").each do |data|
    p[i] = data.to_f
    i += 1
  end
end
p.reshape!(nx, ny)

190.step(245, 5) do |r|
  amin=r
  amax=r+5
#       IDX=(R-180)*1.4*1000+999
  idx=((r-170)*1.25).to_i*1000+999
  DCL::uestlv(amin, amax, idx)
end

#-- graph ---

iws = (ARGV.shift || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sglset('LSOFTF', false)
DCL::swlset('LCMCH', true)
DCL::sgrset('STLAT1', 75.0)
DCL::sgrset('STLAT2', 60.0)
DCL::umlset('LGRIDMJ', false)
DCL::umrset('DGRIDMN', 30.0)

nn = DCL::sgqcmn

DCL::sgscmn(1)
DCL::sgopn(iws)

for i in 0..np-1
  icn= (i % nn) + 1
  print "colormap ",icn,": ",DCL::swqcmd(icn),"\n"
  DCL::sgscmn(i+1)
  DCL::sgfrm
  DCL::sgssim(fct[i], 0.0, 0.0)
  DCL::sgsmpl(165.0, 60.0, 0.0)
  DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)
  DCL::sgswnd(xmin, xmax, ymin, ymax)
  if (ctr[i] == 'OTG')
    DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
  else
    DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
  end
  DCL::sgstrn(DCL::isgtrc(ctr[i]))
  DCL::sgstrf

  DCL::sglset('LCLIP', true)
  DCL::slpwwr(1)
  DCL::slpvpr(1)
  cttl = DCL::sgtrnl(DCL::isgtrc(ctr[i]))
  DCL::sgtxzr(0.5, 0.95, cttl, 0.03, 0, 0, 3)

  DCL::uetone(p)
  DCL::udcntr(p)
  DCL::umfmap('coast_world')
  DCL::umpmap('coast_world')
  DCL::umpglb
  DCL::slpvpr(1)
end
DCL::swpcls

DCL::sgcls
