/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* slratz.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/* Subroutine */ int slratz_(real *xamin, real *xamax, real *yamin, real *
	yamax, real *rx, real *ry)
{
    static real arat, brat, xx, yy;
    extern /* Subroutine */ int msgdmp_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen), slmgnz_(real *, real *, real *, real *, real *, 
	    real *, real *, real *);
    static real wxa, wya;

    wxa = *xamax - *xamin;
    wya = *yamax - *yamin;
    if (wxa < 0.f || wya < 0.f) {
	msgdmp_("E", "SLRATZ", "RECTANGLE DEFINITION IS INVALID.", (ftnlen)1, 
		(ftnlen)6, (ftnlen)32);
    }
    if (*rx < 0.f || *ry < 0.f) {
	msgdmp_("E", "SLRATZ", "PROPORTION PARAMETER IS LESS THAN ZERO.", (
		ftnlen)1, (ftnlen)6, (ftnlen)39);
    }
    arat = wya / wxa;
    brat = *ry / *rx;
    if (arat >= brat) {
	xx = 0.f;
	yy = (1 - brat / arat) / 2;
    } else {
	xx = (1 - arat / brat) / 2;
	yy = 0.f;
    }
    slmgnz_(xamin, xamax, yamin, yamax, &xx, &xx, &yy, &yy);
    return 0;
} /* slratz_ */

