/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* cr3s.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static real c_b3 = 0.f;

/* ----------------------------------------------------------------------- */
/*     COORDINATE ROTATION (3D SPHERICAL) */
/*                                              93/02/19   S.SAKAI */
/*                                              93/10/29   S.SAKAI */
/* ----------------------------------------------------------------------- */
/* Subroutine */ int cr3s_(real *theta, real *phi, real *psi, real *theta0, 
	real *phi0, real *theta1, real *phi1)
{
    /* Initialized data */

    static logical lfirst = TRUE_;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), acos(doublereal), atan2(
	    doublereal, doublereal);

    /* Local variables */
    extern doublereal rfpi_(void);
    static real a, b;
    extern logical lreqa_(real *, real *, real *);
    static real repsl, cp, pi, sp;
    extern /* Subroutine */ int glrget_(char *, real *, ftnlen);
    static real ct0, st0, cte, ste;

    if (lfirst) {
	glrget_("REPSL", &repsl, (ftnlen)5);
	pi = rfpi_();
	lfirst = FALSE_;
    }
    if (lreqa_(theta, &c_b3, &repsl)) {
	*theta1 = *theta0;
	*phi1 = *phi0 - *phi - *psi;
    } else {
	if (lreqa_(theta0, &c_b3, &repsl)) {
	    *theta1 = *theta;
	    *phi1 = pi - *psi;
	} else if (lreqa_(theta0, &pi, &repsl)) {
	    *theta1 = pi - *theta;
	    *phi1 = -(*psi);
	} else {
	    cte = cos(*theta);
	    ste = sin(*theta);
	    ct0 = cos(*theta0);
	    st0 = sin(*theta0);
	    cp = cos(*phi0 - *phi);
	    sp = sin(*phi0 - *phi);
	    a = ct0 * cte + st0 * ste * cp;
	    if (a >= 1.f) {
		*theta1 = 0.f;
	    } else if (a <= -1.f) {
		*theta1 = pi;
	    } else {
		*theta1 = acos(a);
	    }
	    a = sp * st0;
	    b = -ct0 * ste + st0 * cte * cp;
	    if (a == 0.f && b == 0.f) {
		*phi1 = 0.f;
	    } else {
		*phi1 = atan2(a, b) - *psi;
	    }
	}
    }
    return 0;
} /* cr3s_ */

