! qXgo̓[`gf
! 2000-05-31 by TOYODA Eizi

program testhist
    use gtool_history

    integer, parameter:: LONSIZE = 3
    integer, parameter:: LATSIZE = 5
    integer, parameter:: PSIZE = 2
    integer:: i, j, k, t

    real:: ps(LONSIZE, LATSIZE)
    real:: u(LONSIZE, LATSIZE, PSIZE)

    call HistoryCreate(file="gtool.nc", title="testhist run", &
	& source="testhist.f90 2000-05-31", institution="TOYODA Eizi", &
	& dims=(/"lon", "lat", "p", "time"/), &
	& dimsizes=(/LONSIZE, LATSIZE, PSIZE, 0/), &
	& longnames=(/"longitude", "latitude", "pressure", "time"/), &
	& units=(/"degree_E", "degree_N", "hPa", "sec"/), &
	& origin=0.0, interval=15.0)
    call HistoryAddVariable(varname="ps", dims=(/"lon", "lat", "time"/), &
	& longname="surface pressure", units="hPa")
    call HistoryAddVariable(varname="u", dims=(/"lon", "lat", "p", "time"/), &
	& longname="eastward velocity", units="m/s")
    ! 킴 lat ͐ݒ肵YĂ
    call HistoryPut(varname="lon", &
	& array=(/((real(i) * 360.0 / LONSIZE), i = 1, LONSIZE)/))
    call HistoryPut("p", (/1000.0, 500.0/))
   
    do, t = 1, 9

	! : l͓mF̂߂ŁAӖ̂̂ł͂ȂB
	do, i = 1, LONSIZE
	    do, j = 1, LATSIZE
		ps(i, j) = 1000.0 + t * 10.0 + i * 0.1 + j * 0.01
		u(i, j, :) = (/0, 10/) + t * 0.1 + i * 0.01 + j * 0.001
	    enddo
	enddo

	call HistoryPut(varname="ps", array=ps)
	call HistoryPut(varname="u", array=u)
    enddo

    call HistoryClose()
end program
