! gtool_contours.f90 - gtool4 graphic objects - contours
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_contours

    use gtool_data
    use dcl
    implicit none

    type GT_CONTOURS
	type(GT_VARIABLE):: var
	real:: interval
    end type

    interface Contours
	module procedure GtoolContoursDefault
    end interface

    interface Display
	module procedure GtoolContoursDisplay
    end interface

    interface LongName;  module procedure GtoolContoursLongName;  end interface

contains

    type(GT_CONTOURS) function GtoolContoursDefault(var) result(result)
	type(GT_VARIABLE), intent(in):: var
	integer:: i
	logical:: ok
    continue
	if (.not. .hasVariable. var) then
	    print *, 'non-netcdf variable currently not implemented'
	    stop
	endif
	result%var = var
	do, i = 3, DimensionsNumber(var)
	    ok = Slice(result%var, i, 1)
	enddo
    end function

    subroutine GtoolContoursDisplay(contours)
	type(GT_CONTOURS), intent(in):: contours
	real, pointer:: buffer(:, :)
    continue
	call Get(contours%var, buffer)
	call DclSetShadeLevel(buffer, 0.0)
	call DclShadeContour(buffer)
	call DclDrawScaledAxis
	call DclDrawContour(buffer)
	deallocate(buffer)
    end subroutine

    function GtoolContoursLongName(contours) result(result)
	use gtool_attribute
	type(VARYING_STRING):: result
	type(GT_CONTOURS), intent(in):: contours
	type(GT_ATTRIBUTE):: attr
    continue
	attr = Attribute(contours%var, 'long_name')
	if (.exists. attr) then
	    result = attr
	else
	    result = Fullname(contours%var)
	endif
    end function

end module
