! an_generic.f90 -  netCDF 󥿡ե
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.


module an_generic

    !
    ! === ܳư ===
    !

    !
    ! an 饤֥Ǥϡ֥եפǤϤʤѿפ򳫤Ĥꤹ롣
    ! ٤ƤΤΤѿȤ°Ǥ롣
    ! 
    ! open  url Ǽ̤ѿ򳫤ѿȤ netCDF ѿޤ
    ! netCDF Ǥ롣Ʊ̾ netCDF ѿˤξԤ
    ! Ʊ뤵롣writable 򿿤˻ꤹȽ񤭹߲ĤǳȤ롣
    ! ǥեȤ writable=.FALSE. Ǥ롣顼ȯ
    ! err Ȥʤ롣err ͿʤХץߤ롣
    !

    interface open
	subroutine ANVarOpen(var, url, writable, err)
	    use iso_varying_string, only: VARYING_STRING    
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(inout):: var
	    type(VARYING_STRING), intent(in):: url
	    logical, intent(in), optional:: writable
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface create
	subroutine ANVarCreate(var, url, type, dims, overwrite, err)
	    use iso_varying_string, only: VARYING_STRING    
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(inout):: var
	    type(VARYING_STRING), intent(in):: url
	    character(len = *), intent(in):: type
	    type(AN_VARIABLE), intent(in):: dims
	    logical, intent(in), optional:: overwrite
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface close
	subroutine ANVarClose(var, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(inout):: var
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface url
	function ANVarUrl(var) result(result)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(VARYING_STRING):: result
	    type(AN_VARIABLE), intent(in):: var
	end function
    end interface

    !
    ! °ط
    !

    interface attr_rewind
	subroutine ANVarAttrRewind(var)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	end subroutine
    end interface

    interface attr_next
	subroutine ANVarAttrNext(var, name, end)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(out):: name
	    logical, intent(out), optional:: end
	end subroutine
    end interface

    interface attr_true
	logical function ANVarAttrTrue(var, name, default)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    logical, intent(in), optional:: default
	end function
    end interface

    interface get_attr

	subroutine ANVarGetAttrReal(var, name, value, default)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    real, intent(out):: value(:)
	    real, intent(in), optional:: default
	end subroutine

	subroutine ANVarGetAttrInt(var, name, value, default)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    integer, intent(out):: value(:)
	    integer, intent(in), optional:: default
	end subroutine

    end interface

    interface put_attr

	subroutine ANVarPutAttrReal(var, name, value, default, err)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    real, intent(in):: value(:)
	    real, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

	subroutine ANVarPutAttrInt(var, name, value, default, err)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    integer, intent(in):: value(:)
	    integer, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

	subroutine ANVarPutAttrLogical(var, name, value, default, err)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    logical, intent(in):: value
	    logical, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

    end interface

    !
    ! ط
    !

    interface ndims_all
	integer function ANVarNDimsAll(var)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	end function
    end interface

    interface ndims
	integer function ANVarNDims(var)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	end function
    end interface

    interface dimsize
	integer function ANVarDimSize(var, name)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(AN_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	end function
    end interface

    interface dimname
	function ANVarDimName(var, ord) result(result)
	    use an_types, only: AN_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(VARYING_STRING):: result
	    type(AN_VARIABLE), intent(in):: var
	    integer, intent(in):: ord
	end function
    end interface

    interface slice
	subroutine ANVarSlice(var, dimord, start, count, stride)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    integer, intent(in):: dimord
	    integer, intent(in), optional:: start
	    integer, intent(in), optional:: count
	    integer, intent(in), optional:: stride
	end subroutine
    end interface

    interface get_slice
	subroutine ANVarGetSlice(var, dimord, start, count, stride)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    integer, intent(in):: dimord
	    integer, intent(out), optional:: start
	    integer, intent(out), optional:: count
	    integer, intent(out), optional:: stride
	end subroutine
    end interface

    interface slice_next
	subroutine ANVarSliceNext(var, dimord)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    integer, intent(in), optional:: dimord
	end subroutine
    end interface

    !
    ! 
    !

    interface get

	subroutine ANVarGetReal(var, value, nvalue, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(out):: value(*)
	    integer, intent(in):: nvalue
	    logical, intent(out):: err
	end subroutine

	subroutine ANVarGetReal1(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(out):: value(:)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine ANVarGetReal2(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(out):: value(:, :)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine ANVarGetReal3(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(out):: value(:, :, :)
	    logical, intent(out), optional:: err
	end subroutine

    end interface

    interface put

	subroutine ANVarPutReal(var, value, nvalue, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(in):: value(*)
	    integer, intent(in):: nvalue
	    logical, intent(out):: err
	end subroutine

	subroutine ANVarPutReal1(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(in):: value(:)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine ANVarPutReal2(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(in):: value(:, :)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine ANVarPutReal3(var, value, err)
	    use an_types, only: AN_VARIABLE
	    type(AN_VARIABLE), intent(in):: var
	    real, intent(in):: value(:, :, :)
	    logical, intent(out), optional:: err
	end subroutine

    end interface

end module
