! an_url.f90 
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.

module an_url


contains

    subroutine ANUrlSplit(fullname, file, var, attr)
	use iso_varying_string, only: &
	    VARYING_STRING, extract, index, assignment(=)
	type(VARYING_STRING), intent(in)::	fullname
	type(VARYING_STRING), intent(out), optional::	file, var, attr
	type(VARYING_STRING):: varpart
	integer:: hash, colon
    continue
	hash = index(fullname, '#', back=.TRUE.)
	if (hash == 0) then
	    if (present(file)) file = fullname
	    if (present(var)) var = ''
	    if (present(attr)) attr = ''
	    return
	endif
	if (present(file)) file = extract(fullname, 1, hash - 1)
	varpart = extract(fullname, hash + 1)
	colon = index(varpart, ':')
	if (colon == 0) then
	    if (present(var)) var = varpart
	    if (present(attr)) attr = ''
	    varpart = ''
	    return
	endif
	if (present(var)) var = extract(varpart, 1, colon - 1)
	if (present(attr)) attr = extract(varpart, colon + 1)
	varpart = ''
    end subroutine

end module
