subroutine ANVarAttrRewind(var)
    use an_types, only: AN_VARIABLE
    use dc_error, only: GT_EFAKE, StoreError
    type(AN_VARIABLE), intent(in):: var
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

subroutine ANVarAttrNext(var, name, end)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(out):: name
    logical, intent(out), optional:: end
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

logical function ANVarAttrTrue(var, name, default) result(result)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    logical, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
    result = .FALSE.
end function


subroutine ANVarGetAttrReal(var, name, value, default)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    real, intent(out):: value(:)
    real, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

subroutine ANVarGetAttrInt(var, name, value, default)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    integer, intent(out):: value(:)
    integer, intent(in), optional:: default
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine



subroutine ANVarPutAttrReal(var, name, value, default, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    real, intent(in):: value(:)
    real, intent(in), optional:: default
    real, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

subroutine ANVarPutAttrInt(var, name, value, default, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    integer, intent(in):: value(:)
    integer, intent(in), optional:: default
    real, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine

subroutine ANVarPutAttrLogical(var, name, value, default, err)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    use dc_error
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    logical, intent(in):: value
    logical, intent(in), optional:: default
    real, intent(out), optional:: err
    call StoreError(GT_EFAKE, 'ANVarAttrRewind')
end subroutine
