subroutine ANVarOpen(var, url, writable, err)
    use iso_varying_string, only: VARYING_STRING, operator(==), char
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileOpen
    use an_url, only: ANUrlSplit
    use dc_error, only: StoreError
    use netcdf_f77, only: NF_INQ_VARID, NF_ENOTVAR
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: url
    logical, intent(in), optional:: writable
    logical, intent(out), optional:: err
    type(VARYING_STRING):: filename, varname
    integer:: stat
    integer:: nvars
continue
    call ANUrlSplit(url, filename, varname)
    call ANFileOpen(var%fileid, filename, err=err, writable=writable)
    if (varname == '') then
	var%varid = 1
	stat = nf_inq_nvars(var%fileid, nvars)
	if (stat == 0 .and. nvars < 1) stat = NF_ENOTVAR
    else
	stat = nf_inq_varid(var%fileid, char(varname), var%varid)
    endif
    call StoreError(stat, 'ANVarOpen', err)
end subroutine
