! dc_error.f90 - 顼ν
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module dc_error

    use iso_varying_string, only: VARYING_STRING
    private

    ! 顼ݻ

    integer, private:: errno = 0
    integer, private:: cause_int = 0
    type(VARYING_STRING), private:: cause_string
    type(VARYING_STRING), private:: cause_location 

    integer, public, parameter:: GT_EFAKE = -100

    public:: StoreError, DumpError, GetErrorMessage
    !
    ! === ³ѻ ===
    !
    ! 캹ؤ褦˳ؿˤƤ

    interface
	subroutine DumpError()
	end subroutine
    end interface

contains

    ! ŵŪ饤֥ؿΤ˺줿顼ؿ
    !
    ! 顼ֹ number  errno ˳Ǽ롣ƱտŪ
    ! where, cause_s, cause_i  cause_location, cause_string,
    ! cause_int ˳Ǽ롣 
    ! err ͿƤ硢err  number  0 ξˤʤ롣
    ! number  0 ʤ¨롣
    ! err ͿƤʤХ顼å * ˽Ϥ
    ! ץλ롣

    subroutine StoreError(number, where, err, cause_s, cause_i)
	use iso_varying_string, only: VARYING_STRING, assignment(=)
	integer, intent(in):: number
	character(len = *), intent(in):: where
	logical, intent(out), optional:: err
	type(VARYING_STRING), intent(in), optional:: cause_s
	integer, intent(in), optional:: cause_i
    continue
	errno = number
	cause_location = where
	if (present(cause_s)) cause_string = cause_s
	if (present(cause_i)) cause_int = cause_i
	if (present(err)) then
	    err = (number /= 0)
	    return
	endif
	if (number == 0) return
	call DumpError
    end subroutine

    subroutine GetErrorMessage(msg)
	use iso_varying_string, only: VARYING_STRING, &
		assignment(=), operator(//)
	use netcdf_f77, only: nf_strerror
	type(VARYING_STRING), intent(out):: msg
	character(len = 80):: message
    continue
	if (errno == GT_EFAKE) then
	    msg = cause_location // ": Function not implemented"
	endif
	message = nf_strerror(errno)
	msg = cause_location // (": " // trim(message))
    end subroutine

end module

    subroutine DumpError()
	use iso_varying_string, only: VARYING_STRING, put_line
	use dc_error, only: GetErrorMessage
	use sysdep, only: AbortProgram
	type(VARYING_STRING):: message
	call GetErrorMessage(message)
	call put_line(message)
	call AbortProgram
    end subroutine

