! dc_string.f90 - character type support routines
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module dc_string

    use iso_varying_string

    interface stoi
	module procedure atoi_scalar
    end interface

    interface itos
	module procedure itoa_scalar
    end interface

contains

    integer function atoi_scalar(string) result(result)
	type(VARYING_STRING), intent(in):: string
	integer:: ios
    continue
	result = mainpart(len(string))
	if (ios /= 0) result = 0
    contains
	integer function mainpart(length) result(result)
	    integer, intent(in):: length
	    character(len = length):: buffer
	continue
	    buffer = string
	    read(unit=buffer, fmt="(i)", iostat=ios) result
	end function
    end function

    type(VARYING_STRING) function itoa_scalar(i) result(result)
	integer, intent(in):: i
	character(len = 30):: buffer
    continue
	write(unit=buffer, fmt="(i30)") i
	result = trim(adjustl(buffer))
    end function

end module
