! gtdata_variable.f90 - gtool ѿμ³
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtdata_generic

    !
    ! ܳư
    !

    interface open
	subroutine GTVarOpen(var, url, writable, err)
	    use iso_varying_string, only: VARYING_STRING    
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(inout):: var
	    type(VARYING_STRING), intent(in):: url
	    logical, intent(in), optional:: writable
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface create
	subroutine GTVarCreate(var, url, type, dims, overwrite, err)
	    use iso_varying_string, only: VARYING_STRING    
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(inout):: var
	    type(VARYING_STRING), intent(in):: url
	    character(len = *), intent(in):: type
	    type(GT_VARIABLE), intent(in):: dims
	    logical, intent(in), optional:: overwrite
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface close
	subroutine GTVarClose(var, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(inout):: var
	    logical, intent(out), optional:: err
	end subroutine
    end interface

    interface url
	function GTVarUrl(var) result(result)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(VARYING_STRING):: result
	    type(GT_VARIABLE), intent(in):: var
	end function
    end interface

    !
    ! °ط
    !

    interface attr_rewind
	subroutine GTVarAttrRewind(var)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	end subroutine
    end interface

    interface attr_next
	subroutine GTVarAttrNext(var, name, end)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(out):: name
	    logical, intent(out), optional:: end
	end subroutine
    end interface

    interface attr_true
	logical function GTVarAttrTrue(var, name, default)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    logical, intent(in), optional:: default
	end function
    end interface

    interface get_attr

	subroutine GTVarGetAttrReal(var, name, value, default)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    real, intent(out):: value(:)
	    real, intent(in), optional:: default
	end subroutine

	subroutine GTVarGetAttrInt(var, name, value, default)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    integer, intent(out):: value(:)
	    integer, intent(in), optional:: default
	end subroutine

    end interface

    interface put_attr

	subroutine GTVarPutAttrReal(var, name, value, default, err)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    real, intent(in):: value(:)
	    real, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

	subroutine GTVarPutAttrInt(var, name, value, default, err)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    integer, intent(in):: value(:)
	    integer, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

	subroutine GTVarPutAttrLogical(var, name, value, default, err)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	    logical, intent(in):: value
	    logical, intent(in), optional:: default
	    real, intent(out), optional:: err
	end subroutine

    end interface

    !
    ! ط
    !

    interface ndims_all
	integer function GTVarNDimsAll(var)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	end function
    end interface

    interface ndims
	integer function GTVarNDims(var)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	end function
    end interface

    interface dimsize
	integer function GTVarDimSize(var, name)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(GT_VARIABLE), intent(in):: var
	    type(VARYING_STRING), intent(in):: name
	end function
    end interface

    interface dimname
	function GTVarDimName(var, ord) result(result)
	    use gtdata_types, only: GT_VARIABLE
	    use iso_varying_string, only: VARYING_STRING    
	    type(VARYING_STRING):: result
	    type(GT_VARIABLE), intent(in):: var
	    integer, intent(in):: ord
	end function
    end interface

    interface slice
	subroutine GTVarSlice(var, dimord, start, count, stride)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    integer, intent(in):: dimord
	    integer, intent(in), optional:: start
	    integer, intent(in), optional:: count
	    integer, intent(in), optional:: stride
	end subroutine
    end interface

    interface get_slice
	subroutine GTVarGetSlice(var, dimord, start, count, stride)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    integer, intent(in):: dimord
	    integer, intent(out), optional:: start
	    integer, intent(out), optional:: count
	    integer, intent(out), optional:: stride
	end subroutine
    end interface

    interface slice_next
	subroutine GTVarSliceNext(var, dimord)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    integer, intent(in), optional:: dimord
	end subroutine
    end interface

    !
    ! 
    !

    interface get

	subroutine GTVarGetReal(var, value, nvalue, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(out):: value(*)
	    integer, intent(in):: nvalue
	    logical, intent(out):: err
	end subroutine

	subroutine GTVarGetReal1(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(out):: value(:)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine GTVarGetReal2(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(out):: value(:, :)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine GTVarGetReal3(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(out):: value(:, :, :)
	    logical, intent(out), optional:: err
	end subroutine

    end interface

    interface put

	subroutine GTVarPutReal(var, value, nvalue, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(in):: value(*)
	    integer, intent(in):: nvalue
	    logical, intent(out):: err
	end subroutine

	subroutine GTVarPutReal1(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(in):: value(:)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine GTVarPutReal2(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(in):: value(:, :)
	    logical, intent(out), optional:: err
	end subroutine

	subroutine GTVarPutReal3(var, value, err)
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    real, intent(in):: value(:, :, :)
	    logical, intent(out), optional:: err
	end subroutine

    end interface

end module
