! gtgraph_types.f90 - gtgraph ؤη
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_types

    use iso_varying_string, only: VARYING_STRING
    use gtdata_types, only: GT_VARIABLE

    type GT_AXIS
	type(GT_VARIABLE):: var
	real:: lower, upper
	logical:: vertical
    end type

    type GT_CONTOURS
	type(GT_VARIABLE):: var
	real:: interval
    end type

    type GT_FIGURE
	type(GT_AXIS):: h_axis
	type(GT_AXIS):: v_axis
	type(GT_CONTOURS):: contours
	type(VARYING_STRING):: title
	integer:: h_axis_given
	integer:: v_axis_given
	integer:: contours_given
    end type

    type GT_FRAME
	type(GT_FIGURE), pointer:: figs(:)
	integer:: n_figures
    end type

    type GT_DEVICE
	integer:: ws_id
    end type

end module
