! dc_string.f90 - character type support routines
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module dc_string

    use iso_varying_string

    interface stoi
	module procedure stoi_scalar
    end interface

    interface toString
	module procedure itos_scalar
        module procedure itos_array
        module procedure dtos_scalar
        module procedure dtos_array
    end interface

contains

    !
    ! 
    ! 
    ! Ƃ肠A܂
    !
    function QuoteDclControls(string) result(result)
        type(VARYING_STRING):: result
        type(VARYING_STRING), intent(in):: string
    continue
        result = replace(string, "_", ".", every=.TRUE.)
    end function

    integer function stoi_scalar(string) result(result)
	type(VARYING_STRING), intent(in):: string
	integer:: ios
        character(len = 80):: buffer
    continue
        buffer = string
        read(unit=buffer, fmt="(i80)", iostat=ios) result
	if (ios /= 0) result = 0
    end function

    !
    ! --- numerics to string ---
    !

    type(VARYING_STRING) function itos_scalar(i) result(result)
	integer, intent(in):: i
	character(len = 30):: buffer
    continue
	write(unit=buffer, fmt="(i30)") i
	result = trim(adjustl(buffer))
    end function

    type(VARYING_STRING) function itos_array(ibuf) result(result)
        integer, intent(in):: ibuf(:)
        integer:: i
    continue
        if (size(ibuf) <= 0) then
            result = ""
            return
        endif
        result = toString(ibuf(1))
        do, i = 2, size(ibuf)
            result = result // ", " // toString(ibuf(i))
        enddo
    end function

    type(VARYING_STRING) function dtos_scalar(d) result(result)
	double precision, intent(in):: d
	character(len = 40):: buffer
    continue
	write(unit=buffer, fmt="(g40.30)") i
	result = trim(adjustl(buffer))
    end function

    type(VARYING_STRING) function dtos_array(dbuf) result(result)
        double precision, intent(in):: dbuf(:)
        integer:: i
    continue
        if (size(dbuf) <= 0) then
            result = ""
            return
        endif
        result = toString(dbuf(1))
        do, i = 2, size(dbuf)
            result = result // ", " // toString(dbuf(i))
        enddo
    end function


end module
