! gtgraph_generic.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_generic

    use gtgraph_types, only: GT_AXIS

    interface Axis
	type(GT_AXIS) function GTAxisDefault(var, dimno, vertical)
	    use gtgraph_types, only: GT_AXIS
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	    integer, intent(in):: dimno
	    logical, intent(in), optional:: vertical
	end function
    end interface

    interface Contours
	type(GT_CONTOURS) function GTContDefault(var)
	    use gtgraph_types, only: GT_CONTOURS
	    use gtdata_types, only: GT_VARIABLE
	    type(GT_VARIABLE), intent(in):: var
	end function
    end interface

    interface Line
        type(GT_LINE) function GTLineDefault(var)
            use gtgraph_types, only: GT_LINE
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
        end function
    end interface

    interface Open

	subroutine GTDevOpen(dev, ws_id, err)
	    use gtgraph_types, only: GT_DEVICE
	    type(GT_DEVICE), intent(out):: dev
	    integer, intent(in), optional:: ws_id
	    logical, intent(out), optional:: err
	end subroutine

	subroutine GTFrameOpen(frame)
	    use gtgraph_types, only: GT_FRAME
	    type(GT_FRAME), intent(out):: frame
	end subroutine

	subroutine GTFigOpen(fig)
	    use gtgraph_types, only: GT_FIGURE
	    type(GT_FIGURE), intent(out):: fig
	end subroutine

    end interface

    interface Close

	subroutine GTDevClose(dev)
	    use gtgraph_types, only: GT_DEVICE
	    type(GT_DEVICE), intent(inout):: dev
	end subroutine

	subroutine GTFrameClose(frame)
	    use gtgraph_types, only: GT_FRAME
	    type(GT_FRAME), intent(inout):: frame
	end subroutine

	subroutine GTFigClose(fig)
	    use gtgraph_types, only: GT_FIGURE
	    type(GT_FIGURE), intent(inout):: fig
	end subroutine

        subroutine GTAxisClose(axis)
	    use gtgraph_types, only: GT_AXIS
	    type(GT_AXIS), intent(inout):: axis
        end subroutine

    end interface

    interface Put

	subroutine GTFigPutAxis(fig, axis, vertical)
	    use gtgraph_types, only: GT_FIGURE, GT_AXIS
	    type(GT_FIGURE), intent(inout):: fig
	    type(GT_AXIS), pointer:: axis
	    logical, intent(in), optional:: vertical
	end subroutine

	subroutine GTFigPutCont(fig, cont)
	    use gtgraph_types, only: GT_FIGURE, GT_CONTOURS
	    type(GT_FIGURE), intent(inout):: fig
	    type(GT_CONTOURS), intent(in):: cont
	end subroutine

	subroutine GTFigPutLine(fig, line)
	    use gtgraph_types, only: GT_FIGURE, GT_LINE
	    type(GT_FIGURE), intent(inout):: fig
	    type(GT_LINE), intent(in):: line
	end subroutine

	subroutine GTFramePutFig(frame, fig)
	    use gtgraph_types, only: GT_FRAME, GT_FIGURE
	    type(GT_FRAME), intent(out):: frame
	    type(GT_FIGURE), intent(in):: fig
	end subroutine

    end interface

    !
    ! ʂ̃[U Display() ĂяoB
    ! I Draw Tu[`QĂяoĂB
    ! 
    interface Display
 
	subroutine GTFrameDisplay(dev, frame)
	    use gtgraph_types, only: GT_DEVICE, GT_FRAME
	    type(GT_DEVICE), intent(inout):: dev
	    type(GT_FRAME), intent(inout):: frame
	end subroutine

	subroutine GTFigDisplay(dev, fig)
	    use gtgraph_types, only: GT_DEVICE, GT_FIGURE
	    type(GT_DEVICE), intent(inout):: dev
	    type(GT_FIGURE), intent(inout):: fig
	end subroutine

    end interface

    !
    ! Draw(..., paent) ͓I Display(dev, ...) 
    ! p邽߂ɂBparent ͒ʏ햳p[U
    ! ~X^CvŌĂяoȂ߂ Put Ƌtʒu
    ! tĂB
    !
    interface Draw

        subroutine GTAxesDraw(h_axis, v_axis, parent)
            use gtgraph_types, only: GT_AXIS, GT_FIGURE
            type(GT_AXIS), intent(in):: h_axis, v_axis
            type(GT_FIGURE), intent(in):: parent
        end subroutine

	subroutine GTContDraw(cont, parent)
	    use gtgraph_types, only: GT_CONTOURS, GT_FIGURE
	    type(GT_CONTOURS), intent(inout):: cont
            type(GT_FIGURE), intent(in):: parent
	end subroutine

        subroutine GTLineDraw(line, parent)
	    use gtgraph_types, only: GT_LINE, GT_FIGURE
	    type(GT_LINE), intent(inout):: line
            type(GT_FIGURE), intent(in):: parent
        end subroutine

	subroutine GTFigDraw(fig, parent)
	    use gtgraph_types, only: GT_FRAME, GT_FIGURE
	    type(GT_FIGURE), intent(inout):: fig
	    type(GT_FRAME), intent(in):: parent
	end subroutine

    end interface

end module
