module an_file

    use iso_varying_string, only: VARYING_STRING
    implicit none
    private

    type FILE_MEMO_ENTRY
        integer:: id
        integer:: count
        logical:: writable
        type(VARYING_STRING):: filename
        type(FILE_MEMO_ENTRY), pointer:: next
    end type

    type(FILE_MEMO_ENTRY), save, pointer:: memo_head
    logical, save:: memo_used = .FALSE.

    public:: ANFileOpen, ANFileClose, ANFileReopen

contains

    subroutine ANFileOpen(fileid, filename, writable, err)
        use iso_varying_string, only: &
            VARYING_STRING, operator(==), char, assignment(=)
        use netcdf_f77, only: NF_INQ_VARID, NF_WRITE, NF_NOWRITE, &
            NF_NOERR, NF_CLOBBER, NF_OPEN, NF_CREATE
        use dc_error, only: StoreError
        implicit none
        integer, intent(out):: fileid
        type(VARYING_STRING), intent(in):: filename
        logical, intent(in), optional:: writable
        logical, intent(out), optional:: err
        logical:: writable_required
        type(FILE_MEMO_ENTRY), pointer:: memop, prev
        integer:: stat, mode
    continue
        writable_required = .FALSE.
        if (present(writable)) writable_required = writable
        !
        ! Oŏ݉\KĂ nf_open Ȃōς܂
        !
        if (memo_used) then
            memop => memo_head
            nullify(prev)
            do
                if ((memop%filename == filename) &
                .and. (memop%writable .or. .not. writable_required)) then
                    fileid = memop%id
                    memop%count = memop%count + 1
                    if (present(err)) err = .FALSE.
                    return
                endif
                prev => memop
                memop => memop%next
                if (.not. associated(memop)) exit
            enddo
            allocate(memop)
            prev%next => memop
        else
            allocate(memo_head)
            memop => memo_head
            memo_used = .TRUE.
        endif
        nullify(memop%next)
        memop%filename = filename
        memop%writable = writable_required
        memop%count = 1

        mode = NF_NOWRITE
        if (writable_required) mode = ior(mode, NF_WRITE)
        stat = nf_open(char(filename), mode, memop%id)
        if (stat /= NF_NOERR .and. writable_required) then
            mode = NF_CLOBBER
            stat = nf_create(char(filename), mode, memop%id)
        endif
        fileid = memop%id
        call StoreError(stat, 'ANFileOpen', err, cause_s=filename)
    end subroutine

    ! t@Cԍ̎QƃJEg𑝉B
    subroutine ANFileReopen(fileid, err)
        use netcdf_f77
        use dc_error, only: StoreError
        implicit none
        integer, intent(in):: fileid
        logical, intent(out), optional:: err
        type(FILE_MEMO_ENTRY), pointer:: memop
    continue
        if (memo_used) then
            memop => memo_head
            do
                if (memop%id == fileid) then
                    memop%count = memop%count + 1
                    if (present(err)) err = .FALSE.
                    return
                endif
                memop => memop%next
                if (.not. associated(memop)) exit
            enddo
        endif
        call StoreError(NF_ENOTNC, 'ANFileReopen', err, cause_i=fileid)
    end subroutine

    ! Ȃ id ̃t@C̎QƃJE^ZA[ɂȂ
    subroutine ANFileClose(fileid, err)
        use netcdf_f77, only: NF_CLOSE, NF_ENOTNC, NF_NOERR
        use dc_error, only: StoreError
        integer, intent(in):: fileid
        logical, intent(out), optional:: err
        type(FILE_MEMO_ENTRY), pointer:: memop, prev
        integer:: stat
    continue
        stat = NF_ENOTNC
        if (.not. memo_used) goto 999
        memop => memo_head
        nullify(prev)
        do
            if (.not. associated(memop)) goto 999
            if (memop%id == fileid) exit
            prev => memop
            memop => memop%next
        enddo
        memop%count = memop%count - 1
        if (memop%count <= 0) then
            stat = nf_close(fileid)
            if (associated(prev)) then
                prev%next => memop%next
            else
                memo_head => memop%next
                if (.not. associated(memo_head)) memo_used = .FALSE.
            endif
            deallocate(memop)
        else
            stat = NF_NOERR
        endif
    999 continue
        call StoreError(stat, 'ANFileClose', err)
    end subroutine

end module an_file
