! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtattr - ݒc[

program gtattr
    use gtool
    implicit none
    type(VARYING_STRING):: argument
    type(VARYING_STRING):: optname, optvalue
    type(GT_VARIABLE):: var
    logical:: var_opened = .FALSE.
    integer:: i, j, argc
    character(len = 20):: attr_type
continue
    attr_type = "character"
    do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (GtOptionForm(argument, optname, optvalue)) then
            if (optname == "-type") then
                attr_type = optvalue
            else if (optname == "-delete") then
                if (var_opened) then
                    call del_attr(var, char(optvalue))
                else
                    print *, "option -delete before varname ignored"
                endif
            else if (var_opened .and. index(optname, "-") /= 1) then
                call put_attr(var, char(optname), char(optvalue), xtype=attr_type)
            else
                print *, "option ", char(optvalue), " ignored"
            endif
        else if (.not. var_opened) then
            call Open(var, argument, writable=.TRUE.)
            var_opened = .TRUE.
        else
            print *, "unknown argument ", char(argument), " ignored"
        endif
    enddo
    if (var_opened) then
        call Close(var)
    else
        write(*, *) 'usage: gtattr var [-delete=attr] [attrname=value] ...'
    endif
end program
