! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarPutAttrInt(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode
    use netcdf_f77, only: NF_PUT_ATT_INT, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE, NF_INT
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, intent(in):: value(:)
    logical, intent(out), optional:: err
    integer:: stat
continue
    if (size(value) == 0) then
        stat = nf_del_att(var%fileid, var%varid, name=name)
        goto 999
    endif
    stat = nf_put_att_int(var%fileid, var%varid, name=name, &
        xtype=NF_INT, len=size(value), ivals=value)
    if (stat == NF_NOERR) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_put_att_int(var%fileid, var%varid, name=name, &
        xtype=NF_INT, len=size(value), ivals=value)
    999 continue
    call StoreError(stat, 'ANVarPutAttrInt', err)
end subroutine
