! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarPutAttrReal(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode
    use netcdf_f77, only: NF_PUT_ATT_REAL, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE, NF_FLOAT
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, intent(in):: value(:)
    logical, intent(out), optional:: err
    integer:: stat
continue
    if (size(value) == 0) then
        stat = nf_del_att(var%fileid, var%varid, name=name)
        goto 999
    endif
    stat = nf_put_att_real(var%fileid, var%varid, name=name, &
        xtype=NF_FLOAT, len=size(value), rvals=value)
    if (stat == NF_NOERR) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_put_att_real(var%fileid, var%varid, name=name, &
        xtype=NF_FLOAT, len=size(value), rvals=value)
    999 continue
    call StoreError(stat, 'ANVarPutAttrReal', err)
end subroutine
