! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

! ϐ̓o͔͈͂w肷邽߂̂ƂnIEʁB
! ȗ͓YݒȂׂsςɕۂB
! Jn_ɂ͕lwłāAtɐʒuwB
! ɂ͕lwłāAΒl]B
! ĂȂׂȎws悤IɏC邽߁A
! sȕϐ邢͎ԍɋNG[ȊO͋NȂB

subroutine ANVarSlice(var, dimord, start, count, stride)
    use an_types, only: AN_VARIABLE
    use dc_error
    use netcdf_f77
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    integer, intent(in):: dimord
    integer, intent(in), optional:: start
    integer, intent(in), optional:: count
    integer, intent(in), optional:: stride
    integer:: stat, maxindex, maxcount
    stat = GT_ENOMOREDIMS
    if (.not. associated(var%count)) then
        goto 999
    else if (dimord > size(var%count)) then
        goto 999
    endif
    maxindex = var%allcount(dimord)
    if (present(start)) then
        if (start < 0) then
            ! Ə璷Ƃ͂킩?
            var%start(dimord) = min(maxindex, max(1, maxindex + 1 + start))
        else
            var%start(dimord) = min(maxindex, max(1, start))
        endif
    endif
    if (present(stride)) then
        var%stride(dimord) = min(maxindex, max(1, stride))
    endif
    if (present(count)) then
        var%count(dimord) = abs(count)
    endif
    maxcount = 1 + (maxindex - var%start(dimord)) / var%stride(dimord)
    var%count(dimord) = max(1, min(maxcount, var%count(dimord)))
    stat = NF_NOERR
    999 continue
    call StoreError(stat, "ANVarSlice")
end subroutine

subroutine ANVarGetSlice(var, dimord, start, count, stride)
    use an_types, only: AN_VARIABLE
    use dc_error
    use netcdf_f77
    implicit none
    type(AN_VARIABLE), intent(in):: var
    integer, intent(in):: dimord
    integer, intent(out), optional:: start
    integer, intent(out), optional:: count
    integer, intent(out), optional:: stride
    integer:: stat
    stat = 0
    if (.not. associated(var%count)) then
        stat = NF_ENOTVAR
        goto 999
    endif
    if (dimord < 0 .or. dimord > size(var%count)) then
        stat = NF_EINVALCOORDS
        goto 999
    endif
    if (present(start)) start = var%start(dimord)
    if (present(count)) count = var%count(dimord)
    if (present(stride)) stride = var%stride(dimord)
999 continue
    call StoreError(stat, "ANVarGetSlice")
end subroutine

! 鎟 dimord ɂĂ̓o͔͈͂XChB
!  stat=0, G[Ȃ stat<0, ͈͏IȂ stat>0 ƂȂB
! stride S 1 Ȃ΁Adimord=0 ɂ ANVarSliceNext Ăׂ
! Sz𑖍邱ƂłB

subroutine ANVarSliceNext(var, dimord, stat)
    use an_types, only: AN_VARIABLE
    use netcdf_f77
    type(AN_VARIABLE), intent(inout):: var
    integer, intent(in), optional:: dimord
    integer, intent(out):: stat
    integer:: i
    if (dimord > 0) then
        call do_slice_next(dimord)
    else if (dimord == 0) then
        i = 1
        do
            call do_slice_next(i)
            if (stat <= 0) exit
            i = i + 1
        enddo
    else
        stat = -abs(NF_ERANGE)
    endif
contains

    subroutine do_slice_next(idim)
        use an_generic, only: ANVarNdimsAll
        integer, intent(in):: idim
        integer:: newstart
        if (idim <= 0 .or. idim > ANVarNdimsAll(var)) then
            stat = -abs(NF_ERANGE)
            return
        endif
        newstart = var%start(idim) + var%count(idim) * var%stride(idim)
        if (newstart + (var%count(idim) - 1) * var%stride(idim) > var%allcount(idim)) then
            stat = 1
        else
            var%start(idim) = newstart
            stat = 0
        endif
    end subroutine

end subroutine
