! dc_url.f90 - ϐ URL ̕
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

module dc_url

    implicit none

    public:: UrlSplit, IORangeParse, GuessDriver, UrlResolve

    interface UrlMerge
        module procedure UrlMergeSO3
        module procedure UrlMergeFVAI
        module procedure UrlMergeFV
    end interface

    interface operator(.OnTheSameFile.)
        module procedure UrlOnTheSameFile
    end interface

contains

    ! ANUrlMerge - ϐ URL ̍
    ! 󕶎̐͂ȂƂ݂ȂB

        type(VARYING_STRING) function &
    UrlMergeSO3(file, var, attr, iorange) result(result)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: file
        type(VARYING_STRING), intent(in), optional:: var
        type(VARYING_STRING), intent(in), optional:: attr
        type(VARYING_STRING), intent(in), optional:: iorange
        result = file // "@"
        if (present(var)) result = result // var
        if (present(attr)) then
            if (attr /= "") result = result // ":" // attr
        endif
        if (present(iorange)) then
            if (extract(iorange, 1, 1) == ",") then
                result = result // iorange
            else if (iorange /= "") then
                result = result // "," // iorange
            endif
        endif
    end function

        type(VARYING_STRING) &
    function UrlMergeFVAI(file, var, attr, iorange) result(result)
        use iso_varying_string
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
        character(len = *), intent(in):: attr
        character(len = *), intent(in):: iorange
    continue
        result = UrlMerge(var_str(file), var_str(var), var_str(attr), &
            & var_str(iorange))
    end function

        type(VARYING_STRING) &
    function UrlMergeFV(file, var) result(result)
        use iso_varying_string
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
    continue
        result = UrlMerge(var_str(file), var=var_str(var))
    end function

    ! UrlSplit - ϐ URL ̕
    ! Ȃɂ͋󕶎񂪑B

    subroutine UrlSplit(fullname, file, var, attr, iorange)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: fullname
        type(VARYING_STRING), intent(out), optional::        file, var, attr, iorange
        type(VARYING_STRING):: varpart
        integer:: atmark, colon, comma
        character(len = *), parameter:: VARNAME_SET &
            = "0123456789eEdD+-=^,:_" &
            // "ABCDEFGHIJKLMNOPQRSTUVWXYZ" &
            // "abcdefghijklmnopqrstuvwxyz"
    continue
        ! ܂ URL ƕϐw𕪗BURL  @ ܂݂
        ! ߁AŌ @ ȍ~ɑ΂ĕϐƂċȂ
        ! iT^Iɂ '/'j܂܂Ă
        ! Y @  URL ̈ꕔƂ݂ȂB
        atmark = index(fullname, '@', .TRUE.)
        if (atmark /= 0) then
            varpart = extract(fullname, atmark + 1)
            if (verify(varpart, VARNAME_SET) /= 0) then
                atmark = 0
            endif
        endif
        if (atmark == 0) then
            ! ϐw͂ȂB
            if (present(file)) file = fullname
            if (present(var)) var = ''
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = ''
            return
        endif
        ! ϐw肪B
        if (present(file)) file = extract(fullname, 1, atmark - 1)
        ! ͈͎wTB
        comma = index(varpart, ',')
        if (comma /= 0) then
            ! ͈͎w肪݂B
            if (present(var)) var = extract(varpart, 1, comma - 1)
            if (present(attr)) attr = ''
            if (present(iorange)) iorange = extract(varpart, comma + 1)
            return
        endif
        if (present(iorange)) iorange = ''
        ! ͈͎w肪Ȃ̂ŁǍB
        colon = index(varpart, ':')
        if (colon == 0) then
            if (present(var)) var = varpart
            if (present(attr)) attr = ''
            varpart = ''
            return
        endif
        if (present(var)) var = extract(varpart, 1, colon - 1)
        if (present(attr)) attr = extract(varpart, colon + 1)
        varpart = ''
    end subroutine

    !
    ! --- o͔͈͎w蕶̉ ---
    !
    ! o͔͈͎wQ iorange ͂Bŏ͈͎̔w肪͂A
    !  dimname, (, , Ԋu)  range(1:3),
    ! c remainder Ɋi[BG[͋󕶎񂪊i[B
    ! Pڂ '^' ƂȂĂꍇ͏ range ̑SvfYwƂ݂ȂB
    !
    ! Ƃ "lon=-4.245:+84.2e0,^lat=1:13:2" ͂
    ! x:  
    !   dimname="lon", range=(/"-4.245", "+84.2e0", ""/), remainder="^lat=1:13:2"
    ! x:
    !   dimname="lat", range=(/"^1", "^13", "^2"/), remainder=""
    !
    subroutine IORangeParse(iorange, dimname, range, remainder)
        use iso_varying_string
        implicit none
        type(VARYING_STRING), intent(in):: iorange
        type(VARYING_STRING), intent(out):: dimname
        type(VARYING_STRING), intent(out):: range(3)
        type(VARYING_STRING), intent(out):: remainder
        type(VARYING_STRING):: word
        integer:: comma, equal, colon, i
        logical:: hat_all
    continue
        ! iorange ɐsR}ΏÔ word ɓ
        comma = index(iorange, ",")
        if (comma == 1) then
            comma = verify(iorange, ",")
            word = extract(iorange, comma)
        else
            word = iorange
        endif
        if (len(word) == 0) goto 900
        ! word R}ȉ remainder ɓ
        comma = index(word, ",")
        if (comma == 0) then
            remainder = ""
        else
            remainder = extract(word, comma + 1)
            word = extract(word, 1, comma - 1)
        endif
        ! ŏ = ܂ł
        equal = index(word, "=")
        dimname = extract(word, 1, equal - 1)
        word = extract(word, equal + 1)
        ! ̐擪 '^' ΑS̐l '^' ŝƓ
        hat_all = (index(dimname, '^') == 1)
        if (hat_all) dimname = extract(dimname, 2)
        !  = ȂȂ΃G[
        if (len(dimname) == 0) goto 900
        ! Rŋ؂
        do, i = 1, 3
            colon = index(word, ':')
            if (colon > 0) then
                range(i) = extract(word, 1, colon - 1)
                word = extract(word, colon + 1)
            else
                range(i) = word
                if (i > 1) word = ""
            endif
            if (hat_all .and. index(dimname, '^') /= 1) then
                range(i) = '^' // range(1)
            endif
        enddo
        return
    ! --- ͂ł镶cĂȂꍇ ---    
    900 continue
        dimname = "";  remainder = ""
        range(:) = (/(var_str(""), i = 1, 3)/)
    end subroutine

    !
    ! === ϐURL ̐ ===
    !
    ! ϐ URL t@C URL ؂oĔ肷B
    ! URL  .nc ŏI΁Aan (Abstract NetCDF) ŃANZXB
    ! URL  .ctl ŏI΁Agr (GrADS) ŃANZXB
    ! ȊȌꍇAƂ肠 an ŃANZXB

    subroutine GuessDriver(url, driver)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: url
        type(VARYING_STRING), intent(out):: driver
        type(VARYING_STRING):: filepart
        integer:: length
        call UrlSplit(url, file=filepart)
        length = len(filepart)
        if (extract(filepart, length - 3) == ".ctl") then
            driver = "gr"
        else
            driver = "an"
        endif
    end subroutine

    !
    ! === t@CɍڂĂ邩ǂ ===
    !

    logical function UrlOnTheSameFile(url_a, url_b) result(result)
        use iso_varying_string
        type(VARYING_STRING), intent(in):: url_a
        type(VARYING_STRING), intent(in):: url_b
        type(VARYING_STRING):: filepart_a
        type(VARYING_STRING):: filepart_b
        call UrlSplit(url_a, file=filepart_a)
        call UrlSplit(url_b, file=filepart_b)
        result = (filepart_a == filepart_b)
    end function

    !
    ! === ΃N ===
    !

    type(VARYING_STRING) function UrlResolve(relative, base) result(result)
        use iso_varying_string
        use dc_string, only: StrHead
        type(VARYING_STRING), intent(in):: relative
        type(VARYING_STRING), intent(in):: base
        integer, parameter:: FILE = 1, VAR = 2, ATTR = 3, IOR = 4
        type(VARYING_STRING):: rel(FILE:IOR), bas(FILE:IOR)
        character(3), parameter:: PATHDELIM = "/:" // achar(94)
        integer:: idir_r, idir_b
        call UrlSplit(relative, file=rel(FILE), var=rel(VAR), &
            & attr=rel(ATTR), iorange=rel(IOR))
        call UrlSplit(base, file=bas(FILE), var=bas(VAR), &
            & attr=bas(ATTR), iorange=bas(IOR))
        if (rel(FILE) == "") then
            rel(FILE) = bas(FILE)
            if (rel(VAR) == "") rel(VAR) = bas(VAR)
            result = UrlMerge(file=rel(FILE), var=rel(VAR), &
                    & attr=rel(ATTR), iorange=rel(IOR))
            return
        endif
        ! --- ΃pX̃t@C ---
        if (StrHead(rel(FILE), "file:") &
            & .OR. StrHead(rel(FILE), "http:") &
            & .OR. StrHead(rel(FILE), "ftp:") &
            & .OR. StrHead(rel(FILE), "news:") &
            & .OR. StrHead(rel(FILE), "www") &
            & .OR. StrHead(rel(FILE), "/") &
            & .OR. StrHead(rel(FILE), achar(94)) &
            & .OR. extract(rel(FILE), 2, 1) == ":" &
            ) then
            result = relative
            return
        endif
        idir_b = scan(char(bas(FILE)), PATHDELIM, back=.TRUE.) 
        if (idir_b == 0) then
            result = relative
            return
        endif
        idir_r = scan(char(rel(FILE)), PATHDELIM, back=.TRUE.)
        result = extract(base, 1, idir_b) // extract(relative, idir_r + 1)
    end function

end module
