! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GtFigPutObject(fig, obj)
    use gtgraph_types, only: GT_FIGURE, GT_OBJECT
    use gtgraph_generic, only: Put
    use dc_error, only: StoreError, GT_EFAKE
    type(GT_FIGURE), intent(inout):: fig
    type(GT_OBJECT), intent(inout):: obj
    if (associated(obj%line)) then
        call Put(fig, obj%line)
    else if (associated(obj%cont)) then
        call Put(fig, obj%cont)
    else if (associated(obj%fig)) then
        ! Ȃ񂾂ς...
        if (.not.(associated(obj%fig%contours) &
            & .or. associated(obj%fig%line))) then
            return
        else if (.not.(associated(fig%contours) &
            & .or. associated(fig%line))) then
            fig = obj%fig
        else
            call StoreError(GT_EFAKE, "GTFigPutObject(FIG)")
        endif
    else if (associated(obj%axis)) then
        continue
    else
        call StoreError(GT_EFAKE, "GTFigPutObject(UNKNOWN)")
    endif
end subroutine
