! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GtObjOpen(obj)
    use gtgraph_types, only: GT_OBJECT
    type(GT_OBJECT), intent(out):: obj
entry GtObjClear(obj)
    nullify(obj%axis, obj%cont, obj%line)
    nullify(obj%fig, obj%frame, obj%next)
end subroutine

recursive subroutine GTObjLoad(obj, varname)
    use iso_varying_string
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Load
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open
    type(GT_OBJECT), intent(out):: obj
    type(VARYING_STRING), intent(in):: varname
    type(GT_VARIABLE):: var
    call Open(var, varname)
    call Load(obj, var)
end subroutine

recursive subroutine GTObjLoadVar(obj, var)
    use gtgraph_types, only: GT_OBJECT
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, ndims
    use gtgraph_generic, only: Open, Clear, Load
    use iso_varying_string, only: VARYING_STRING, operator(==)
    use dc_error
    type(GT_OBJECT), intent(out):: obj
    type(GT_VARIABLE), intent(in):: var
    type(VARYING_STRING):: var_class
continue
    call Clear(obj)
    call get_attr(var, "gt_structure_class", var_class, default="data")
    if (var_class == "frame") then
        allocate(obj%frame)
        call Open(obj%frame)
        call Load(obj%frame, var)
    else if (var_class == "figure") then
        allocate(obj%fig)
        call Open(obj%fig)
        call Load(obj%fig, var)
    else if (var_class == "contours") then
        allocate(obj%cont)
        call Load(obj%cont, var)
    else if (var_class == "line") then
        allocate(obj%line)
        call Load(obj%line, var)
    else if (var_class == "axis") then
        allocate(obj%axis)
        call Load(obj%line, var)
    else
        select case(ndims(var))
        case(1)
            allocate(obj%line)
            call Open(obj%line, var)
        case(2:)
            allocate(obj%cont)
            call Open(obj%cont, var)
        case default
            call StoreError(GT_EFAKE, 'GtObjLoadVar(ndims = 0)')
        end select
    endif
end subroutine

recursive subroutine GtObjClose(obj)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Close
    type(GT_OBJECT), intent(out):: obj
    if (associated(obj%next)) then
        call GtObjClose(obj%next)
        deallocate(obj%next)
    endif
    if (associated(obj%axis)) then
        deallocate(obj%axis)
        call close(obj%axis)
    endif
    if (associated(obj%cont)) then
        deallocate(obj%cont)
        call Close(obj%cont)
    endif
    if (associated(obj%line)) then
        deallocate(obj%line)
        call Close(obj%line)
    endif
    if (associated(obj%fig)) then
        deallocate(obj%fig)
        call Close(obj%fig)
    endif
    if (associated(obj%frame)) then
        deallocate(obj%frame)
        call Close(obj%frame)
    endif
end subroutine

character(len = 8) function GtObjType(obj) result(result)
    use gtgraph_types, only: GT_OBJECT
    type(GT_OBJECT), intent(in):: obj
    if (associated(obj%axis)) then
        result = "axis"
    else if (associated(obj%cont)) then
        result = "contours"
    else if (associated(obj%line)) then
        result = "line"
    else if (associated(obj%fig)) then
        result = "figure"
    else if (associated(obj%frame)) then
        result = "frame"
    else
        result = ""
    endif
end function


subroutine GtObjOption(obj, optname, value, err)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Option
    type(GT_OBJECT), intent(inout):: obj
    character(len = *), intent(in):: optname
    character(len = *), intent(in):: value
    logical, intent(out):: err
continue
    if (associated(obj%cont)) then
        call Option(obj%cont, optname, value, err)
    else if (associated(obj%line)) then
        call Option(obj%line, optname, value, err)
    else if (associated(obj%fig)) then
        call Option(obj%fig, optname, value, err)
    else
        err = .TRUE.
    endif
end subroutine

    ! --- GtObjPutObj --- 
    ! put ̌
    !  child  parent ̂ʂ̃NX̂̂ێB
    !  ʃNX̏ꍇ͒NX쐬҂˂ށB
    !  (҂Ƃ frame ̏ꍇ next ɘA)
subroutine GTObjPutObj(parent, child)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: type, Put, Clear, Open
    type(GT_OBJECT), intent(inout), target:: parent
    type(GT_OBJECT), intent(inout):: child
    character(len = 8):: child_type, parent_type
    type(GT_OBJECT), pointer:: objp
continue
    child_type = Type(child)
    parent_type = Type(parent)
    ! --- ǂ炩ȂłȂق parent  ---
    if (child_type == "") return
    if (parent_type == "") then
        ! eȂ炽ڂ
        parent = child
        call Clear(child)
        return
    endif
    ! --- next Nꍇ ---
    ! Ƃ肠ȗ
    ! --- }`vfǂ̑ ---
    if (parent_type == "frame") then
        ! eqƂɘgȂAAȊÔ̂͘gɐݒu
        select case(child_type)
        case("frame")
            goto 1000
        case("figure")
            call put(parent%frame, child%fig)
        case("contours")
            allocate(child%fig)
            call put(child%fig, child%cont)
            call put(parent%frame, child%fig)
        case("line")
            allocate(child%fig)
            call put(child%fig, child%line)
            call put(parent%frame, child%fig)
        case("axis")
            allocate(child%fig)
            call put(child%fig, child%axis)
            call put(parent%frame, child%fig)
        end select
    else if (child_type == "frame") then
        ! e͘gȉȂ̂Ŏq̒ɐݒu
        select case(parent_type)
        case("figure")
            call Put(child%frame, parent%fig)
        case("contours")
            allocate(parent%fig)
            call put(parent%fig, parent%cont)
            call Put(child%frame, parent%fig)
        case("line")
            allocate(parent%fig)
            call put(parent%fig, parent%line)
            call Put(child%frame, parent%fig)
        case("axis")
            allocate(parent%fig)
            call put(parent%fig, parent%axis)
            call Put(child%frame, parent%fig)
        end select
        call Clear(parent)
        parent%frame => child%frame
    else if (parent_type == "figure") then
        select case(child_type)
        case("figure")
            allocate(parent%frame)
            call Open(parent%frame)
            call Put(parent%frame, parent%fig)
            nullify(parent%fig)
            call Put(parent%frame, child%fig)
        case("contours")
            call Put(parent%fig, child%cont)
        case("line")
            call Put(parent%fig, child%line)
        case("axis")
            call Put(parent%fig, child%axis)
        end select
    else if (child_type == "figure") then
        ! e͐}ȉȂ̂Ŏq̐}̒ɐe̗vfu
        select case(parent_type)
        case("contours")
            call Put(child%fig, parent%cont)
        case("line")
            call Put(child%fig, parent%line)
        case("axis")
            call Put(child%fig, parent%axis)
        end select
        call Clear(parent)
        parent%fig => child%fig
    else
        ! eq}ȉ̏ꍇ͂Ƃɂ}ė
        allocate(parent%fig)
        call Open(parent%fig)
        select case(parent_type)
        case("contours")
            call Put(parent%fig, parent%cont)
            nullify(parent%cont)
        case("line")
            call Put(parent%fig, parent%line)
            nullify(parent%line)
        case("axis")
            call Put(parent%fig, parent%axis)
            nullify(parent%axis)
        end select
        select case(child_type)
        case("contours")
            call Put(parent%fig, child%cont)
        case("line")
            call Put(parent%fig, child%line)
        case("axis")
            call Put(parent%fig, child%axis)
        end select
    endif
    call Clear(child)
    return

    1000 continue
        objp => parent
        do
            if (.not. associated(objp%next)) exit
            objp => objp%next
        enddo
        ! child ւ̃|C^͓Tu[`𔲂ƖɂȂ̂ŁA
        ! ʎ̂蓖ĂĂBF̃|C^Ȃ̂ōB
        allocate(objp%next)
        objp%next = child
        call Clear(child)
    return
end subroutine
