module gtool_url

    use an_url, only: AnUrlMerge, UrlSplit => AnUrlSplit
    implicit none

    interface UrlMerge
        module procedure AnUrlMerge
        module procedure GTUrlMergeFVAI
        module procedure GTUrlMergeFV
    end interface

contains

        type(VARYING_STRING) &
    function GTUrlMergeFVAI(file, var, attr, iorange) result(result)
        use iso_varying_string
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
        character(len = *), intent(in):: attr
        character(len = *), intent(in):: iorange
    continue
        if (attr /= "") then
            result = AnUrlMerge(var_str(file), var=var_str(var), attr=var_str(attr))
        else if (iorange /= "") then
            result = AnUrlMerge(var_str(file), var=var_str(var), iorange=var_str(attr))
        else
            result = AnUrlMerge(var_str(file), var=var_str(var))
        endif
    end function

        type(VARYING_STRING) &
    function GTUrlMergeFV(file, var) result(result)
        use iso_varying_string
        character(len = *), intent(in):: file
        character(len = *), intent(in):: var
    continue
        result = AnUrlMerge(var_str(file), var=var_str(var))
    end function

end module