! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! Create(var, url, copyfrom, [copyvalue], [overwrite], [err])
! ͕ϐ copyfrom ƓAϐ쐬B
! KvȂΎϐB
! copyvalue ^Ɏw肷ƒlB
!
! ȂAϐ̕ copyfrom  url قȂt@C
! ڂĂꍇɍsȂB netCDF/an z肵̂
! ق̃t@C`ǉꂽƂɂ͕ύXv邩ȂB

subroutine GTVarCreateCopy(var, url, copyfrom, copyvalue, &
    & overwrite, err)
    use gtdata_types, only: GT_VARIABLE
    use iso_varying_string, only: VARYING_STRING, char
    use gtdata_generic, only: Open, NDims, Close, Create
    use dc_error
    type(GT_VARIABLE), intent(out):: var
    type(VARYING_STRING), intent(in):: url
    type(GT_VARIABLE), intent(inout):: copyfrom
    logical, intent(in), optional:: copyvalue
    logical, intent(in), optional:: overwrite
    logical, intent(out), optional:: err
    type(GT_VARIABLE), allocatable:: vDimSource(:)
    type(GT_VARIABLE), allocatable:: vDimDest(:)
    integer:: i, nd, stat
    logical:: myerr
    stat = 0
    myerr = .FALSE.
    nd = NDims(copyfrom)
    allocate(vDimSource(nd), vDimDest(nd), stat=stat)
    if (stat /= 0) goto 999
    do, i = 1, nd
        call Open(vDimSource(i), copyfrom, dimord=i, err=myerr)
        call GTVarCopyDim(to=vDimDest(i), from=vDimSource(i), &
            & target=url)
    enddo
    call Create(var, url=char(url), dims=vDimDest, err=err)
    call GTVarCopyValue(to=var, from=copyfrom)
    do, i = 1, nd
        call Close(vDimSource(i))
        call Close(vDimDest(i))
    enddo
    deallocate(vDimSource, vDimDest, stat=stat)
999 continue
    if (stat /= 0) then
        call StoreError(GT_ENOMEM, "GTVarCreateCopy", err)
    else if (present(err)) then
        err = myerr
    else if (myerr) then
        call DumpError
    endif
contains

    ! from Ɠe̕ϐ URL target Ŏϐ̍쐬
    ! ƂĎg悤 to ɕʁB
    ! ȂׂăI[vōς܂ƂB
    subroutine GTVarCopyDim(to, from, target)
        use gtdata_types
        use iso_varying_string
        use dc_url, only: UrlSplit, operator(.onthesamefile.)
        use gtdata_generic, only: Open, url, size, create, get_xtype
        type(GT_VARIABLE), intent(out):: to
        type(GT_VARIABLE), intent(inout):: from
        type(VARYING_STRING), intent(in):: target
        type(VARYING_STRING):: xtype, to_url
        integer:: length
        if (url(from) .onthesamefile. target) then
            call Open(to, from, dimord=0)
            return
        else if (LookupEquivalent(to, from)) then
            return
        else
            length = size(from)
            call Get_XType(from, xtype)
            call UrlSplit(target, file=to_url)
            ! t@C^VK쐬͕ϐ
            call Create(to, char(to_url), length, char(xtype))
            call GTVarCopyValue(to, from)
            return
        endif
    end subroutine

    logical function LookupEquivalent(to, from) result(result)
        type(GT_VARIABLE):: to
        type(GT_VARIABLE), intent(in):: from
        result = .FALSE.
    end function

    ! łɑ݂ϐɂāAlƑRs[B
    !
    subroutine GTVarCopyValue(to, from)
        use gtdata_types, only: GT_VARIABLE
        use gtdata_generic, only: GTVarGetReal, GTVarPutReal, size, &
            Attr_Rewind, Attr_Next, Copy_Attr
        use dc_error, only: DumpError
        use iso_varying_string
        type(GT_VARIABLE), intent(inout):: to
        type(GT_VARIABLE), intent(inout):: from
        type(VARYING_STRING):: aname
        real, allocatable:: rbuffer(:)
        logical:: err, end
        integer:: siz
        ! ̃Rs[
        call Attr_Rewind(from)
        do
            call Attr_Next(from, aname, end)
            if (end) exit
            call Copy_Attr(to=to, attrname=char(aname), &
                & from=from, err=err)
            if (err) call DumpError()
        enddo
        ! l̃Rs[
        siz = size(from)
        allocate (rbuffer(siz))
        call GTVarGetReal(from, rbuffer, siz, err)
        if (err) call DumpError()
        call GtVarPutReal(to, rbuffer, siz, err)
        if (err) call DumpError()
        deallocate (rbuffer)
    end subroutine

end subroutine

