! GTLineSave - }ϐƂĕۑ
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTLineSave(Line, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_LINE
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, get_attr, add_member, url
    use iso_varying_string
    type(GT_LINE), intent(inout):: Line
    type(VARYING_STRING), intent(in), optional:: name
    type(VARYING_STRING), intent(out), optional:: name_result
    type(VARYING_STRING):: vname, title, member
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        vname = GTGraphSaveName()
    endif
    call get_attr(Line%var, "long_name", title)
    title = "line graph of " // title
    call Create(var, char(vname), xtype="int", overwrite=.TRUE., &
        long_name=char(title))
    call Put_Attr(var, "gt_structure_class", "LINE")
    call Put_Attr(var, "gt_line_index", (/line%index/))
    call Put_Attr(var, "gt_line_type", (/line%type/))
    call Put_Attr(var, "gt_line_mark", (/line%mark/))

    ! }̃oɂȂĂ̂̏o
    call add_member(var, url(Line%var), link_name="data")
    if (associated(Line%v_axis)) then
        if (Line%v_axis%saved /= "") then
            call add_member(var, Line%v_axis%saved, link_name="vaxis")
        else
            call Save(Line%v_axis, resultname=member)
            call add_member(var, member, link_name="vaxis")
        endif
    endif
    if (associated(Line%h_axis)) then
        if (Line%h_axis%saved /= "") then
            call add_member(var, Line%h_axis%saved, link_name="haxis")
        else
            call Save(Line%h_axis, resultname=member)
            call add_member(var, member, link_name="haxis")
        endif
    endif
    
    call Close(var)
    print *, char(title), " stored at ", char(vname)
    if (present(name_result)) name_result = vname
end subroutine

