! Copyright (C) GFD-Dennou Club, 2000.  All rights reserved.

integer function GTVarSize(var) result(result)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: NDims, Get_Slice
    implicit none
    type(GT_VARIABLE), intent(in):: var
    integer, allocatable:: ctr(:)
    integer:: numdims, i
    numdims = ndims(var)
    if (numdims >= 1) then
        allocate(ctr(numdims))
        do, i = 1, numdims
            call get_slice(var, i, count=ctr(i))
        end do
        ctr = max(ctr, 1)
        result = product(ctr(:))
        deallocate(ctr)
    else if (numdims == 1) then
        result = 1
    else
        result = 0
    endif
end function
