program test
  use Algebra
  implicit none
  integer, parameter :: nx=3
  real, dimension(nx) :: x, y, z
  real, dimension(nx,nx) :: a, b, c
  integer :: i, j, k
  real :: eps, accel, val

  open(unit=10,file='data.dat',status='old')
     do i=1,nx
        read(10,*) (a(i,j),j=1,nx), z(i)
     end do
  close(unit=10,status='keep')

  write(*,*) a

  write(*,*) "input the method."
  write(*,*) "[1]=gauss, [2]=LU, [3]=Gau_sei, [4]=Jacobi,"
  write(*,*) "[5]=SOR_Gau, [6]=SOR_Jacobi, [7]=invert, [8]=eigenvalue."
  read(*,*) k

  eps=1.e-6
  accel=1.0

  select case(k)
  case(1)
     call gausss( nx, a, z, x )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(2)
     call LU_devs( nx, a, z, x, 10 )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(3)
     call Gau_Sei( nx, a, z, eps, x )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(4)
     call Jacobi_algebra( nx, a, z, eps, x )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(5)
     call SOR_Gau_Sei( nx, a, z, eps, accel, x )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(6)
     call SOR_Jacobi_algebra( nx, a, z, eps, accel, x )
     do i=1,nx
        write(*,*) x(i)
     end do

  case(7)
     b=0.0
     call invert_mat( nx, a, b )
     do i=1,nx
        write(*,*) (b(i,j),j=1,nx)
     end do

  case(8)
     b=0.0
     x=0.0
     call eigenvalue_power( nx, a, eps, val, x )
     write(*,*) "eigenvalue is ", val
     write(*,*) "eigen vector is"
     do i=1,nx
        write(*,*) x(i)
     end do

  end select

end program
