module analy  ! ׻̥ǡѲϥ⥸塼
contains
subroutine div(x,y,u,v,val)
! 2ȯ׻롼
! 
! x,y  u,v ϶ִθ֤, Ǥդ2ȯ׻ǽ
!
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{u_{i+1,j}-u_{i-1,j}}{2dx} + \frac{v_{i,j+1}-v_{i,j-1}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  implicit none
  real, intent(in) :: x(:)   !  1 
  real, intent(in) :: y(:)   !  2 
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(out) :: val(size(x),size(y))  ! 2ȯ
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ

  nx=size(x)
  ny=size(y)

  dx=x(2)-x(1)
  dy=y(2)-y(1)

!$omp parallel do shared(val,u,v,dx,dy) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        val(i,j)=0.5*((u(i+1,j)-u(i-1,j))/dx+(v(i,j+1)-v(i,j-1))/dy)
     end do
  end do
!$omp end parallel do

!-- ΰü ---
!-- y ξü ---
  do i=2,nx-1
     val(i,1)=0.5*(u(i+1,1)-u(i-1,1))/dx+(v(i,2)-v(i,1))/dy
     val(i,ny)=0.5*(u(i+1,ny)-u(i-1,ny))/dx+(v(i,ny)-v(i,ny-1))/dy
  end do
!-- x ξü ---
  do j=2,ny-1
     val(1,j)=(u(2,j)-u(1,j))/dx+0.5*((v(1,j+1)-v(1,j-1))/dy)
     val(nx,j)=(u(nx,j)-u(nx-1,j))/dx+0.5*((v(nx,j+1)-v(nx,j-1))/dy)
  end do
!-- 4  ---
  val(1,1)=(u(2,1)-u(1,1))/dx+(v(1,2)-v(1,1))/dy
  val(1,ny)=(u(2,ny)-u(1,ny))/dx+(v(1,ny)-v(1,ny-1))/dy
  val(nx,1)=(u(nx,1)-u(nx-1,1))/dx+(v(nx,2)-v(nx,1))/dy
  val(nx,ny)=(u(nx,ny)-u(nx-1,ny))/dx+(v(nx,ny)-v(nx,ny-1))/dy

end subroutine div


subroutine curl(x,y,u,v,val)
! 2ȯ׻롼
!
! x,y  u,v ϶ִθ֤, Ǥդ2٤׻ǽ
!
! $\frac{\partial v}{\partial x} -\frac{\partial u}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{v_{i,j+1}-v_{i,j-1}}{2dx} -\frac{u_{i+1,j}-u_{i-1,j}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  implicit none
  real, intent(in) :: x(:)   !  1 
  real, intent(in) :: y(:)   !  2 
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(out) :: val(size(x),size(y))  ! 2
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ

  nx=size(x)
  ny=size(y)

  dx=x(2)-x(1)
  dy=y(2)-y(1)

!$omp parallel do shared(val,u,v,dx,dy) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        val(i,j)=0.5*((v(i+1,j)-v(i-1,j))/dx-(u(i,j+1)-u(i,j-1))/dy)
     end do
  end do
!$omp end parallel do

!-- ΰü ---
!-- y ξü ---
  do i=2,nx-1
     val(i,1)=0.5*(v(i+1,1)-v(i-1,1))/dx-(u(i,2)-u(i,1))/dy
     val(i,ny)=0.5*(v(i+1,ny)-v(i-1,ny))/dx-(u(i,ny)-u(i,ny-1))/dy
  end do
!-- x ξü ---
  do j=2,ny-1
     val(1,j)=(v(2,j)-v(1,j))/dx-0.5*((u(1,j+1)-u(1,j-1))/dy)
     val(nx,j)=(v(nx,j)-v(nx-1,j))/dx-0.5*((u(nx,j+1)-u(nx,j-1))/dy)
  end do
!-- 4  ---
  val(1,1)=(v(2,1)-v(1,1))/dx-(u(1,2)-u(1,1))/dy
  val(1,ny)=(v(2,ny)-v(1,ny))/dx-(u(1,ny)-u(1,ny-1))/dy
  val(nx,1)=(v(nx,1)-v(nx-1,1))/dx-(u(nx,2)-u(nx,1))/dy
  val(nx,ny)=(v(nx,ny)-v(nx-1,ny))/dx-(u(nx,ny)-u(nx,ny-1))/dy

end subroutine curl



subroutine grad_1d( x, u, val )
! 1 Υ顼ѿθۤ׻
! $\frac{\partial p}{\partial x} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}-p_{i-1}}{2dx} $
! ȤǤ. Ѥ 1 ۤ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  implicit none
  real, intent(in) :: x(:)  !  1 
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  integer :: i  ! 졼ź
  integer :: nx  ! x ǿ(size ؿѤƼưŪ˷׻)
  real :: dx  ! x γʻֳ

  nx=size(x)
  dx=x(2)-x(1)

  do i=2,nx-1
     val(i)=0.5*(u(i+1)-u(i-1))/dx
  end do

!-- ǡΤʤξüν ---
  val(1)=(u(2)-u(1))/dx
  val(nx)=(u(nx)-u(nx-1))/dx

end subroutine grad_1d



!-- 1 顼ۤΥ롼Ѥ 2 ۤΥ٥ȥ׻ ---
subroutine grad_vec_2d( x, y, u, valx, valy )
  !-------------------------------------------------------------------
  ! $\nabla _hp =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j}-p_{i-1,j}}{2dx} ,\; \frac{p_{i,j+1}-p_{i,j-1}}{2dy} \right) $
  ! ȤǤ. Ѥ2ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
  ! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  ! Ѥ 1 ۷׻롼 2 ƤӽФȤˤƤ.
  !-------------------------------------------------------------------
  implicit none
  real, intent(in) :: x(:)   !  1 
  real, intent(in) :: y(:)   !  2 
  real, intent(in) :: u(size(x),size(y))  ! ۤȤ 2 顼ʬ
  real, intent(out) :: valx(size(x),size(y))  ! ׻줿 x  2 ۥ٥ȥ
  real, intent(out) :: valy(size(x),size(y))  ! ׻줿 x  2 ۥ٥ȥ
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ

  nx=size(x)
  ny=size(y)
  dx=x(2)-x(1)
  dy=y(2)-y(1)

  do i=1,ny
     call grad_1d(x, u(:,i), valx(:,i))
  end do

  do i=1,nx
     call grad_1d(y, u(i,:), valy(i,:))
  end do

end subroutine grad_vec_2d



!-- 1 顼ۤΥ롼Ѥ 3 ۤΥ٥ȥ׻ ---
subroutine grad_vec_3d( x, y, z, u, valx, valy, valz )
  !-------------------------------------------------------------------
  ! $\nabla p =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} ,\; \frac{\partial p}{\partial z} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j,k}-p_{i-1,j,k}}{2dx} ,\; \frac{p_{i,j+1,k}-p_{i,j-1,k}}{2dy} ,\; \frac{p_{i,j,k+1}-p_{i,j,k-1}}{2dz} \right) $
  ! ȤǤ. Ѥ 3 ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
  ! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  ! Ѥ 1 ۷׻롼 3 ƤӽФȤˤƤ.
  !-------------------------------------------------------------------
  implicit none
  real, intent(in) :: x(:)   !  1 
  real, intent(in) :: y(:)   !  2 
  real, intent(in) :: z(:)   !  3 
  real, intent(in) :: u(size(x),size(y),size(z))  ! ۤȤ 3 顼ʬ
  real, intent(inout) :: valx(size(x),size(y),size(z))  ! ׻줿 x  3 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y),size(z))  ! ׻줿 y  3 ۥ٥ȥ
  real, intent(inout) :: valz(size(x),size(y),size(z))  ! ׻줿 z  3 ۥ٥ȥ
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  integer :: nz  ! z ǿ(size ؿǼưŪ˷׻)
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ
  real :: dz  ! z γʻֳ

  nx=size(x)
  ny=size(y)
  nz=size(z)
  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)

  do i=1,nz
     do j=1,ny
        call grad_1d(x, u(:,j,i), valx(:,j,i))
     end do
  end do

  do i=1,nz
     do j=1,nx
        call grad_1d(y, u(j,:,i), valy(j,:,i))
     end do
  end do

  do i=1,ny
     do j=1,nx
        call grad_1d(z, u(j,i,:), valz(j,i,:))
     end do
  end do

end subroutine grad_vec_3d

subroutine abst(nx,ny,nz,x,y,z,dis)  ! 3 ٥ȥͤ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  real, intent(in) :: x(nx,ny,nz)  ! x Υ٥ȥʬ
  real, intent(in) :: y(nx,ny,nz)  ! y Υ٥ȥʬ
  real, intent(in) :: z(nx,ny,nz)  ! z Υ٥ȥʬ
  real, intent(inout) :: dis(nx,ny,nz)  ! Ǥͥ٥ȥ
  integer :: i, j, k

!$omp parallel do shared(dis,x,y,z) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dis(i,j,k)=sqrt(x(i,j,k)**2+y(i,j,k)**2+z(i,j,k)**2)
        end do
     end do
  end do
!$omp end parallel do

end subroutine abst


subroutine radius(nx,ny,nz,xp,yp,zp,x,y,z,rad)
  ! ֤εΥ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  real, intent(in) :: xp  ! 濴ֺɸ x ʬ
  real, intent(in) :: yp  ! 濴ֺɸ y ʬ
  real, intent(in) :: zp  ! 濴ֺɸ z ʬ
  real, intent(in) :: x(nx)  ! x ΰֺɸ
  real, intent(in) :: y(ny)  ! y ΰֺɸ
  real, intent(in) :: z(nz)  ! z ΰֺɸ
  real, intent(inout) :: rad(nx,ny,nz)
  integer :: i, j, k

!$omp parallel do shared(rad,x,y,z,xp,yp,zp) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           rad(i,j,k)=sqrt((x(i)-xp)**2+(y(j)-yp)**2+(z(k)-zp)**2)
        end do
     end do
  end do
!$omp end parallel do


end subroutine radius


subroutine Rangular_moment(nx,ny,xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: x(nx)  ! x ΰֺɸ
  real, intent(in) :: y(ny)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(nx,ny)  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(nx,ny)  !  i,j Ǥ® 1 ʬ
  real, intent(inout) :: mome(nx,ny)  ! žޤгѱư
  real :: xxp(nx,ny)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(nx,ny)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j
  real :: tmp(nx,ny)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j)=x(i)-xp
        yyp(i,j)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(nx,ny,1,xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)

end subroutine Rangular_moment


subroutine Aangular_moment(nx,ny,xp,yp,x,y,u,v,f,mome)
! Ǥդޤгѱư̤׻롼
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
!
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: x(nx)  ! x ΰֺɸ
  real, intent(in) :: y(ny)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(nx,ny)  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(nx,ny)  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: f(nx,ny)  !  i,j ǤΥꥪѥ᡼
  real, intent(inout) :: mome(nx,ny)  ! žޤгѱư
  real :: xxp(nx,ny)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(nx,ny)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j
  real :: tmp(nx,ny), rp(nx,ny), tmp1(1)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j)=x(i)-xp
        yyp(i,j)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(nx,ny,1,xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
  call radius(nx,ny,1,xp,yp,0.0,x,y,tmp1,rp)

!$omp parallel do shared(mome,f,rp) private(i,j)
  do j=1,ny
     do i=1,nx
        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
     end do
  end do
!$omp end parallel do

end subroutine Aangular_moment

subroutine dot_prod(nx,ny,nz,x,y,z,u,v,w,dot)
  ! 2٥ȥѷ׻롼
  ! פ, 2 ǤѤ׻뤳Ȥǽ
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  real, intent(in) :: x(nx,ny,nz)  ! x Υ٥ȥʬ
  real, intent(in) :: y(nx,ny,nz)  ! y Υ٥ȥʬ
  real, intent(in) :: z(nx,ny,nz)  ! z Υ٥ȥʬ
  real, intent(in) :: u(nx,ny,nz)  ! x Υ٥ȥʬ
  real, intent(in) :: v(nx,ny,nz)  ! y Υ٥ȥʬ
  real, intent(in) :: w(nx,ny,nz)  ! z Υ٥ȥʬ
  real, intent(inout) :: dot(nx,ny,nz)  ! 
  integer :: i, j, k

!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
        end do
     end do
  end do
!$omp end parallel do

end subroutine dot_prod


subroutine vec_prod(nx,ny,nz,x,y,z,u,v,w,vecx,vecy,vecz)
  ! 2٥ȥγѷ׻롼
  ! ǿפ뤳Ȥ 2 Ѥ׻ǽ
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  integer, intent(in) :: nz  ! z 
  real, intent(in) :: x(nx,ny,nz)  ! x Υ٥ȥʬ
  real, intent(in) :: y(nx,ny,nz)  ! y Υ٥ȥʬ
  real, intent(in) :: z(nx,ny,nz)  ! z Υ٥ȥʬ
  real, intent(in) :: u(nx,ny,nz)  ! x Υ٥ȥʬ
  real, intent(in) :: v(nx,ny,nz)  ! y Υ٥ȥʬ
  real, intent(in) :: w(nx,ny,nz)  ! z Υ٥ȥʬ
  real, intent(inout) :: vecx(nx,ny,nz)  ! Ѥ x ʬ
  real, intent(inout) :: vecy(nx,ny,nz)  ! Ѥ y ʬ
  real, intent(inout) :: vecz(nx,ny,nz)  ! Ѥ z ʬ
  integer :: i, j, k

!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
           vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
           vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
        end do
     end do
  end do
!$omp end parallel do

end subroutine vec_prod


end module analy
