program sound_conv
! ǤդΥǥ󥰥ǡᥤץबɤ߹ߤ䤹Ѵ.
! ٤뤤ϰϤ̤ä,  array ѴΥեˤϽϤʤ.
  use file_operate
  use Basis
  use Math_Const
  use Thermo_Const
  use Thermo_Function
!  use read_name

  implicit none

  real, allocatable, dimension(:,:) :: val
  character(30), allocatable, dimension(:,:) :: cval
  integer :: id, i, j, k, nx, nz, i_undef, skip_num, rh_flag, nf, neg_i
  character(100) :: sign_flag, tmpc
  character(200) :: output_name, undef, fname
  character(200), allocatable, dimension(:) :: iname, oname
  character(10) :: unity(6)  ! unit convert flags
  real :: conv_undef
  real :: limit_height, factor, ew_tmp, ww_tmp, snd_height, conv_height, dz_conv
  real, allocatable, dimension(:) :: height, pres, temp, vapor, tmp, ew, ww
  logical :: limit_flag, conv_inter

  i_undef=len_trim(undef)

!-- namelist file read

!  call read_namelist()
  namelist /input /fname, undef, sign_flag, skip_num, unity, limit_height,  &
  &                snd_height, output_name, dz_conv, conv_inter, conv_undef
  read(5,nml=input)

!-- list file read

  nf=line_number_counter( trim(fname) )
  allocate(iname(nf))
  allocate(oname(nf))
  call read_file_text( trim(fname), 1, nf, iname )

!-- do loop counter

  do id=1,nf

     write(*,*) "--- starting to convert Now: ", trim(iname(id)), " ---"

     limit_flag=.false.

!-- column and array set

     nx=len_trim(sign_flag)
     nz=line_number_counter( trim(iname(id)) )-skip_num

     oname(id)="conv-"//iname(id)

     allocate(cval(nx,nz))
     allocate(val(nx,nz))
     allocate(height(nz))
     allocate(temp(nz))
     allocate(pres(nz))
     allocate(vapor(nz))
     allocate(ew(nz))
     allocate(ww(nz))
     allocate(tmp(nz))

!-- reading file

     call read_file_text( trim(iname(id)), nx, nz, cval, skip=skip_num )

!-- type convert

     do j=1,nx
        if(sign_flag(j:j)/='0')then
           do k=1,nz
              tmpc=trim(cval(j,k))
              if(tmpc(1:len_trim(undef))==trim(undef))then
                 val(j,k)=conv_undef
              else
                 val(j,k)=c2r_convert( cval(j,k) )
              end if
           end do
        end if
     end do

     neg_i=1

     do i=1,nx
        if(sign_flag(i:i)=='a')then
           do j=1,nz
              if(val(i,j)==0.0)then
                 neg_i=j
                 exit
              end if
           end do
           exit
        end if
     end do

!-- val sign

     do i=1,nx
        select case (sign_flag(i:i))
        case('1')
           if(unity(1)=='m')then
              factor=1.0
           else
              factor=1000.0
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 height(j)=val(i,j)*factor
              else
                 height(j)=conv_undef
              end if
              if(height(neg_i)>snd_height.and.j==neg_i)then
                 write(*,*) "### convert WARNING ###"
                 write(*,*) "1st array height is higher than snd_height"
                 write(*,*) "snd_height = ", snd_height, "[m]."
                 write(*,*) "1st height = ", height(neg_i), "[m]."
                 limit_flag=.true.
              end if
           end do
        case('2')
           if(unity(2)=='K')then
              factor=0.0
           else
              factor=273.15
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 temp(j)=val(i,j)+factor
              else
                 temp(j)=conv_undef
              end if
           end do
        case('3')
           if(unity(3)=='Pa')then
              factor=1.0
           else
              factor=100.0
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 if(val(i,j)>0.0)then
                    pres(j)=val(i,j)*factor
                 else
                    pres(j)=conv_undef
                 end if
              else
                 pres(j)=conv_undef
              end if
           end do
        case('4')
           if(unity(4)=='g/kg')then
              factor=1.0e-3
           else
              factor=1.0
              rh_flag=i
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef.or.val(i,j)>=0.0)then
                 vapor(j)=val(i,j)*factor
              else
                 vapor(j)=conv_undef
              end if
           end do
        case('5')
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 ew(j)=val(i,j)
              else
                 ew(j)=conv_undef
              end if
           end do
        case('6')
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 ww(j)=val(i,j)
              else
                 ww(j)=conv_undef
              end if
           end do
        case('7')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        case('8')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        case('9')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        end select
     end do

!-- convert check RH

     if(unity(4)=='%')then
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              vapor(j)=RHTP_2_qv( vapor(j), temp(j), pres(j) )
           end if
        end do
     end if

!-- convert check wind radian

     if(unity(5)=='rad')then
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              ew_tmp=ew(j)
              ww_tmp=ww(j)
              ew(j)=ew_tmp*sin(ww_tmp)
              ww(j)=ew_tmp*cos(ww_tmp)
           end if
        end do
     end if

     if(unity(5)=='degree')then
        do j=neg_i,nz
           if(ew(j)/=conv_undef.and.ww(j)/=conv_undef)then
              ew_tmp=ew(j)
              ww_tmp=ww(j)*pi/180.0
              ew(j)=ew_tmp*sin(ww_tmp)  ! negative sign is wind opposite direction
              ww(j)=ew_tmp*cos(ww_tmp)
           end if
        end do
     end if

!-- direction check

     if(unity(6)=='false')then
        do j=neg_i,nz
           if(ew(j)/=conv_undef.and.ww(j)/=conv_undef)then
              ew(j)=-ew(j)
              ww(j)=-ww(j)
           end if
        end do
     end if


!-- writing file

     write(*,*) "--- writing Now: ", trim(oname(id)), " ---"

     open(unit=11+id,file=trim(oname(id)),status='unknown')
     write(11+id,*) 'height ', 'pressure ', 'temperature ', 'vapor ', 'E-Wwind ', 'N-Swind '
     write(11+id,*) " 'm' ", " 'Pa' ", " 'K' ", " 'kg/kg' ", " 'm/s' ", " 'm/s'"

     if(limit_flag.eqv..true.)then
        write(11+id,*) limit_height, 101325.0, conv_undef, conv_undef,  &
  &                    conv_undef, conv_undef
     end if

     conv_height=limit_height

     do j=neg_i,nz-1
        if(height(j)>limit_height)then
           if(height(j)>0.0.and.pres(j)>0.0)then
              if(conv_inter.eqv..false.)then
                 write(11+id,'(1000f)') height(j), pres(j), temp(j),  &
  &                                     vapor(j), ew(j), ww(j)
              else
                 if(conv_height<height(j))then
                    write(11+id,'(1000f)') height(j), pres(j), temp(j),  &
  &                                        vapor(j), ew(j), ww(j)
                    conv_height=conv_height+dz_conv
                 end if
              end if
              if(height(j+1)<=height(j))then
                 exit
              end if
           end if
        end if
        if(j==nz-1)then
           if(height(j+1)>0.0.and.pres(j+1)>0.0)then
              write(11+id,'(1000f)') height(j+1), pres(j+1), temp(j+1),  &
  &                                  vapor(j+1), ew(j+1), ww(j+1)
           end if
        end if
     end do
     close(unit=11+id,status='keep')

     deallocate(cval)
     deallocate(val)
     deallocate(height)
     deallocate(temp)
     deallocate(pres)
     deallocate(vapor)
     deallocate(ew)
     deallocate(ww)
     deallocate(tmp)

     write(*,*) "--- finishing to convert Now: ", trim(iname(id)), " ---"

  end do

!-- output list file writing
  open(unit=11,file=trim(output_name),status='unknown')
     do i=1,nf
        write(11,*) trim(oname(i))
     end do
  close(unit=11)

end program
