!-----------------------------------------------------------------------
!     Copyright (C) 2000-2013 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Thermo_Advanced_Routine
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Routine
use Thermo_Advanced_Function
use Derivation
use Algebra

contains

subroutine Rich_horizon( za, pta, ptg, va, qva, qvs, Ri )
! Х륯㡼ɥ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in), dimension(:,:) :: pta  ! za Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real, intent(inout), dimension(size(pta,1),size(pta,2)) :: Ri  ! 㡼ɥ
  integer :: i, j, nx, ny

  nx=size(pta,1)
  ny=size(pta,2)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,ny
     do i=1,nx
        Ri(i,j)=Rich( za, pta(i,j), ptg(i,j), va(i,j), qva(i,j), qvs(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine Louis_horizon( z, z0m, richard, Lo )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), dimension(size(z0m,1),size(z0m,2)) :: richard  ! Х륯㡼ɥ
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: Lo  ! 
  real, parameter :: b=5.0, c=5.0
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,ny
     do i=1,nx
        Lo(i,j)=Louis( z, z0m(i,j), richard(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine cm_horizon( z, z0m, coem, richard )
! ư̤˴ؤХ륯׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: coem  ! Х륯
  real, intent(in), dimension(size(z0m,1),size(z0m,2)), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

  if(present(richard))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine cmdva_2_ust_horizon( cmd, va, velst )
! Х륯, ®٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: cmd  !  za ǤΥХ륯
  real, intent(in), dimension(size(cmd,1),size(cmd,2)) :: va  !  za Ǥοʿ [m/s]
  real, intent(inout), dimension(size(cmd,1),size(cmd,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(cmd,1)
  ny=size(cmd,2)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=cmdva_2_ust( cmd(i,j), va(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine taurho_2_ust_horizon( taux, tauy, rho, velst )
! ϤΥǥȿʿ 2 ʬȤι٤Ǥ̩٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: taux  ! ٤ǤϤΥǥ x ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: tauy  ! ٤ǤϤΥǥ y ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: rho  ! ٤Ǥ̩ [kg/m^3]
  real, intent(inout), dimension(size(taux,1),size(taux,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(taux,1)
  ny=size(taux,2)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=taurho_2_ust( (/ taux(i,j), tauy(i,j) /), rho(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine EDC_TKE( types, x, y, z, pt, tke, nuth, nutv, nuhh, nuhv, undef )
  use Phys_Const
  use Statistics
  use Derivation
  implicit none
! 1.5  TKE ѤǴ׻.
  character(1), intent(in) :: types  ! ήμλ.
  ! ήξ = 'i', ήξ = 'r'.
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ܾβ [K]
  real, intent(in) :: tke(size(x),size(y),size(z))  ! tke [J/kg]
  real, intent(inout) :: nuth(size(x),size(y),size(z))  ! ʿǴ [m^2/s]
  real, intent(inout) :: nutv(size(x),size(y),size(z))  ! ľǴ [m^2/s]
  real, intent(inout) :: nuhh(size(x),size(y),size(z))  ! ʿȻ [m^2/s]
  real, intent(inout) :: nuhv(size(x),size(y),size(z))  ! ľȻ [m^2/s]
  real, intent(in), optional :: undef   ! ̤
  real :: BV(size(x),size(y),size(z))
  real, parameter :: alpha=1.0e-6
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx(size(x))  ! x γʻҴֳ [m]
  real :: dy(size(y))  ! y γʻҴֳ [m]
  real :: dz(size(z))  ! z γʻҴֳ [m]
  real :: dsh(size(x),size(y),size(z))
  real :: dsv(size(x),size(y),size(z))
  real :: lh(size(x),size(y),size(z))
  real, dimension(size(x),size(y),size(z)) :: lv, ls
  real :: tmp
  intrinsic :: min, max
  logical, dimension(size(x),size(y),size(z)) :: undeflag 

  nx=size(x)
  ny=size(y)
  nz=size(z)

  undeflag=.false.  ! undef ץ󤬤ʤȤϾ false.

  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do
  do j=2,ny-1
     dy(j)=0.5*(y(j+1)-y(j-1))
  end do
  do k=2,nz-1
     dz(k)=0.5*(z(k+1)-z(k-1))
  end do

  dx(1)=x(2)-x(1)
  dx(nx)=x(nx)-x(nx-1)
  dy(1)=y(2)-y(1)
  dy(ny)=y(ny)-y(ny-1)
  dz(1)=z(2)-z(1)
  dz(nz)=z(nz)-z(nz-1)

! ľ ptb Υ֥ȥХ鿶ư׻.
! ʹ, undef Τ, ʤʬ.
  if(present(undef))then
     call Brunt_Freq( x, y, z, pt, BV, undeff=undef )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(BV(i,j,k)/=undef.and.tke(i,j,k)/=undef)then
                 ls(i,j,k)=0.76*sqrt(abs(tke(i,j,k)/BV(i,j,k)))
                 undeflag(i,j,k)=.false.
              else
                 undeflag(i,j,k)=.true.
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else
     call Brunt_Freq( x, y, z, pt, BV )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              ls(i,j,k)=0.76*sqrt(abs(tke(i,j,k)/BV(i,j,k)))
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

!-- ʹ, undeflag ˤä, undef ץΤʤ˴ؤ餺,
!-- η׻Ƿ׻Ǥ.

  if(types(1:1)=='i')then  ! ήξ
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=(dx(i)*dy(j)*dz(k))**(1.0/3.0)
                 dsv(i,j,k)=dsh(i,j,k)

                 if(BV(i,j,k)>0.0)then
                    lh(i,j,k)=min(dsh(i,j,k),ls(i,j,k))
                 else
                    lh(i,j,k)=dsh(i,j,k)
                 end if

                 lv(i,j,k)=lh(i,j,k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(types(1:1)=='r')then  ! ήξ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=sqrt(dx(i)*dy(j))
                 dsv(i,j,k)=dz(k)
                 lh(i,j,k)=dsh(i,j,k)

                 if(BV(i,j,k)>0.0)then
                    lv(i,j,k)=min(dsh(i,j,k),ls(i,j,k))
                 else
                    lv(i,j,k)=dsv(i,j,k)
                 end if
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,k).eqv..false.)then
              nuth(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lh(i,j,k),alpha*(dsh(i,j,k)**2))
              nutv(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lv(i,j,k),alpha*(dsv(i,j,k)**2))
              if(types(1:1)=='i')then  ! ήξ
                 nuhh(i,j,k)=nuth(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
                 nuhv(i,j,k)=nutv(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
              else if(types(1:1)=='r')then  ! ήξ
                 nuhh(i,j,k)=3.0*nuth(i,j,k)
                 nuhv(i,j,k)=nutv(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
              end if
           else
              nuth(i,j,k)=undef
              nutv(i,j,k)=undef
              nuhh(i,j,k)=undef
              nuhv(i,j,k)=undef
           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Brunt_Freq( x, y, z, pt, BV, undeff )
! ֥ȥХ鿶ư 2 ׻.
  use Derivation
  use Phys_Const
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(x),size(y),size(z))  !  [K]
  real, intent(inout) :: BV(size(x),size(y),size(z))  ! ֥ȥХ鿶ư [1/s]
  real, intent(in), optional :: undeff
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx  ! x γʻҴֳ [m]
  real :: dy  ! y γʻҴֳ [m]
  real :: dz  ! z γʻҴֳ [m]

  nx=size(x)
  ny=size(y)
  nz=size(z)
  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), BV(i,j,:), undeff )
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), BV(i,j,:) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

!-- ʲ, grad_1d ˤä undef ƤΤ, BV Ƚ.
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(present(undeff))then
              if(BV(i,j,k)==undeff)then
                 BV(i,j,k)=undeff
              else
                 BV(i,j,k)=(g/pt(i,j,k))*BV(i,j,k)
              end if
           else
              BV(i,j,k)=(g/pt(i,j,k))*BV(i,j,k)
           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Ertel_PV( x, y, z, u, v, w, rho, pt, cor, pv, undeff, sx, sy, sz )
! ƥΥݥƥ󥷥뱲٤׻
  use Thermo_Function
  use Thermo_Routine
  use derivation
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ®پ x ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! ®پ y ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! ®پ z ʬ [m/s]
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ̩پ [kg/m^3]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ̾ [K]
  real, intent(in) :: cor(size(x),size(y))  ! ꥪѥ᡼ [/s]
  real, intent(inout) :: pv(size(x),size(y),size(z))  ! PV [Km^2/kgs]
  real, intent(in), optional :: undeff
  real, intent(in), optional :: sx(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: sy(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: sz(size(x),size(y),size(z))  ! 󥰥ե
  real :: tmp1(size(x),size(y),size(z))
  real :: tmp2(size(x),size(y),size(z))
  real :: tmp3(size(x),size(y),size(z))
  real :: tmp4(size(x),size(y),size(z))
  real :: tmp5(size(x),size(y),size(z))
  real :: tmp6(size(x),size(y),size(z))
  real :: tmp7(size(x),size(y),size(z))
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: scalex(size(x),size(y),size(z))
  real :: scaley(size(x),size(y),size(z))
  real :: scalez(size(x),size(y),size(z))

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(sx).and.present(sy).and.present(sz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=sx(i,j,k)
              scaley(i,j,k)=sy(i,j,k)
              scalez(i,j,k)=sz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then
!  ̤ζָۤ׻.
     call grad_3d( x, y, z, pt, tmp1, tmp2, tmp3, undeff,  &
  &                    scalex, scaley, scalez )
!  3  rotation ׻.
     call curl_3d( x, y, z, u, v, w, tmp4, tmp5, tmp6, undeff,  & 
  &               scalex, scaley, scalez )
!  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7, undeff )
  else
!  ̤ζָۤ׻.
     call grad_3d( x, y, z, pt, tmp1, tmp2, tmp3,  &
  &                    hx=scalex, hy=scaley, hz=scalez )
!  3  rotation ׻.
     call curl_3d( x, y, z, u, v, w, tmp4, tmp5, tmp6,  & 
  &               hx=scalex, hy=scaley, hz=scalez )
!  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7 )
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp7(i,j,k)==undeff.or.rho(i,j,k)==undeff)then
                 pv(i,j,k)=undeff
              else
                 pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
                 ! ׻Τб٤ʤΤ, ꥪ­碌.
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------
!!!!!!!!!!!!!!!!!!!1 under construction
subroutine Buoyanc( rhop, rhob, buo, qall )
  use phys_const
  implicit none
  real, intent(in) :: rhop(:,:,:)
  real, intent(in) :: rhob(size(rhop,3))
  real, intent(inout) :: buo(size(rhop,1),size(rhop,2),size(rhob))
  real, intent(in), optional :: qall(size(rhop,1),size(rhop,2),size(rhob))
  integer :: nx, ny, nz
  integer :: i, j, k

  nx=size(rhop,1)
  ny=size(rhop,2)
  nz=size(rhop,3)

  if(present(qall))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              buo(i,j,k)=g*(rhop(i,j,k)-rhob(k))/(rhob(k))
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              buo(i,j,k)=g*(rhop(i,j,k)-rhob(k))/(rhob(k))
           end do
        end do
     end do
  end if

end subroutine Buoyanc

!--------------------------------------------------------
!--------------------------------------------------------



end module
