!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Thermo_Advanced_Routine
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Routine
use Thermo_Advanced_Function
use Derivation
use Algebra

contains

subroutine Rich_horizon( za, pta, ptg, va, qva, qvs, Ri )
! Х륯㡼ɥ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in), dimension(:,:) :: pta  ! za Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real, intent(inout), dimension(size(pta,1),size(pta,2)) :: Ri  ! 㡼ɥ
  integer :: i, j, nx, ny

  nx=size(pta,1)
  ny=size(pta,2)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
  do j=1,ny
     do i=1,nx
        Ri(i,j)=Rich( za, pta(i,j), ptg(i,j), va(i,j), qva(i,j), qvs(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine Louis_horizon( z, z0m, richard, Lo )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), dimension(size(z0m,1),size(z0m,2)) :: richard  ! Х륯㡼ɥ
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: Lo  ! 
  real, parameter :: b=5.0, c=5.0
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
  do j=1,ny
     do i=1,nx
        Lo(i,j)=Louis( z, z0m(i,j), richard(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine cm_horizon( z, z0m, coem, richard )
! ư̤˴ؤХ륯׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: coem  ! Х륯
  real, intent(in), dimension(size(z0m,1),size(z0m,2)), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

  if(present(richard))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine cmdva_2_ust_horizon( cmd, va, velst )
! Х륯, ®٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: cmd  !  za ǤΥХ륯
  real, intent(in), dimension(size(cmd,1),size(cmd,2)) :: va  !  za Ǥοʿ [m/s]
  real, intent(inout), dimension(size(cmd,1),size(cmd,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(cmd,1)
  ny=size(cmd,2)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=cmdva_2_ust( cmd(i,j), va(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine taurho_2_ust_horizon( taux, tauy, rho, velst )
! ϤΥǥȿʿ 2 ʬȤι٤Ǥ̩٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: taux  ! ٤ǤϤΥǥ x ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: tauy  ! ٤ǤϤΥǥ y ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: rho  ! ٤Ǥ̩ [kg/m^3]
  real, intent(inout), dimension(size(taux,1),size(taux,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(taux,1)
  ny=size(taux,2)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=taurho_2_ust( (/ taux(i,j), tauy(i,j) /), rho(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine EDC_TKE( types, dt, x, y, z, pt, tke, nuth, nutv, nuhh, nuhv, undef )
  use Phys_Const
  use Statistics
  use Derivation
  implicit none
! 1.5  TKE ѤǴ׻.
  character(1), intent(in) :: types  ! ήμλ.
  ! ήξ = 'i', ήξ = 'r'.
  real, intent(in) :: dt    ! ֥ƥå [s]
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ܾβ [K]
  real, intent(in) :: tke(size(x),size(y),size(z))  ! tke [J/kg]
  real, intent(inout) :: nuth(size(x),size(y),size(z))  ! ʿǴ [m^2/s]
  real, intent(inout) :: nutv(size(x),size(y),size(z))  ! ľǴ [m^2/s]
  real, intent(inout) :: nuhh(size(x),size(y),size(z))  ! ʿȻ [m^2/s]
  real, intent(inout) :: nuhv(size(x),size(y),size(z))  ! ľȻ [m^2/s]
  real, intent(in), optional :: undef   ! ̤
  real :: BV(size(x),size(y),size(z))
  real, parameter :: alpha=1.0e-6
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx(size(x))  ! x γʻҴֳ [m]
  real :: dy(size(y))  ! y γʻҴֳ [m]
  real :: dz(size(z))  ! z γʻҴֳ [m]
  real :: dsh(size(x),size(y),size(z))
  real :: dsv(size(x),size(y),size(z))
  real :: lh(size(x),size(y),size(z))
  real, dimension(size(x),size(y),size(z)) :: lv, ls
  real :: tmp, ck
  intrinsic :: min, max
  logical, dimension(size(x),size(y),size(z)) :: undeflag
  real, parameter :: kmin=0.125   ! nu κͤ kmin / dt (By CReSS)

  nx=size(x)
  ny=size(y)
  nz=size(z)

  ck=kmin/dt

  undeflag=.false.  ! undef ץ󤬤ʤȤϾ false.

  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do
  do j=2,ny-1
     dy(j)=0.5*(y(j+1)-y(j-1))
  end do
  do k=2,nz-1
     dz(k)=0.5*(z(k+1)-z(k-1))
  end do

  dx(1)=x(2)-x(1)
  dx(nx)=x(nx)-x(nx-1)
  dy(1)=y(2)-y(1)
  dy(ny)=y(ny)-y(ny-1)
  dz(1)=z(2)-z(1)
  dz(nz)=z(nz)-z(nz-1)

! ľ ptb Υ֥ȥХ鿶ư׻.
! ʹ, undef Τ, ʤʬ.
  if(present(undef))then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,ny
        do i=1,nx
           call Brunt_Freq( z, pt(i,j,:), BV(i,j,:), undeff=undef )
        end do
     end do

!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(BV(i,j,k)/=undef.and.tke(i,j,k)/=undef)then
                 ls(i,j,k)=0.76*sqrt(abs(tke(i,j,k)/BV(i,j,k)))
                 undeflag(i,j,k)=.false.
              else
                 undeflag(i,j,k)=.true.
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,ny
        do i=1,nx
           call Brunt_Freq( z, pt(i,j,:), BV(i,j,:) )
        end do
     end do

!$omp end do
!$omp end parallel


!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              ls(i,j,k)=0.76*sqrt(abs(tke(i,j,k)/BV(i,j,k)))
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

!-- ʹ, undeflag ˤä, undef ץΤʤ˴ؤ餺,
!-- η׻Ƿ׻Ǥ.

  if(types(1:1)=='i')then  ! ήξ
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=(dx(i)*dy(j)*dz(k))**(1.0/3.0)
                 dsv(i,j,k)=dsh(i,j,k)

                 if(BV(i,j,k)>0.0)then
                    lh(i,j,k)=min(dsh(i,j,k),ls(i,j,k))
                 else
                    lh(i,j,k)=dsh(i,j,k)
                 end if

                 lv(i,j,k)=lh(i,j,k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(types(1:1)=='r')then  ! ήξ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=sqrt(dx(i)*dy(j))
                 dsv(i,j,k)=dz(k)
                 lh(i,j,k)=dsh(i,j,k)

                 if(BV(i,j,k)>0.0)then
                    lv(i,j,k)=min(dsh(i,j,k),ls(i,j,k))
                 else
                    lv(i,j,k)=dsv(i,j,k)
                 end if
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,k).eqv..false.)then
              nuth(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lh(i,j,k),alpha*(dsh(i,j,k)**2))
              nutv(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lv(i,j,k),alpha*(dsv(i,j,k)**2))
!-- CReSS original

              nuth(i,j,k)=min(nuth(i,j,k),ck*(dsh(i,j,k)**2))
              nutv(i,j,k)=min(nutv(i,j,k),ck*(dsv(i,j,k)**2))

              if(types(1:1)=='i')then  ! ήξ
                 nuhh(i,j,k)=nuth(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
                 nuhv(i,j,k)=nutv(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
              else if(types(1:1)=='r')then  ! ήξ
                 nuhh(i,j,k)=3.0*nuth(i,j,k)
                 nuhv(i,j,k)=nutv(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv(i,j,k)))
              end if

           else
              nuth(i,j,k)=undef
              nutv(i,j,k)=undef
              nuhh(i,j,k)=undef
              nuhv(i,j,k)=undef
           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine EDC_TKE

!--------------------------------------------------------
!--------------------------------------------------------

subroutine EDC_SMA( types, dt, x, y, z, u, v, w, pt, nuth, nutv, nuhh, nuhv, undef )
  use Phys_Const
  use Statistics
  use Derivation
  implicit none
! ޥ󥹥ˤ뱲Ǵ׻.
  character(1), intent(in) :: types  ! ήμλ.
  ! ήξ = 'i', ήξ = 'r'.
  real, intent(in) :: dt    ! ֥ƥå [s]
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x ® [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! y ® [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! z ® [m/s]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ܾβ [K]
  real, intent(inout) :: nuth(size(x),size(y),size(z))  ! ʿǴ [m^2/s]
  real, intent(inout) :: nutv(size(x),size(y),size(z))  ! ľǴ [m^2/s]
  real, intent(inout) :: nuhh(size(x),size(y),size(z))  ! ʿȻ [m^2/s]
  real, intent(inout) :: nuhv(size(x),size(y),size(z))  ! ľȻ [m^2/s]
  real, intent(in), optional :: undef   ! ̤
  real :: BV(size(x),size(y),size(z))
  real, parameter :: alpha=1.0e-6
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx(size(x))  ! x γʻҴֳ [m]
  real :: dy(size(y))  ! y γʻҴֳ [m]
  real :: dz(size(z))  ! z γʻҴֳ [m]
  real, dimension(size(x),size(y),size(z)) :: dsh, dsv, def, tmp
  real :: ck, coea
  intrinsic :: min, max
  logical, dimension(size(x),size(y),size(z)) :: undeflag
  real, parameter :: kmin=0.125   ! nu κͤ kmin / dt (By CReSS)
  real, parameter :: csnum=0.21   ! ޥ󥹥
  real, parameter :: Praiv=3.0    ! ץȥ () εտ.

  nx=size(x)
  ny=size(y)
  nz=size(z)

  def=0.0
  tmp=0.0
  BV=0.0

  ck=kmin/dt
  coea=2.0/3.0

  undeflag=.false.  ! undef ץ󤬤ʤȤϾ false.

  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do
  do j=2,ny-1
     dy(j)=0.5*(y(j+1)-y(j-1))
  end do
  do k=2,nz-1
     dz(k)=0.5*(z(k+1)-z(k-1))
  end do

  dx(1)=x(2)-x(1)
  dx(nx)=x(nx)-x(nx-1)
  dy(1)=y(2)-y(1)
  dy(ny)=y(ny)-y(ny-1)
  dz(1)=z(2)-z(1)
  dz(nz)=z(nz)-z(nz-1)

! ľ ptb Υ֥ȥХ鿶ư׻.
! ʹ, undef Τ, ʤʬ.
  if(present(undef))then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,ny
        do i=1,nx
           call Brunt_Freq( z, pt(i,j,:), BV(i,j,:), undeff=undef )
        end do
     end do

!$omp end do
!$omp end parallel

     call deform_tensor( '11', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef, coe=0.5 )
     call deform_tensor( '22', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef, coe=0.5 )
     call deform_tensor( '33', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef, coe=0.5 )
     call deform_tensor( '12', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef )
     call deform_tensor( '13', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef )
     call deform_tensor( '23', x, y, z, u, v, w, tmp, undef=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef )
     call div_3d( x, y, z, u, v, w, tmp, undeff=undef )
     call temporary_pow( tmp, undef=undef )
     call temporary_add( tmp, def, undef=undef, coe=-coea )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(BV(i,j,k)/=undef)then
                 undeflag(i,j,k)=.false.
              else
                 undeflag(i,j,k)=.true.
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

     do j=1,ny
        do i=1,nx
           call Brunt_Freq( z, pt(i,j,:), BV(i,j,:) )
        end do
     end do

!$omp end do
!$omp end parallel

     call deform_tensor( '11', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def, coe=0.5 )
     call deform_tensor( '22', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def, coe=0.5 )
     call deform_tensor( '33', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def, coe=0.5 )
     call deform_tensor( '12', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def )
     call deform_tensor( '13', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def )
     call deform_tensor( '23', x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def )
     call div_3d( x, y, z, u, v, w, tmp )
     call temporary_pow( tmp )
     call temporary_add( tmp, def, coe=-coea )

  end if

!-- ʹ, undeflag ˤä, undef ץΤʤ˴ؤ餺,
!-- η׻Ƿ׻Ǥ.

  if(types(1:1)=='i')then  ! ήξ
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=(dx(i)*dy(j)*dz(k))**(1.0/3.0)
                 dsv(i,j,k)=dsh(i,j,k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(types(1:1)=='r')then  ! ήξ

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 dsh(i,j,k)=sqrt(dx(i)*dy(j))
                 dsv(i,j,k)=dz(k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,k).eqv..false.)then
              nuth(i,j,k)=((csnum*dsh(i,j,k))**2)*(def(i,j,k)-BV(i,j,k)*Praiv)
              if(nuth(i,j,k)<0.0)then
                 nuth(i,j,k)=0.0
              end if

!-- CReSS original
              nuth(i,j,k)=min(nuth(i,j,k),ck*sqrt(dx(i)*dy(j)))

              if(types(1:1)=='i')then  ! ήξ
                 nutv(i,j,k)=nuth(i,j,k)
                 nuhh(i,j,k)=Praiv*nuth(i,j,k)
                 nuhv(i,j,k)=nuhh(i,j,k)
              else if(types(1:1)=='r')then  ! ήξ
                 nutv(i,j,k)=((csnum*dsv(i,j,k))**2)*(def(i,j,k)-BV(i,j,k)*Praiv)
                 if(nutv(i,j,k)<0.0)then
                    nutv(i,j,k)=0.0
                 end if

              !-- CReSS original
                 nutv(i,j,k)=min(nutv(i,j,k),ck*sqrt(dx(i)*dy(j)))

                 nuhh(i,j,k)=Praiv*nuth(i,j,k)
                 nuhv(i,j,k)=Praiv*nutv(i,j,k)
              end if

           else
              nuth(i,j,k)=undef
              nutv(i,j,k)=undef
              nuhh(i,j,k)=undef
              nuhv(i,j,k)=undef
           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

!-- contains subroutine
contains

subroutine temporary_add( vali, valo, undef, coe )
  ! calc. valo = valo + coe*vali
  implicit none
  real, intent(in) :: vali(:,:,:)  ! adding value
  real, intent(inout) :: valo(size(vali,1),size(vali,2),size(vali,3))  ! orig. value
  real, intent(in), optional :: undef
  real, intent(in), optional :: coe
  integer :: i, j, k, nx, ny, nz
  real :: coef

  nx=size(vali,1)
  ny=size(vali,2)
  nz=size(vali,3)

  if(present(coe))then
     coef=coe
  else
     coef=1.0
  end if

  if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(vali(i,j,k)/=undef.and.valo(i,j,k)/=undef)then
                 valo(i,j,k)=valo(i,j,k)+coef*vali(i,j,k)
              else
                 valo(i,j,k)=undef
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              valo(i,j,k)=valo(i,j,k)+coef*vali(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel
  end if

end subroutine temporary_add

subroutine temporary_pow( vali, undef, coe )
  ! calc. vali = vali**coe
  ! coe = 2 (default)
  implicit none
  real, intent(inout) :: vali(:,:,:)  ! powering value
  real, intent(in), optional :: undef
  integer, intent(in), optional :: coe
  integer :: i, j, k, nx, ny, nz
  integer :: coef

  nx=size(vali,1)
  ny=size(vali,2)
  nz=size(vali,3)

  if(present(coe))then
     coef=coe
  else
     coef=2
  end if

  if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(vali(i,j,k)/=undef)then
                 vali(i,j,k)=vali(i,j,k)**coef
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              vali(i,j,k)=vali(i,j,k)**coef
           end do
        end do
     end do

!$omp end do
!$omp end parallel
  end if

end subroutine temporary_pow
!-- contains subroutine

end subroutine EDC_SMA

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Brunt_Freq( z, pt, BV, undeff )
! ֥ȥХ鿶ư 2 ׻.
  use Derivation
  use Phys_Const
  implicit none
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(z))  !  [K]
  real, intent(inout) :: BV(size(z))  ! ֥ȥХ鿶ư [1/s]
  real, intent(in), optional :: undeff
  integer :: i, j, k
  integer :: nz  !  3 ǿ
  real :: dz  ! z γʻҴֳ [m]

  if(present(undeff))then

     call grad_1d( z, pt, BV, undeff )

  else

     call grad_1d( z, pt, BV )

  end if

!-- ʲ, grad_1d ˤä undef ƤΤ, BV Ƚ.
  do k=1,nz
     if(present(undeff))then
        if(BV(k)==undeff)then
           BV(k)=undeff
        else
           BV(k)=(g/pt(k))*BV(k)
        end if
     else
        BV(k)=(g/pt(k))*BV(k)
     end if
  end do

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Ertel_PV( x, y, z, u, v, w, rho, pt, cor, pv, undeff, sx, sy, sz, cord )
! ƥΥݥƥ󥷥뱲٤׻
  use Thermo_Function
  use Thermo_Routine
  use derivation
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ®پ x ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! ®پ y ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! ®پ z ʬ [m/s]
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ̩پ [kg/m^3]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ̾ [K]
  real, intent(in) :: cor(size(x),size(y))  ! ꥪѥ᡼ [/s]
  real, intent(inout) :: pv(size(x),size(y),size(z))  ! PV [Km^2/kgs]
  real, intent(in), optional :: undeff
  real, intent(in), optional :: sx(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: sy(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: sz(size(x),size(y),size(z))  ! 󥰥ե
  character(1), intent(in), optional :: cord   ! ľɸ
                              ! 'z', 'p' =  [m],  [Pa]
                              ! ǥե = 'z'
  real :: tmp1(size(x),size(y),size(z))
  real :: tmp2(size(x),size(y),size(z))
  real :: tmp3(size(x),size(y),size(z))
  real :: tmp4(size(x),size(y),size(z))
  real :: tmp5(size(x),size(y),size(z))
  real :: tmp6(size(x),size(y),size(z))
  real :: tmp7(size(x),size(y),size(z))
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: scalex(size(x),size(y),size(z))
  real :: scaley(size(x),size(y),size(z))
  real :: scalez(size(x),size(y),size(z))
  character(1) :: zp_flag

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(sx))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=sx(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(sy))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scaley(i,j,k)=sy(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scaley(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(sz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalez(i,j,k)=sz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(cord))then
     zp_flag=cord
  else
     zp_flag='z'
  end if

  if(present(undeff))then
!  ̤ζָۤ׻.
     call grad_3d( x, y, z, pt, tmp1, tmp2, tmp3, undeff,  &
  &                    scalex, scaley, scalez )
!  3  rotation ׻.
     call curl_3d( x, y, z, u, v, w, tmp4, tmp5, tmp6, undeff,  & 
  &               scalex, scaley, scalez )
!  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7, undeff )
  else
!  ̤ζָۤ׻.
     call grad_3d( x, y, z, pt, tmp1, tmp2, tmp3,  &
  &                    hx=scalex, hy=scaley, hz=scalez )
!  3  rotation ׻.
     call curl_3d( x, y, z, u, v, w, tmp4, tmp5, tmp6,  & 
  &               hx=scalex, hy=scaley, hz=scalez )
!  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7 )
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp3(i,j,k)==undeff.or.tmp7(i,j,k)==undeff.or.  &
  &              rho(i,j,k)==undeff)then
                 pv(i,j,k)=undeff
              else
                 pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
                 ! ׻Τб٤ʤΤ, ꥪ­碌.
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine HEPV( x, y, z, u, v, rhoc, pt, cor, pv, undeff, sx, sy )
! ϳضΩķϤǤ, ǤդαľɸϤˤ
! ƥΥݥƥ󥷥뱲٤׻.
  use Thermo_Function
  use Thermo_Routine
  use derivation
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [MKS unit]
  real, intent(in) :: y(:)  ! y κɸѿ [MKS unit]
  real, intent(in) :: z(:)  ! z κɸѿ [MKS unit]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ®پ x ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! ®پ y ʬ [m/s]
  real, intent(in) :: rhoc(size(x),size(y),size(z))  !Ťդ̩ [MKS unit]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! 顼¸
  real, intent(in) :: cor(size(x),size(y))  ! ꥪѥ᡼ [/s]
  real, intent(inout) :: pv(size(x),size(y),size(z))  ! PV [Km^2/kgs]
  real, intent(in), optional :: undeff
  real, intent(in), optional :: sx(size(x),size(y))  ! 󥰥ե
  real, intent(in), optional :: sy(size(x),size(y))  ! 󥰥ե
  real :: tmp1(size(x),size(y),size(z))
  real :: tmp2(size(x),size(y),size(z))
  real :: tmp3(size(x),size(y),size(z))
  real :: tmp4(size(x),size(y),size(z))
  real :: tmp5(size(x),size(y),size(z))
  real :: tmp6(size(x),size(y),size(z))
  real :: tmp7(size(x),size(y),size(z))
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: scalex(size(x),size(y))
  real :: scaley(size(x),size(y))

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(sx))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=sx(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
        end do
     end do
  end if

  if(present(sy))then
     do j=1,ny
        do i=1,nx
           scaley(i,j)=sy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scaley(i,j)=1.0
        end do
     end do
  end if

  if(present(undeff))then
  !  顼¸̤ζָ, rotation ׻.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call grad_2d( x, y, pt(:,:,k), tmp1(:,:,k), tmp2(:,:,k), undeff,  &
  &                   hx=scalex, hy=scaley )
        call curl( x, y, u(:,:,k), v(:,:,k), tmp6(:,:,k),  &
  &                undeff, hx=scalex, hy=scaley )
     end do
!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), tmp3(i,j,:), undeff )
           call grad_1d( z, v(i,j,:), tmp4(i,j,:), undeff )
           call grad_1d( z, u(i,j,:), tmp5(i,j,:), undeff )
        end do
     end do
!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp4(i,j,k)/=undeff)then
                 tmp4(i,j,k)=-tmp4(i,j,k)
              end if
              if(tmp6(i,j,k)/=undeff)then
                 tmp6(i,j,k)=tmp6(i,j,k)+cor(i,j)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  !  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7, undeff )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp4(i,j,k)==undeff.or.rhoc(i,j,k)==undeff)then
                 pv(i,j,k)=undeff
              else
                 pv(i,j,k)=tmp7(i,j,k)*rhoc(i,j,k)
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

  !  顼¸̤ζָ, rotation ׻.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call grad_2d( x, y, pt(:,:,k), tmp1(:,:,k), tmp2(:,:,k),  &
  &                   hx=scalex, hy=scaley )
        call curl( x, y, u(:,:,k), v(:,:,k), tmp6(:,:,k),  &
  &                undeff, hx=scalex, hy=scaley )
     end do
!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), tmp3(i,j,:) )
           call grad_1d( z, v(i,j,:), tmp4(i,j,:) )
           call grad_1d( z, u(i,j,:), tmp5(i,j,:) )
        end do
     end do
!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmp4(i,j,k)=-tmp4(i,j,k)
              tmp6(i,j,k)=tmp6(i,j,k)+cor(i,j)
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  !  omega  grad pt Ѥ׻
     call dot_prod_3d( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7 )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              pv(i,j,k)=tmp7(i,j,k)*rhoc(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine HQGPV( x, y, z, phi, t_ref, cor, qgpv, undef, hx, hy, rhoc )
  ! Yoshino et al. (2003) : modified for (2).
  use Thermo_Const
  use Phys_Const
  use Math_Const
  use Thermo_Function
  use Derivation

  implicit none

  real, intent(in) :: x(:)  ! x κɸѿ [MKS unit]
  real, intent(in) :: y(:)  ! y κɸѿ [MKS unit]
  real, intent(in) :: z(:)  ! z κɸѿ [MKS unit] (Z or P)
  real, intent(in) :: t_ref(size(z))   ! (potential) temperature for basic [K]
                      ! p-coord : temp, z-coord : potential temp.
  real, intent(in) :: cor(size(x),size(y))  ! coriolis parameter [s-1]
  real, intent(in) :: phi(size(x),size(y),size(z))
                      ! p-coord : geopotential [J/kg], z-coord : pressure [Pa].
  real, intent(inout) :: qgpv(size(x),size(y),size(z))   ! QGPV [s-1]
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y))  ! 󥰥ե
  real, intent(in), optional :: hy(size(x),size(y))  ! 󥰥ե
  real, intent(in), optional :: rhoc(size(z))  ! basic den. for z-coord. [kg/m3]

  integer :: nx, ny, nz, i, j, k
  real :: kp, p_inv, fc, undeff
  real, dimension(size(x),size(y)) :: sx, sy
  real, dimension(size(x),size(y),size(z)) :: tmp
  real, dimension(size(z)) :: sigma, dsdp, dtdp, d2tdp2, tmpz
  logical :: z_flag

  nx=size(x)
  ny=size(y)
  nz=size(z)

  kp=Rd/Cpd

  if(present(rhoc))then
     z_flag=.true.
  else
     z_flag=.false.
  end if

  if(present(undef))then
     undeff=undef
  else
     undeff=-999.0
  end if

  if(present(hx).and.present(hy))then
     sx=hx
     sy=hy
  else
     sx=1.0
     sy=1.0
  end if

  fc=cor(nx/2,ny/2)

  !-- calculating vertical stability
  call grad_1d( z, t_ref, dtdp )
  call laplacian_1d( z, t_ref, d2tdp2 )

  if(z_flag.eqv..true.)then  ! -> Z-coord.

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        sigma(k)=g*dtdp(k)/t_ref(k)
        tmpz(k)=1.0/(rhoc(k)*sigma(k))
     end do
!$omp end do
!$omp end parallel

     call grad_1d( z, tmpz, dsdp )

  else  ! -> P-coord.

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        sigma(k)=(Rd/z(k))*(kp*t_ref(k)/z(k)-dtdp(k))
        dsdp(k)=(-sigma(k)+Rd*(kp*(dtdp(k)-t_ref(k)/z(k))/z(k)-d2tdp2(k)))/z(k)
     end do
!$omp end do
!$omp end parallel

  end if

  !-- calculating derivation for longitude

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)

  do k=1,nz
     call laplacian_2d( x, y, phi(:,:,k), tmp(:,:,k), undef=undeff,  &
  &                     hx=sx, hy=sy )
  end do

!$omp end do

!$omp barrier

!$omp do schedule(runtime) private(i,j,k)

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(z_flag.eqv..true.)then
              qgpv(i,j,k)=tmp(i,j,k)/(fc*rhoc(k))
           else
              qgpv(i,j,k)=tmp(i,j,k)/(fc)
           end if
        end do
     end do
  end do

!$omp end do

  !-- calculating derivation for altitude

!$omp barrier

!$omp do schedule(runtime) private(i,j)

  do j=1,ny
     do i=1,nx
        call laplacian_1d( z, phi(i,j,:), tmp(i,j,:) )
     end do
  end do

!$omp end do

!$omp barrier

!$omp do schedule(runtime) private(i,j,k)

  do j=1,ny
     do i=1,nx
        do k=1,nz
           if(z_flag.eqv..true.)then
              qgpv(i,j,k)=qgpv(i,j,k)+tmp(i,j,k)*fc/(rhoc(k)*sigma(k))
           else
              qgpv(i,j,k)=qgpv(i,j,k)+tmp(i,j,k)*fc/sigma(k)
           end if
        end do
     end do
  end do

!$omp end do

!$omp barrier

!$omp do schedule(runtime) private(i,j)

  do j=1,ny
     do i=1,nx
        call grad_1d( z, phi(i,j,:), tmp(i,j,:) )
     end do
  end do

!$omp end do

!$omp barrier

!$omp do schedule(runtime) private(i,j,k)

  do j=1,ny
     do i=1,nx
        do k=1,nz
           if(z_flag.eqv..true.)then
              qgpv(i,j,k)=qgpv(i,j,k)+tmp(i,j,k)*fc*dsdp(k)
           else
              qgpv(i,j,k)=qgpv(i,j,k)-tmp(i,j,k)*fc*dsdp(k)/(sigma(k)*sigma(k))
           end if
        end do
     end do
  end do

!$omp end do

!$omp barrier

!$omp do schedule(runtime) private(i,j,k)

  do k=1,nz
     do j=1,ny
        do i=1,nx
           qgpv(i,j,k)=qgpv(i,j,k)+cor(i,j)
        end do     
     end do     
  end do

!$omp end do
!$omp end parallel

end subroutine HQGPV


!--------------------------------------------------------
!--------------------------------------------------------
!!!!!!!!!!!!!!!!!!!1 under construction
subroutine Buoyanc( rhop, rhob, buo, qall )
  use phys_const
  implicit none
  real, intent(in) :: rhop(:,:,:)
  real, intent(in) :: rhob(size(rhop,3))
  real, intent(inout) :: buo(size(rhop,1),size(rhop,2),size(rhob))
  real, intent(in), optional :: qall(size(rhop,1),size(rhop,2),size(rhob))
  integer :: nx, ny, nz
  integer :: i, j, k

  nx=size(rhop,1)
  ny=size(rhop,2)
  nz=size(rhop,3)

  if(present(qall))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              buo(i,j,k)=g*(rhop(i,j,k)-rhob(k))/(rhob(k))
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              buo(i,j,k)=g*(rhop(i,j,k)-rhob(k))/(rhob(k))
           end do
        end do
     end do
  end if

end subroutine Buoyanc

!--------------------------------------------------------
!--------------------------------------------------------



end module
