!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------
module Map_Function
!  Ͽ޺ɸϤˤ뤤餫Ѵؿ

interface rt2ll
  module procedure rt2ll_f, rt2ll_d
end interface rt2ll

interface ll2radi
  module procedure ll2radi_f, ll2radi_d
end interface ll2radi

interface dis2lon
  module procedure dis2lon_f, dis2lon_d
end interface dis2lon

interface dis2lat
  module procedure dis2lat_f, dis2lat_d
end interface dis2lat

interface dis2mlon
  module procedure dis2mlon_f, dis2mlon_d
end interface dis2mlon

interface dis2mlat
  module procedure dis2mlat_f, dis2mlat_d
end interface dis2mlat

interface lonlat2lamdis
  module procedure lonlat2lamdis_f, lonlat2lamdis_d
end interface lonlat2lamdis

contains

subroutine rt2ll_f( r, theta, lon0, lat0, lon, lat )
! ϵε̺ɸϤˤ, (lon0, lat0) ΰ֤Ȥ (r,\theta) ɸ
! ŸȤ, Υ r, Ʊ̳ theta ΰ֤ˤ̾Ǥη٤
! ׻. Υ r ϵ̾α߸̵ΥȤ, theta = 90, 270 deg ̤
! Ҹ̤̾褦 theta ֤.
! ̻ˡѤƷ׻Ԥ,  theta ϵ̻ѷܳ٤ȶ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: r          ! lon0 α߸̵Υ [m]
  real, intent(in) :: theta      ! lon0 ǤƱ̳ [rad]
  real, intent(in) :: lon0       ! ˺ɸη [rad]
  real, intent(in) :: lat0       ! ˺ɸΰ [rad]
  real, intent(inout) :: lon     ! ׻줿 [rad]
  real, intent(inout) :: lat     ! ׻줿 [rad]
  real :: thetad, lond, latd, tmplon, tmplat, rratio

  thetad=180.0*theta/pi
  lond=180.0*lon0/pi
  latd=180.0*lat0/pi
  rratio=r/radius

  if(thetad==-90.0.or.thetad==270.0)then
     lon=lon0
     lat=lat0-rratio
  else if(thetad==90.0)then
     lon=lon0
     lat=lat0+rratio
  else if((-90.0<thetad.and.90.0>thetad).or.  &
  &  (270.0<thetad.and.360.0>=thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0+asin(tmplon)
  else if((90.0<thetad.and.270.0>thetad).or.  &
  &       (-180.0<=thetad.and.-90.0>thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=-sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0-asin(tmplon)
  else
     write(*,*) "### ERROR : (rt2ll:Map_Function)"
     write(*,*) "argument 'theta' is not valid : ", theta
     write(*,*) "STOP."
     stop
  end if

end subroutine rt2ll_f

!-----------------------------------------------
!-----------------------------------------------

subroutine rt2ll_d( r, theta, lon0, lat0, lon, lat )
! ϵε̺ɸϤˤ, (lon0, lat0) ΰ֤Ȥ (r,\theta) ɸ
! ŸȤ, Υ r, Ʊ̳ theta ΰ֤ˤ̾Ǥη٤
! ׻. Υ r ϵ̾α߸̵ΥȤ, theta = 90, 270 deg ̤
! Ҹ̤̾褦 theta ֤.
! ̻ˡѤƷ׻Ԥ,  theta ϵ̻ѷܳ٤ȶ.
  use Phys_Const
  use Math_Const
  implicit none
  double precision, intent(in) :: r          ! lon0 α߸̵Υ [m]
  double precision, intent(in) :: theta      ! lon0 ǤƱ̳ [rad]
  double precision, intent(in) :: lon0       ! ˺ɸη [rad]
  double precision, intent(in) :: lat0       ! ˺ɸΰ [rad]
  double precision, intent(inout) :: lon     ! ׻줿 [rad]
  double precision, intent(inout) :: lat     ! ׻줿 [rad]
  double precision :: thetad, lond, latd, tmplon, tmplat, rratio

  thetad=180.0d0*theta/pi_dp
  lond=180.0d0*lon0/pi_dp
  latd=180.0d0*lat0/pi_dp
  rratio=r/radius

  if(thetad==-90.0d0.or.thetad==270.0d0)then
     lon=lon0
     lat=lat0-rratio
  else if(thetad==90.0d0)then
     lon=lon0
     lat=lat0+rratio
  else if((-90.0d0<thetad.and.90.0d0>thetad).or.  &
  &  (270.0d0<thetad.and.360.0d0>=thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0+asin(tmplon)
  else if((90.0d0<thetad.and.270.0d0>thetad).or.  &
  &       (-180.0d0<=thetad.and.-90.0d0>thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=-sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0-asin(tmplon)
  else
     write(*,*) "### ERROR : (rt2ll:Map_Function)"
     write(*,*) "argument 'theta' is not valid : ", theta
     write(*,*) "STOP."
     stop
  end if

end subroutine rt2ll_d

!-----------------------------------------------
!-----------------------------------------------

real function ll2radi_f( lon1, lat1, lon2, lat2 )
! ̾Ǥ 2 Ǥΰ, ٤򸵤, 򽪻Ȥ߸̤εΥ
! ׻.
  use Phys_Const
  implicit none
  real, intent(in) :: lon1    !  1 Ǥη [rad]
  real, intent(in) :: lat1    !  1 Ǥΰ [rad]
  real, intent(in) :: lon2    !  2 Ǥη [rad]
  real, intent(in) :: lat2    !  2 Ǥΰ [rad]
  double precision :: lond1, lond2, latd1, latd2, tmp

  lond1=dble(lon1)
  lond2=dble(lon2)
  latd1=dble(lat1)
  latd2=dble(lat2)

  if(lond1==lond2.and.latd1==latd2)then
     ll2radi_f=0.0
  else
     tmp=sin(latd1)*sin(latd2)+cos(latd1)*cos(latd2)*cos(lond2-lond1)
     if(tmp<-1.0d0.or.tmp>1.0d0)then
        write(*,*) "*** ERROR (ll2radi) *** : Detect error", tmp, latd1, latd2, lond1, lond2
        stop
     end if
     ll2radi_f=real(acos(tmp))*radius
  end if

  return
end function ll2radi_f

!-----------------------------------------------
!-----------------------------------------------

real function ll2radi_d( lon1, lat1, lon2, lat2 )
! ̾Ǥ 2 Ǥΰ, ٤򸵤, 򽪻Ȥ߸̤εΥ
! ׻.
  use Phys_Const
  implicit none
  double precision, intent(in) :: lon1    !  1 Ǥη [rad]
  double precision, intent(in) :: lat1    !  1 Ǥΰ [rad]
  double precision, intent(in) :: lon2    !  2 Ǥη [rad]
  double precision, intent(in) :: lat2    !  2 Ǥΰ [rad]
  double precision :: lond1, lond2, latd1, latd2, tmp

  lond1=lon1
  lond2=lon2
  latd1=lat1
  latd2=lat2

  if(lond1==lond2.and.latd1==latd2)then
     ll2radi_d=0.0d0
  else
     tmp=sin(latd1)*sin(latd2)+cos(latd1)*cos(latd2)*cos(lond2-lond1)
     if(tmp<-1.0d0.or.tmp>1.0d0)then
        write(*,*) "*** ERROR (ll2radi) *** : Detect error", tmp, latd1, latd2, lond1, lond2
        stop
     end if
     ll2radi_d=real(acos(tmp))*radius
  end if

  return
end function ll2radi_d

!-----------------------------------------------
!-----------------------------------------------

real function dis2lon_f( x, lon0, phi0 )
!   lon0 ֵΥ x [m] Υ줿֤ˤ [rad].
!  ,  phi0 [rad] ƱپǷ¬ΥѤ.
!  x ˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: x     !  lon0 ζֵΥ [m] ()
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi0  !  [rad]

  dis2lon_f=x/(radius*cos(phi0))+lon0

  return
end function

!-----------------------------------------------

double precision function dis2lon_d( x, lon0, phi0 )
!   lon0 ֵΥ x [m] Υ줿֤ˤ [rad].
!  ,  phi0 [rad] ƱپǷ¬ΥѤ.
!  x ˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  double precision, intent(in) :: x     !  lon0 ζֵΥ [m] ()
  double precision, intent(in) :: lon0  !  [rad]
  double precision, intent(in) :: phi0  !  [rad]

  dis2lon_d=x/(radius*cos(phi0))+lon0

  return
end function

!---------------------------------

!---------------------------------

real function dis2lat_f( y, phi0 )
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  y ̤˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [m] (̸)
  real, intent(in) :: phi0  !  [rad]

  dis2lat_f=y/radius+phi0

  return
end function

!---------------------------------

!---------------------------------

double precision function dis2lat_d( y, phi0 )
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  y ̤˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  double precision, intent(in) :: y     !  phi0 ζֵΥ [m] (̸)
  double precision, intent(in) :: phi0  !  [rad]

  dis2lat_d=y/radius+phi0

  return
end function

!---------------------------------

!-- ʹ, Υȥ륫ȥɸϤˤٷѴؿ
real function dis2mlon_f(x,lam0)
!   lam0 Ͽ޵Υ x [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  implicit none
  real, intent(in) :: x     !  lam0 ζֵΥ [m] ()
  real, intent(in) :: lam0  !  [rad]

  dis2mlon_f=x/radius+lam0

  return
end function

!---------------------------------

double precision function dis2mlon_d(x,lam0)
!   lam0 Ͽ޵Υ x [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  implicit none
  double precision, intent(in) :: x     !  lam0 ζֵΥ [m] ()
  double precision, intent(in) :: lam0  !  [rad]

  dis2mlon_d=x/radius+lam0

  return
end function

!---------------------------------

real function dis2mlat_f(y,phi0)
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [rad] (̸).
  real, intent(in) :: phi0  !  [rad]

  dis2mlat_f=asin(tanh(log(tan(0.25*pi+0.5*phi0))+y/radius))

  return
end function

!---------------------------------

double precision function dis2mlat_d(y,phi0)
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  double precision, intent(in) :: y     !  phi0 ζֵΥ [rad] (̸).
  double precision, intent(in) :: phi0  !  [rad]

  dis2mlat_d=asin(tanh(log(tan(0.25d0*pi_dp+0.5d0*phi0))+y/radius))

  return
end function

!---------------------------------

!---------------------------------

real function lonlat2lamdis_f( lon, phi, lon0, phi1, phi2, phi0 )
!   phi1, phi2,  lon0 ٰ lon, phi [rad] Υ줿
!  ֤ޤǤϿ޾εΥ [m].
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: lon     ! ᤿η [rad].
  real, intent(in) :: phi     ! ᤿ΰ [rad].
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi1  !  1 [rad]
  real, intent(in) :: phi2  !  2 [rad]
  real, intent(in), optional :: phi0  ! Ͽ޺ɸ 0 [rad].
        ! phi0 ꤵƤ, y ɸεΥ.
  real :: n
  real :: rho, rho0

  n=log(cos(phi1)/cos(phi2))  &
  & /log(tan(0.25*pi-0.5*phi1)  &
  & /tan(0.25*pi-0.5*phi2))

  rho=(cos(phi1)*(tan(0.25*pi-0.5*phi))**n)  &
  &   /(n*(tan(0.25*pi-0.5*phi1))**n)

  if(present(phi0))then
     rho0=(cos(phi1)*(tan(0.25*pi-0.5*phi0))**n)  &
  &       /(n*(tan(0.25*pi-0.5*phi1))**n)
     lonlat2lamdis_f=rho0-rho*cos(n*(lon-lon0))
  else
     lonlat2lamdis_f=rho*sin(n*(lon-lon0))
  end if

  return
end function

!---------------------------------

!---------------------------------

double precision function lonlat2lamdis_d( lon, phi, lon0, phi1, phi2, phi0 )
!   phi1, phi2,  lon0 ٰ lon, phi [rad] Υ줿
!  ֤ޤǤϿ޾εΥ [m].
  use Phys_Const
  use Math_Const
  implicit none
  double precision, intent(in) :: lon     ! ᤿η [rad].
  double precision, intent(in) :: phi     ! ᤿ΰ [rad].
  double precision, intent(in) :: lon0  !  [rad]
  double precision, intent(in) :: phi1  !  1 [rad]
  double precision, intent(in) :: phi2  !  2 [rad]
  double precision, intent(in), optional :: phi0  ! Ͽ޺ɸ 0 [rad].
        ! phi0 ꤵƤ, y ɸεΥ.
  double precision :: n
  double precision :: rho, rho0

  n=log(cos(phi1)/cos(phi2))  &
  & /log(tan(0.25d0*pi_dp-0.5d0*phi1)  &
  & /tan(0.25d0*pi_dp-0.5d0*phi2))

  rho=(cos(phi1)*(tan(0.25d0*pi_dp-0.5d0*phi))**n)  &
  &   /(n*(tan(0.25d0*pi_dp-0.5d0*phi1))**n)

  if(present(phi0))then
     rho0=(cos(phi1)*(tan(0.25d0*pi_dp-0.5d0*phi0))**n)  &
  &       /(n*(tan(0.25d0*pi_dp-0.5d0*phi1))**n)
     lonlat2lamdis_d=rho0-rho*cos(n*(lon-lon0))
  else
     lonlat2lamdis_d=rho*sin(n*(lon-lon0))
  end if

  return
end function

!---------------------------------


end module
