program calc_TCenter_nc
! 簵ǥǷ׻줿濴׻ʿ̤
! ̤ NetCDF ǡ˽Ϥץ.
! ܥץǤα濴Ͷ˵®κǾͳʻȤ.

  use gtool_history
  use max_min
  use typhoon_analy
  use Math_Const
  use Algebra

  implicit none

  integer, parameter :: nc=4
  integer :: i, j, k, m, nx, ny, nr, nt
  integer :: tcx, tcy
  real :: tmpmin
  real, allocatable, dimension(:) :: x, y, t, r, theta, vbar
  real, allocatable, dimension(:,:) :: u, v, ws, val, vt
  real, allocatable, dimension(:,:) :: posi, posix, posiy
  real, pointer, dimension(:) :: a
  character(1000) :: vlname
  character(100) :: vuname

!-- namelist variables
  integer, dimension(2) :: fxrange, fyrange  ! first guess ranges for TCenter
  integer :: ntheta    ! azimuthal angle interval
  real :: rmax         ! azimuthally averaged maximum radius
  character(1000) :: finame, foname  ! input and output Netcdf file names
  character(100) :: xname, yname, tname  ! each coordinate name
  character(100) :: vxname, vyname  ! name of each component of wind
  character(100), dimension(nc) :: vname  ! averaged variable's name

  namelist /basic /finame, foname, xname, yname, tname, vxname, vyname,  &
  &                vname, fxrange, fyrange, rmax, ntheta
  read(5,nml=basic)

  nullify(a)
  call HistoryGetPointer( trim(adjustl(finame)), trim(adjustl(xname)), a )
  nx=size(a)
  deallocate(a)

  nullify(a)
  call HistoryGetPointer( trim(adjustl(finame)), trim(adjustl(yname)), a )
  ny=size(a)
  deallocate(a)

  nullify(a)
  call HistoryGetPointer( trim(adjustl(finame)), trim(adjustl(tname)), a )
  nt=size(a)
  deallocate(a)

  allocate(x(nx))
  allocate(y(ny))
  allocate(t(nt))
  allocate(u(nx,ny))
  allocate(v(nx,ny))
  allocate(ws(nx,ny))
  allocate(val(nx,ny))
  allocate(vt(nx,ny))
  allocate(posi(nx,ny))
  allocate(posix(nx,ny))
  allocate(posiy(nx,ny))

  call HistoryGet( trim(adjustl(finame)), trim(adjustl(xname)), x )
  call HistoryGet( trim(adjustl(finame)), trim(adjustl(yname)), y )
  call HistoryGet( trim(adjustl(finame)), trim(adjustl(tname)), t )

  nr=int(rmax/(x(2)-x(1)))

  allocate(r(nr))
  allocate(theta(ntheta))
  allocate(vbar(nr))

  do i=1,nr
     r(i)=x(i)-x(1)
  end do

  theta=(/((2.0*pi*real(i)/real(ntheta-1)),i=1,ntheta)/)

  call HistoryCreate( &                        ! ҥȥ꡼
  &    file=trim(foname),  &
  &    title='Azimuthally averaged data', &
  &    source='test',   &
  &    institution='',       &
  &    dims=(/'r', 't'/),  &
  &    dimsizes=(/nr,0/),  &
  &    longnames=(/'R-coordinate', '        Time'/),  &
  &    units=(/'m', 's'/),  &
  &    origin=real(t(1)), interval=real(t(2)-t(1)) )

  call HistoryAddVariable( &                   ! ѿ
  &    varname='vt',  &
  &    dims=(/'r','t'/),  &
  &    longname='Azimuthally averaged tangential wind',  &
  &    units='m s-1', xtype='float' )

  do m=1,nc
     if(len_trim(adjustl(vname(m)))/=0)then
        call HistoryGetAttr( trim(adjustl(finame)), trim(adjustl(vname(m))),  &
  &                          'long_name', vlname )
        call HistoryGetAttr( trim(adjustl(finame)), trim(adjustl(vname(m))),  &
  &                          'units', vuname )

        call HistoryAddVariable( &                   ! ѿ
  &          varname=trim(adjustl(vname(m))),  &
  &          dims=(/'r', 't'/),  &
  &          longname='Azimuthally Averaged '//trim(adjustl(vlname)),  &
  &          units=trim(adjustl(vuname)), xtype='float' )
     end if
  end do

  call HistoryPut( 'r', r )

  do k=1,nt
     call HistoryGet( trim(adjustl(finame)), trim(adjustl(vxname)),  &
  &                   u, range=trim(adjustl(tname))//'=^'  &
  &                            //trim(adjustl( i2c_convert(k) )) )
     call HistoryGet( trim(adjustl(finame)), trim(adjustl(vyname)),  &
  &                   v, range=trim(adjustl(tname))//'=^'  &
  &                            //trim(adjustl( i2c_convert(k) )) )
     call abst_2d( u, v, ws )
     call Min_val_2d( ws(fxrange(1):fxrange(2),fyrange(1):fyrange(2)),  &
  &                   tcx, tcy, tmpmin )

     tcx=tcx+fxrange(1)-1
     tcy=tcy+fyrange(1)-1

     write(*,*) t(k), tcx, tcy, x(tcx), y(tcy)

     do j=1,ny
        do i=1,nx
           posi(i,j)=sqrt((x(i)-x(tcx))**2+(y(j)-y(tcy))**2)
           if(posi(i,j)/=0.0)then
              posix(i,j)=(x(i)-x(tcx))/posi(i,j)
              posiy(i,j)=(y(j)-y(tcy))/posi(i,j)
           end if
        end do
     end do

     call vec_prod_2d( posix, posiy, u, v, vt )
     call tangent_mean_scal( x, y, x(tcx), y(tcy), vt, r, theta, vbar,  &
  &                          stdopt=.true. )
     call HistoryPut( 'vt', vbar )

     do m=1,nc
        if(len_trim(adjustl(vname(m)))/=0)then
           call HistoryGet( trim(adjustl(finame)), trim(adjustl(vname(m))),  &
  &                         val, range=trim(adjustl(tname))//'=^'  &
  &                                    //trim(adjustl(i2c_convert(k))) )
           call tangent_mean_scal( x, y, x(tcx), y(tcy), val, r, theta, vbar,  &
  &                                stdopt=.true. )
           call HistoryPut( trim(adjustl(vname(m))), vbar )
        end if
     end do
  end do

  call HistoryClose

end program
