program time_check
! counter_day, counter_sec, time_zone_convert Υåץ

  use Basis

  implicit none

  integer :: syear, eyear, smonth, emonth, sday, eday
  integer :: shour, ehour, smin, emin, ssec, esec
  integer :: days, sec
  character(10) :: csday, ceday
  character(8) :: cssec, cesec
  character(4) :: uyear, uuyear
  character(2) :: umonth, uday, uhour, umin, usec
  character(2) :: uumonth, uuday, uuhour, uumin, uusec

  type(dtime) :: stime, etime, utc, utcc

  write(*,*) "Input the start time [yyyy:mm:dd HH:MM:SS]."
  write(*,*) "[Example] 2013:01:01 13:00:01"
  read(*,*) csday, cssec

  write(*,*) "Input the end time [yyyy:mm:dd HH:MM:SS]."
  write(*,*) "[Example] 2013:01:01 13:00:01"
  read(*,*) ceday, cesec

!-- setting each values to type dtime

  stime%year_d=c2i_convert( csday(1:4) )
  stime%month_d=c2i_convert( csday(6:7) )
  stime%day_d=c2i_convert( csday(9:10) )
  stime%hour_d=c2i_convert( cssec(1:2) )
  stime%min_d=c2i_convert( cssec(4:5) )
  stime%sec_d=c2i_convert( cssec(7:8) )

  etime%year_d=c2i_convert( ceday(1:4) )
  etime%month_d=c2i_convert( ceday(6:7) )
  etime%day_d=c2i_convert( ceday(9:10) )
  etime%hour_d=c2i_convert( cesec(1:2) )
  etime%min_d=c2i_convert( cesec(4:5) )
  etime%sec_d=c2i_convert( cesec(7:8) )

!-- calculating by each functions

  days=counter_day( stime, etime )
  sec=counter_sec( stime, etime )

  call time_zone_convert( -9, stime, utc )
  call sec_convert( -9*3600, stime, utcc )
  uyear=i2c_convert( utc%year_d, '(i4.4)' )
  umonth=i2c_convert( utc%month_d, '(i2.2)' )
  uday=i2c_convert( utc%day_d, '(i2.2)' )
  uhour=i2c_convert( utc%hour_d, '(i2.2)' )
  umin=i2c_convert( stime%min_d, '(i2.2)' )
  usec=i2c_convert( stime%sec_d, '(i2.2)' )

  uuyear=i2c_convert( utcc%year_d, '(i4.4)' )
  uumonth=i2c_convert( utcc%month_d, '(i2.2)' )
  uuday=i2c_convert( utcc%day_d, '(i2.2)' )
  uuhour=i2c_convert( utcc%hour_d, '(i2.2)' )
  uumin=i2c_convert( stime%min_d, '(i2.2)' )
  uusec=i2c_convert( stime%sec_d, '(i2.2)' )

  write(*,'(a42)') "You input start time : "//  &
  &                csday(1:4)//'/'//csday(6:7)//'/'//csday(9:10)//' '//  &
  &                trim(cssec)

  write(*,'(a42)') "You input end time   : "//  &
  &                ceday(1:4)//'/'//ceday(6:7)//'/'//ceday(9:10)//' '//  &
  &                trim(cesec)

  write(*,*) days, "[day], ", sec, "[sec]"

  write(*,'(a61)') "time_zone_convert, start time (UTC)     : "//  &
  &                uyear(1:4)//'/'//umonth(1:2)//'/'//uday(1:2)//  &
  &                ' '//uhour(1:2)//':'//umin(1:2)//':'//usec(1:2)

  write(*,'(a61)') "sec_convert, start time (UTC)           : "//  &
  &                uuyear(1:4)//'/'//uumonth(1:2)//'/'//uuday(1:2)//  &
  &                ' '//uuhour(1:2)//':'//uumin(1:2)//':'//uusec(1:2)

end program
