module fft_force_solv_isp
!-- 全ての項は d (psi) / d t で計算されている.

  use fftsub_mod
  use fftsub_mod_isp

contains

subroutine fft_ADV_term( psik, ADV )
!-- calculating advection terms
  use Math_Const
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik     ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: ADV   ! advection term

  integer :: i, j
  double precision :: lxi, lyi
  complex(kind(0d0)), dimension(kxnt,kynt) :: uk, vk, akl, bkl, tma
  double precision, dimension(jynt,jxnt) :: u_isp, v_isp, anm_isp, bnm_isp, tmp_work
  double precision, dimension(-hynt:hynt,-hxnt:hxnt) :: uk_isp, vk_isp, akl_isp, bkl_isp

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly

  uk=0.0d0
  vk=0.0d0
  u_isp=0.0d0
  uk_isp=0.0d0
  v_isp=0.0d0
  vk_isp=0.0d0
  anm_isp=0.0d0
  akl=0.0d0
  akl_isp=0.0d0
  bnm_isp=0.0d0
  bkl=0.0d0
  bkl_isp=0.0d0
  tma=0.0d0
  tmp_work=0.0d0
  ADV=0.0d0

  call psik2ukvk( psik, uk, vk )

  call rearrange_cxy2ryx_isp( hxnt, hynt, uk(1:kxnt,1:kynt),  &
     &                        uk_isp(-hynt:hynt,-hxnt:hxnt) )
  call rearrange_cxy2ryx_isp( hxnt, hynt, vk(1:kxnt,1:kynt),  &
     &                        vk_isp(-hynt:hynt,-hxnt:hxnt) )

  CALL P2S2GA( hynt, hxnt, jynt, jxnt, uk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &            u_isp(1:jynt,1:jxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )
  CALL P2S2GA( hynt, hxnt, jynt, jxnt, vk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &            v_isp(1:jynt,1:jxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do i=1,jxnt
     do j=1,jynt
        anm_isp(j,i)=u_isp(j,i)*v_isp(j,i)
        bnm_isp(j,i)=v_isp(j,i)*v_isp(j,i)-u_isp(j,i)*u_isp(j,i)
     end do
  end do

!$omp end do
!$omp end parallel

  CALL P2G2SA( hynt, hxnt, jynt, jxnt, anm_isp(1:jynt,1:jxnt),  &
  &            akl_isp(-hynt:hynt,-hxnt:hxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )
  CALL P2G2SA( hynt, hxnt, jynt, jxnt, bnm_isp(1:jynt,1:jxnt),  &
  &            bkl_isp(-hynt:hynt,-hxnt:hxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )

  call rearrange_ryx2cxy_isp( hxnt, hynt, akl_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                           akl(1:kxnt,1:kynt) )
  call rearrange_ryx2cxy_isp( hxnt, hynt, bkl_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                           bkl(1:kxnt,1:kynt) )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=-akl(i,1)
!ORG     tma(jxnt-i+2,1)=dconjg(tma(i,1))
     tma(kxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=akl(1,j)
!ORG     tma(1,jynt-j+2)=akl(1,jynt-j+2)
     tma(1,kynt-j+2)=akl(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        tma(i,j)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,j)  &
  &              -dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,j)
                ! 上式までは渦度の移流項の計算
        tma(i,j)=tma(i,j)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
                ! 上式は渦度から流線関数への変換計算
!ORG        tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
        tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
!ORG        tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
!ORG  &                     +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
        tma(i,kynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,kynt-j+2)  &
  &                   +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,kynt-j+2)
!ORG        tma(i,jynt-j+2)=tma(i,jynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
        tma(i,kynt-j+2)=tma(i,kynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
!ORG        tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
        tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

!ORG  call rearrange_3to2( tma, ADV )
  ADV=tma

end subroutine fft_ADV_term


subroutine fft_DIFF_term( psik, DIFF )
!-- calculating diffusion term
! nu*lap(zeta)
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik      ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: DIFF   ! diffusion term

  integer :: i, j
  double precision :: lxi, lyi, pi4

  DIFF=0.0d0

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     DIFF(i,1)=-nu*pi4*((dble(i-1)*lxi)**2)*psik(i,1)
     DIFF(kxnt-i+2,1)=dconjg(DIFF(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     DIFF(1,j)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,j)
     DIFF(1,kynt-j+2)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        DIFF(i,j)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*psik(i,j)
        DIFF(kxnt-i+2,kynt-j+2)=dconjg(DIFF(i,j))
        DIFF(i,kynt-j+2)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)  &
  &                    *psik(i,kynt-j+2)
        DIFF(kxnt-i+2,j)=dconjg(DIFF(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine fft_DIFF_term


subroutine fft_STRETCH_term( psik, STRETCH )
!-- calculating stretching terms
  use Math_Const
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik     ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: STRETCH   ! advection term

  integer :: i, j
  double precision :: lxi, lyi, pi4, f0z_inv
  complex(kind(0d0)), dimension(kxnt,kynt) :: zk, akl, tma
  double precision, dimension(jynt,jxnt) :: z_isp, anm_isp, tmp_work
  double precision, dimension(-hynt:hynt,-hxnt:hxnt) :: zk_isp, akl_isp

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp
  f0z_inv=1.0d0/(f0+zetam)

  zk=0.0d0
  z_isp=0.0d0
  zk_isp=0.0d0
  anm_isp=0.0d0
  akl=0.0d0
  akl_isp=0.0d0
  tma=0.0d0
  tmp_work=0.0d0
  STRETCH=0.0d0

  call psik2zetak( psik, zk )

  call rearrange_cxy2ryx_isp( hxnt, hynt, zk(1:kxnt,1:kynt),  &
     &                        zk_isp(-hynt:hynt,-hxnt:hxnt) )

  CALL P2S2GA( hynt, hxnt, jynt, jxnt, zk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &            z_isp(1:jynt,1:jxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )

!$omp parallel default(shared)

  select case (force_type)
  case (1)  ! default by Rozoff et al. (2009)

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           ! cav = cr_isp/(f0+zetam)
           anm_isp(j,i)=(f0+z_isp(j,i))*(zetam-z_isp(j,i))*cr_isp(j,i)*f0z_inv
        end do
     end do

!$omp end do

  case (2)  ! modification for low vorticity area

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           if(z_isp(j,i)<zetam.and.z_isp(j,i)>sth_thres_zeta)then
              ! cav = cr_isp/(f0+zetam)
              anm_isp(j,i)=(f0+z_isp(j,i))*(zetam-z_isp(j,i))*cr_isp(j,i)*f0z_inv
           end if
        end do
     end do

!$omp end do

  case (3)  ! forcing to the initial profile of vorticity

!$omp do schedule(runtime) private(i,j)

     do i=1,jxnt
        do j=1,jynt
           ! cav = cr_isp/(f0+zetam)
           anm_isp(j,i)=(f0+z_isp(j,i))*(zinit_isp(j,i)-z_isp(j,i))*cr_isp(j,i)/(f0+zinit_isp(j,i))
        end do
     end do

!$omp end do

  case default

     write(*,*) "*** ERROR (calc_STRETCH_term) ***: flag_stretch = .true. but, invalid for force_type."
     stop

  end select

!$omp end parallel

  CALL P2G2SA( hynt, hxnt, jynt, jxnt, anm_isp(1:jynt,1:jxnt),  &
  &            akl_isp(-hynt:hynt,-hxnt:hxnt), tmp_work(1:jynt,1:jxnt),  &
  &            ITJJ, TJJ, ITIJ, TIJ )

  call rearrange_ryx2cxy_isp( hxnt, hynt, akl_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                           akl(1:kxnt,1:kynt) )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=-akl(i,1)/(((dble(i-1)*lxi)**2)*pi4)
!ORG     tma(jxnt-i+2,1)=dconjg(tma(i,1))
     tma(kxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=-akl(1,j)/(((dble(j-1)*lyi)**2)*pi4)
!ORG     tma(1,jynt-j+2)=akl(1,jynt-j+2)
     tma(1,kynt-j+2)=-akl(1,kynt-j+2)/(((dble(j-1)*lyi)**2)*pi4)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        tma(i,j)=-akl(i,j)/(((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*pi4)
                ! 上式は渦度から流線関数への変換計算
!ORG        tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
        tma(kxnt-i+2,kynt-j+2)=dconjg(tma(i,j))
!ORG        tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
!ORG  &                     +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
        tma(i,kynt-j+2)=-akl(i,kynt-j+2)/(((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*pi4)
!ORG        tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
        tma(kxnt-i+2,j)=dconjg(tma(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

!ORG  call rearrange_3to2( tma, ADV )
  STRETCH=tma

end subroutine fft_STRETCH_term


subroutine fft_LIDAMP_term( psik, LIDAMP )
!-- calculating diffusion term
! -mu*zeta
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik      ! psik
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: LIDAMP ! linear damping term

  integer :: i, j
  double precision :: lxi, lyi, pi4

  LIDAMP=0.0d0

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     LIDAMP(i,1)=-mu*psik(i,1)
     LIDAMP(kxnt-i+2,1)=dconjg(LIDAMP(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     LIDAMP(1,j)=-mu*psik(1,j)
     LIDAMP(1,kynt-j+2)=-mu*psik(1,kynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        LIDAMP(i,j)=-mu*psik(i,j)
        LIDAMP(kxnt-i+2,kynt-j+2)=dconjg(LIDAMP(i,j))
        LIDAMP(i,kynt-j+2)=-mu*psik(i,kynt-j+2)
        LIDAMP(kxnt-i+2,j)=dconjg(LIDAMP(i,kynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine fft_LIDAMP_term


subroutine fft_calc_FORCE( psik, force )
!-- calculating total forcing terms
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(kxnt,kynt), intent(in) :: psik       ! psi
  complex(kind(0d0)), dimension(kxnt,kynt), intent(inout) :: force   ! total force

  integer :: i, j
  complex(kind(0d0)), dimension(kxnt,kynt) :: ADV, DIFF, STRETCH, LIDAMP

  force=0.0d0
  STRETCH=0.0d0
  LIDAMP=0.0d0

!-- calculating advecting term 

  call fft_ADV_term( psik, ADV )

!-- calculating beta effect

!  call BETA_term( v, BETA )

!-- calculating diffusion term

  call fft_DIFF_term( psik, DIFF )

!-- calculating stretching term

  if(flag_stretch.eqv..true.)then
     call fft_STRETCH_term( psik, STRETCH )
  end if

!-- calculating rayleigh damping term

  if(flag_fric.eqv..true.)then
     call fft_LIDAMP_term( psik, LIDAMP )
  end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do j=1,2*hynt+1
     do i=1,hxnt+1
!        force(i,j)=-ADV(i,j)+BETA(i,j)+DIFF(i,j)
!        force(i,j)=DIFF(i,j)
        force(i,j)=ADV(i,j)+DIFF(i,j)+STRETCH(i,j)+LIDAMP(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine fft_calc_FORCE


end module fft_force_solv_isp
