program radiation
! 気象研究ノートの放射 FDTD 法による放射プロセス直接計算プログラム

  use Derivation
  use file_operate
  use gtool_history

  implicit none
!-- value setting part
!-- integer part
  integer :: nx  ! x 方向の格子点
  integer :: ny  ! y 方向の格子点
  integer :: nz  ! z 方向の格子点
  integer ::   ! 
  integer ::   ! 
  integer ::   ! 
  integer ::   ! 
  integer ::   ! 

!-- real part
  real, allocatable, dimension(:) :: x  ! x 方向の座標
  real, allocatable, dimension(:) :: y  ! y 方向の座標
  real, allocatable, dimension(:) :: z  ! z 方向の座標
!-- writing file value
  real, allocatable, dimension(:,:,:) :: Ex_old  ! x 電場 old
  real, allocatable, dimension(:,:,:) :: Ey_old  ! y 電場 old
  real, allocatable, dimension(:,:,:) :: Ez_old  ! z 電場 old
  real, allocatable, dimension(:,:,:) :: Hx_old  ! x 磁場 old
  real, allocatable, dimension(:,:,:) :: Hy_old  ! y 磁場 old
  real, allocatable, dimension(:,:,:) :: Hz_old  ! z 磁場 old
  real, allocatable, dimension(:,:,:) :: Ex_new  ! x 電場 new
  real, allocatable, dimension(:,:,:) :: Ey_new  ! y 電場 new
  real, allocatable, dimension(:,:,:) :: Ez_new  ! z 電場 new
  real, allocatable, dimension(:,:,:) :: Hx_new  ! x 磁場 new
  real, allocatable, dimension(:,:,:) :: Hy_new  ! y 磁場 new
  real, allocatable, dimension(:,:,:) :: Hz_new  ! z 磁場 new
!-- calculating value
  real, allocatable, dimension(:,:,:) :: Exc_old  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Eyc_old  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Ezc_old  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Hxc_old  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: Hyc_old  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: Hzc_old  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: Exc_new  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Eyc_new  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Ezc_new  ! 半格子電場
  real, allocatable, dimension(:,:,:) :: Hxc_new  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: Hyc_new  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: Hzc_new  ! 半格子磁場
  real, allocatable, dimension(:,:,:) :: termE1, termE2, termE3  ! tmp 項
  real, allocatable, dimension(:,:,:) :: termH1, termH2, termH3  ! tmp 項
  real, allocatable, dimension(:,:,:) :: forceE1, forceE2, forceE3  ! force 項
  real, allocatable, dimension(:,:,:) :: forceH1, forceH2, forceH3  ! force 項
  real :: dt  ! t 方向の格子間隔
  real :: dx  ! x 方向の格子間隔
  real :: dy  ! y 方向の格子間隔
  real :: dz  ! z 方向の格子間隔
  real :: xinit  ! x 方向の原点
  real :: yinit  ! y 方向の原点
  real :: zinit  ! z 方向の原点
  real ::   ! 
  real ::   ! 
  real ::   ! 
  real ::   ! 
  real ::   ! 
  real ::   ! 
  real ::   ! 

!-- character part
  character(80) :: finame  ! input file name
  character(80) :: foname  ! input file name
  character(80) :: cval  ! 
  character(80) ::   ! 
  character(80) ::   ! 
  character(80) ::   ! 
  character(80) ::   ! 

!-- namelist reading part
  namelist /input /
  read(5,nml=input)

!-- array allocate part


!-- reading initial file
  call HistoryGet( trim(finame), 'x', x )
  call HistoryGet( trim(finame), 'y', y )
  call HistoryGet( trim(finame), 'z', z )
  call HistoryGet( trim(finame), 'E_ini', E_old )
  call HistoryGet( trim(finame), 'H_ini', H_old )

!-- output file initializing
  call HistoryCreate( &                        ! ヒストリー作成
    & file=trim(foname), title='model dumping file', &
    & source='',   &
    & institution='',  &
    & dims=(/'x', 'y', 'z', 't'/), dimsizes=(/ nx, ny, nz, 0 /),  &
    & longnames=(/ 'X-coordinate', 'Y-coordinate', 'Z-coordinate', 'time'/),  &
    & units=(/'m', 'm', 'm', 's'/),  &
    & origin=real(tinit), interval=real(tstep*dt) )

  call HistoryPut('x',x)                       ! 次元変数出力
  call HistoryPut('y',y)                       ! 次元変数出力
  call HistoryPut('z',z)                       ! 次元変数出力

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Evar-x', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Electric field X', units='kg m s|-3"A|-1"', xtype='double')

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Evar-y', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Electric field Y', units='kg m s|-3"A|-1"', xtype='double')

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Evar-z', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Electric field Z', units='kg m s|-3"A|-1"', xtype='double')

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Hvar-x', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Magnetic field X', units='A m|-1"', xtype='double')

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Hvar-y', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Magnetic field Y', units='A m|-1"', xtype='double')

  call HistoryAddVariable( &                   ! 変数定義
    & varname='Hvar-z', dims=(/'x', 'y', 'z', 't'/), &
    & longname='Magnetic field Z', units='A m|-1"', xtype='double')

  call HistoryPut( 'Evar-x', Ex_old )                 ! 変数出力
  call HistoryPut( 'Evar-y', Ey_old )                 ! 変数出力
  call HistoryPut( 'Evar-z', Ez_old )                 ! 変数出力
  call HistoryPut( 'Hvar-x', Hx_old )                 ! 変数出力
  call HistoryPut( 'Hvar-y', Hy_old )                 ! 変数出力
  call HistoryPut( 'Hvar-z', Hz_old )                 ! 変数出力

!-- grid setting part
!-- Ex
  do k=1,nz+3
     do j=1,ny+3
        call HI( x, Ex_old(:,j,k), Exc_old(:,j,k) )
     end do
  end do
!-- Ey
  do k=1,nz+3
     do i=1,nx+3
        call HI( y, Ey_old(i,:,k), Eyc_old(i,:,k) )
     end do
  end do
!-- Ez
  do j=1,ny+3
     do i=1,nx+3
        call HI( z, Ez_old(i,j,:), Ezc_old(i,j,:) )
     end do
  end do
!-- Hx
  do i=1,nx+3
     call HII( y, z, Hx_old(i,:,:), Hxc_old(i,:,:) )
  end do
!-- Hy
  do j=1,ny+3
     call HII( x, z, Hy_old(:,j,:), Hyc_old(:,j,:) )
  end do
!-- Hz
  do k=1,nz+3
     call HII( x, y, Hz_old(:,:,k), Hzc_old(:,:,k) )
  end do

!-- 磁場計算用の半時間データ作成
  call curl_3d( x, y, z, Exc_old, Eyc_old, Ezc_old, termH1, termH2, termH3 )
  call curl_3d( x, y, z, Hxc_old, Hyc_old, Hzc_old, termE1, termE2, termE3 )

  coeH1=0.5*dt/nux
  coeH2=0.5*dt/nuy
  coeH3=0.5*dt/nuz
  coeE1=dt/eprx
  coeE2=dt/epry
  coeE3=dt/eprz
  coeE4=1.0-omega*epix/eprx
  coeE5=1.0-omega*epiy/epry
  coeE6=1.0-omega*epiz/eprz

!$omp parallel default(shared)
!$omp do private(i,j,k)
  do k=1,nz+3
     do j=1,ny+3
        do i=1,nx+3
           Hxc_new(i,j,k)=Hxc_old(i,j,k)+coeH1*termH1(i,j,k)
           Hyc_new(i,j,k)=Hyc_old(i,j,k)+coeH2*termH2(i,j,k)
           Hzc_new(i,j,k)=Hzc_old(i,j,k)+coeH3*termH3(i,j,k)
           Exc_new(i,j,k)=coeE4*Exc_old(i,j,k)+coeE1*termE1(i,j,k)
           Eyc_new(i,j,k)=coeE5*Eyc_old(i,j,k)+coeE2*termE2(i,j,k)
           Ezc_new(i,j,k)=coeE6*Ezc_old(i,j,k)+coeE3*termE3(i,j,k)
        end do
     end do
  end do
!$omp end do
!$omp end parallel

!-- coefficient part
     coeH1=dt/nux
     coeH2=dt/nuy
     coeH3=dt/nuz
     coeE1=dt/eprx
     coeE2=dt/epry
     coeE3=dt/eprz
     coeE4=1.0-omega*epix/eprx
     coeE5=1.0-omega*epiy/epry
     coeE6=1.0-omega*epiz/eprz

!-- time lapse part (start)
  do id=2,tstep

!-- array setting
!$omp parallel default(shared)
!$omp do private(i,j,k)
     do k=1,nz+3
        do j=1,ny+3
           do i=1,nx+3
              Hxc_old(i,j,k)=Hxc_new(i,j,k)
              Hyc_old(i,j,k)=Hyc_new(i,j,k)
              Hzc_old(i,j,k)=Hzc_new(i,j,k)
              Exc_old(i,j,k)=Exc_new(i,j,k)
              Eyc_old(i,j,k)=Eyc_new(i,j,k)
              Ezc_old(i,j,k)=Ezc_new(i,j,k)
           end do
        end do
     end do
!$omp end do
!$omp end parallel

!-- curl calculate
     call curl_3d( x, y, z, Exc_old, Eyc_old, Ezc_old, termH1, termH2, termH3 )
     call curl_3d( x, y, z, Hxc_old, Hyc_old, Hzc_old, termE1, termE2, termE3 )

!-- equation calculate
!-- term part
!$omp parallel default(shared)
!$omp do private(i,j,k)
     do k=1,nz+3
        do j=1,ny+3
           do i=1,nx+3
              Hxc_new(i,j,k)=Hxc_old(i,j,k)+coeH1*termH1(i,j,k)
              Hyc_new(i,j,k)=Hyc_old(i,j,k)+coeH2*termH2(i,j,k)
              Hzc_new(i,j,k)=Hzc_old(i,j,k)+coeH3*termH3(i,j,k)
              Exc_new(i,j,k)=coeE4*Exc_old(i,j,k)+coeE1*termE1(i,j,k)
              Eyc_new(i,j,k)=coeE5*Eyc_old(i,j,k)+coeE2*termE2(i,j,k)
              Ezc_new(i,j,k)=coeE6*Ezc_old(i,j,k)+coeE3*termE3(i,j,k)
           end do
        end do
     end do
!$omp end do
!$omp end parallel


!-- writing output file part
     do k=1,nz
        call gtool_history
     end do

  end do
!-- time lapse part (end)


end program

subroutine HI( x, ival, oval )
! x 座標について, 半格子内挿を行う.
  implicit none
  real, intent(in) :: x(:)  ! 内挿座標
  real, intent(in) :: ival(size(x))  ! 内挿前値
  real, intent(out) :: oval(size(x))  ! 内挿後値
  integer :: i, nx

  nx=size(x)

  do i=1,nx-1
     oval(i)=(ival(i)+ival(i+1))*0.5
  end do

end subroutine HI

subroutine HII( x, y, ival, oval )
! x, y 座標について, 半格子内挿を行う.
  implicit none
  real, intent(in) :: x(:)  ! 内挿座標 1
  real, intent(in) :: y(:)  ! 内挿座標 2
  real, intent(in) :: ival(size(x),size(y))  ! 内挿前値
  real, intent(out) :: oval(size(x),size(y))  ! 内挿後値
  integer :: i, j, nx, ny

  nx=size(x)
  ny=size(y)

  do j=1,ny-1
     do i=1,nx-1
        oval(i,j)=(ival(i,j)+ival(i,j+1)+ival(i+1,j)+ival(i+1,j+1))*0.25
     end do
  end do

end subroutine HII

subroutine HIII( x, y, z, ival, oval )
! x, y, z 座標について, 半格子内挿を行う.
  implicit none
  real, intent(in) :: x(:)  ! 内挿座標 1
  real, intent(in) :: y(:)  ! 内挿座標 2
  real, intent(in) :: z(:)  ! 内挿座標 3
  real, intent(in) :: ival(size(x),size(y),size(z))  ! 内挿前値
  real, intent(out) :: oval(size(x),size(y),size(z))  ! 内挿後値
  integer :: i, j, k, nx, ny, nz

  nx=size(x)
  ny=size(y)
  nz=size(z)

!$omp parallel default(shared)
!$omp do private(i,j,k)
  do k=1,nz-1
     do j=1,ny-1
        do i=1,nx-1
           oval(i,j,k)=(ival(i,j,k)+ival(i,j+1,k)+ival(i+1,j,k)  &
  &                    +ival(i+1,j+1,k)  &
  &                    +ival(i,j,k+1)+ival(i,j+1,k+1)+ival(i+1,j,k+1)  &
  &                    +ival(i+1,j+1,k+1))*0.125
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine HIII
