module savegloval_alloc

!-- Allocate global variables in savegloval_define

contains

subroutine savegloval_allocate()

  use savegloval_define

  implicit none

  integer :: err

  err=0

  allocate(x(nx),stat=err)  ! x 座標
  allocate(y(ny),stat=err)  ! y 座標
  allocate(z(nz),stat=err)  ! z 座標
  allocate(z_pe(0:nzp+1),stat=err)  ! z 座標 at each MPI process

  allocate(xd(nx),stat=err)  ! x 座標
  allocate(yd(ny),stat=err)  ! y 座標
  allocate(zd(nz),stat=err)  ! z 座標
  allocate(zd_pe(0:nzp+1),stat=err)  ! z 座標

  !-- 変換法用座標
  allocate(xj(jxnt),stat=err)
  allocate(yj(jynt),stat=err)

  allocate(xi(nxi),stat=err)
  allocate(yi(nyi),stat=err)

!ORG  allocate(t(nt))
  allocate(cr(jxnt,jynt),stat=err)
  allocate(cr_isp(jynt,jxnt),stat=err)
  allocate(zinit_isp(jynt,jxnt),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (savegloval_allocate) *** : cannot allocate."
     stop
  end if

  !-- For ISPACK variables

  err=0
  allocate(TJR(2*ny),stat=err)
  allocate(TIR(2*nx),stat=err)
  allocate(ITJR(5),stat=err)
  allocate(ITIR(5),stat=err)
  allocate(TJJ(2*jynt),stat=err)
  allocate(TIJ(2*jxnt),stat=err)
  allocate(ITJJ(5),stat=err)
  allocate(ITIJ(5),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (savegloval_allocate) *** : cannot allocate for ISPACK variables."
     stop
  end if

  !-- For debug
  err=0
  allocate(HADVud(kxnt,kynt,0:nzp+1))
  allocate(HADVvd(kxnt,kynt,0:nzp+1))
  allocate(VADVud(kxnt,kynt,0:nzp+1))
  allocate(VADVvd(kxnt,kynt,0:nzp+1))
  allocate(HDIFFud(kxnt,kynt,0:nzp+1))
  allocate(HDIFFvd(kxnt,kynt,0:nzp+1))
  allocate(VDIFFud(kxnt,kynt,0:nzp+1))
  allocate(VDIFFvd(kxnt,kynt,0:nzp+1))
  allocate(CORILud(kxnt,kynt,0:nzp+1))
  allocate(CORILvd(kxnt,kynt,0:nzp+1))
  allocate(PGRADud(kxnt,kynt,0:nzp+1))
  allocate(PGRADvd(kxnt,kynt,0:nzp+1))

  if(err/=0)then
     write(*,*) "*** ERROR (savegloval_allocate) *** : cannot allocate for debug variables."
     stop
  end if

HADVud=0.0d0
HADVvd=0.0d0
VADVud=0.0d0
VADVvd=0.0d0
HDIFFud=0.0d0
HDIFFvd=0.0d0
VDIFFud=0.0d0
VDIFFvd=0.0d0
CORILud=0.0d0
CORILvd=0.0d0
PGRADud=0.0d0
PGRADvd=0.0d0

end subroutine savegloval_allocate

end module savegloval_alloc
