program solver_shallow
!-- 2 次元円環での浅水モデル
  use gtool_history
  use Derivation
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define_shallow
  use read_namelist_shallow
  use val_alloc_shallow
  use val_coord_shallow
  use time_scheme_shallow
  use make_init_shallow
  use sub_calc
  use force_solv_shallow

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, counter_psi

!-- テンポラリ実変数
  real :: mean_psi, chan_leng

!-- namelist の読み込み

  call read_name_shallow()

!-- allocating array

  call val_allocate_shallow()

!-- 格子点の再定義

  call val_coordinate_shallow()

!-- 初期値化 (計算領域の設定や境界条件の設定, 特にポアソン計算について)

write(*,*) "starting initialization."

!!-- 初期条件データから読み込み
!
!  call read_file_text( trim(inner_file), nx, ny, cval, skip=1,  &
!  &                    forma='('//trim(adjustl(i2c_convert(nx)))//'a1)' )
!
!!-- psi, omega に対して, 各境界条件フラグを設定.
!
!  do j=1,ny
!     do i=1,nx
!        if(trim(adjustl(cval(i,j)))=='-')then
!           ibo(i,j)=10
!           ibp(i,j)=10
!           calc_flag(i,j)=.false.
!        else
!           ibp(i,j)=c2i_convert( trim(adjustl(cval(i,j))) )
!           ibo(i,j)=c2i_convert( trim(adjustl(cval(i,j))) )
!           if(ibp(i,j)==0)then
!              calc_flag(i,j)=.true.
!           else
!              calc_flag(i,j)=.false.
!           end if
!        end if
!     end do
!  end do

  boundary='3131'  ! psi はポアソンソルバに渡す分だけ作成.

!  do j=1,ny
!     ibo(1,j)=1
!     ibo(nx,j)=1
!  end do
!
!  do i=1,nx
!     ibo(i,1)=3
!     ibo(i,ny)=3
!  end do

!-- 初期値作成

  if(len_trim(finame)==0)then
     omega_old=0.0
     psi_old=0.0
     chan_leng=x(nx)-x(1)

     do j=1,ny
        do i=1,nx
!-- For uniform vbar
           psi_old(i,j)=-vbar*(x(i)-0.5*chan_leng)

!-- For horizontal shear in vbar
!if(j<=ny/2)then
!           psi_old(i,j)=vbar*(y(j)-0.5*chan_leng)
!else
!           psi_old(i,j)=(2.0*vbar/chan_leng)*(chan_leng*y(j)-0.5*y(j)**2)  &
!  &                     -0.75*vbar*chan_leng
!end if
           omega_old(i,j)=vbar*x_inv(i)
           if(i==nx/2)then
              omega_old(i,j)=omega_old(i,j)+0.4*cos(2.0*y(j))
              psi_old(i,j)=psi_old(i,j)+0.4*(-0.25*x(i))*cos(2.0*y(j))
           else if(i>nx/2)then
              psi_old(i,j)=psi_old(i,j)+0.4*(-0.25*x(nx/2)*(x(nx/2)/x(i))**2)*cos(2.0*y(j))
           else if(i<nx/2)then
              psi_old(i,j)=psi_old(i,j)+0.4*(-0.25*x(nx/2)*(x(i)/x(nx/2))**2)*cos(2.0*y(j))
           end if
        end do
     end do

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              psi_old(i,j)=undef
              omega_old(i,j)=undef
           end if
        end do
     end do
  else
     call make_initialize()
  end if

!-- 境界強制値の設定.

  bndp=0.0
  bndo=0.0

  !-- 以下で境界値を設定しているが, フラックス量や固定強制量がゼロの場合は
  !   上で既に設定(初期化)しているので行わない.
  do i=1,nx
     bndp(i,1)=psi_old(i,1)
  end do

  do j=1,ny
     bndp(1,j)=bndp(1,1)
     bndp(nx,j)=bndp(nx,1)
  end do

!-- 内部境界での psi の値は境界廻りの psi の平均値を用いることにする.

  mean_psi=0.0
  counter_psi=0

  do j=2,ny-1
     do i=2,nx-1
        if(ibp(i,j)==1)then
           mean_psi=mean_psi-vbar*(x(i)-0.5*(x(nx)-x(1)))
           counter_psi=counter_psi+1
        end if
     end do
  end do

  if(counter_psi>0)then
     mean_psi=mean_psi/real(counter_psi)
  end if

  do j=2,ny-1
     do i=2,nx-1
        if(ibp(i,j)==1)then
           bndp(i,j)=mean_psi
           psi_old(i,j)=mean_psi
        end if
     end do
  end do

  call set_omega_inner( x, y, psi_old, ibo, bndo )
  call bound_set( x, y, omega_old, ibo, bndo, undef )

  write(*,*) "normally pass the initialization."

!-- 出力ファイルの初期化
  call HistoryCreate( file=trim(foname), title='Tank experiment data', &
  & source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  & dimsizes=(/nx,ny, 0/),  & 
  & longnames=(/'Radius ','Azimuth', 'Time   '/),  &
  & units=(/'m     ', 'degree', 's     '/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'x', x_fact*x )
  call HistoryPut( 'y', y*r2d )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
    & longname='streamfunction', units='m2 s-1', xtype='float')

  call HistoryAddVariable( varname='xi', dims=(/'x','y','t'/), &
    & longname='velocity potential', units='m2 s-1', xtype='float')

  call HistoryAddVariable( varname='omega', dims=(/'x','y','t'/), &
    & longname='vorticity', units='s-1', xtype='float')

  call HistoryAddVariable( varname='div', dims=(/'x','y','t'/), &
    & longname='divergence', units='s-1', xtype='float')

  call HistoryAddVariable( varname='urot', dims=(/'x','y','t'/), &
    & longname='radial component of rotating wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='vrot', dims=(/'x','y','t'/), &
    & longname='tangential component of rotating wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='udiv', dims=(/'x','y','t'/), &
    & longname='radial component of divergent wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='vdiv', dims=(/'x','y','t'/), &
    & longname='tangential component of divergent wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
    & longname='radial component of horizontal wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
    & longname='tangential component of horizontal wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='eta', dims=(/'x','y','t'/), &
    & longname='surface height of the shallow water', units='m', xtype='float')

  write(*,*) "time integration start."

  !-- 出力等の処理 (初期値の出力)

  call calc_wind( x, y, psi_old, u_dmp, v_dmp, undef=undef )

  do j=1,ny
     do i=1,nx
        psi_dmp(i,j)=psi_old(i,j)
        omega_dmp(i,j)=omega_old(i,j)
        psi_new(i,j)=psi_old(i,j)
        omega_new(i,j)=omega_old(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call HistoryPut( 'psi', psi_dmp )
  call HistoryPut( 'omega', omega_dmp )
  call HistoryPut( 'u', u_dmp )
  call HistoryPut( 'v', v_dmp )

!-- solver スタート

  do it=1,nt

     call time_schematic( it )

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        do j=1,ny
           do i=1,nx
              psi_dmp(i,j)=psi_new(i,j)
              omega_dmp(i,j)=omega_new(i,j)
           end do
        end do

        call calc_wind( x, y, psi_dmp, u_dmp, v_dmp, undef=undef )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'psi', psi_dmp )
        call HistoryPut( 'omega', omega_dmp )
        call HistoryPut( 'u', u_dmp )
        call HistoryPut( 'v', v_dmp )

     end if

  end do

!-- solver ストップ

  write(*,*) "solver is normally."

end program solver_shallow
