program fft_test
! fft ルーチンを用いて, テキストデータからスペクトル分布を計算するルーチン

  use file_operate
  use Basis
  use ffts
  use Math_Const
  use max_min

  implicit none

  integer :: na, nlx, nly
  integer :: i, j, k, l, emax, loop
  integer, dimension(5) :: primx, primy

  real :: period
  real, allocatable :: sp(:,:,:), ren(:,:,:)
  real, allocatable :: val(:,:,:)

  complex, allocatable :: co(:,:,:), ccval(:,:,:), crval(:,:,:)
  complex, allocatable, dimension(:,:) :: omegarx, omegaix, omeganrx, omeganix
  complex, allocatable, dimension(:,:) :: omegary, omegaiy, omeganry, omeganiy

  character(20), allocatable, dimension(:,:) :: cval
  character(20) :: fom, fomc
  character(100) :: foname
  character(1000) :: ctitle

  write(*,*) "Input a reading file name."
  write(*,*) "If there is no file, input 'dummy'"

  write(*,*) "Automatically, sample file is producted."

  na=3
  nlx=100
  nly=100

  allocate(val(nlx,nly,na))
  allocate(ccval(nlx,nly,na))
  allocate(crval(nlx,nly,na))
  allocate(ren(nlx,nly,na))

  do j=1,nly
  do i=1,nlx
     val(i,j,1)=1.0+sin(2.0*pi*(real(i-1)/real(nlx)))*sin(2.0*pi*(real(j-1)/real(nly)))
     val(i,j,2)=1.0+sin(4.0*pi*(real(i-1)/real(nlx)))*sin(4.0*pi*(real(j-1)/real(nly)))
     val(i,j,3)=1.0+sin(6.0*pi*(real(i-1)/real(nlx)))*sin(6.0*pi*(real(j-1)/real(nly)))
  end do
  end do

!-- NOTICE : array order is opposite (char : na, nlx) (float : nlx, na)
  allocate(co(nlx,nly,na))
  allocate(sp(nlx,nly,na))

!-- calculating prim factors for nlx

  call prim_calc( nlx, primx(1:4), primx(5) )
  write(*,*) "result primx", primx(1:5)
  call prim_calc( nly, primy(1:4), primy(5) )
  write(*,*) "result primy", primy(1:5)

!-- calculating rotating arrays

  allocate(omegarx(0:nlx-1,0:nlx-1))
  allocate(omegaix(0:nlx-1,0:nlx-1))
  allocate(omeganrx(0:nlx-1,0:nlx-1))
  allocate(omeganix(0:nlx-1,0:nlx-1))
  allocate(omegary(0:nly-1,0:nly-1))
  allocate(omegaiy(0:nly-1,0:nly-1))
  allocate(omeganry(0:nly-1,0:nly-1))
  allocate(omeganiy(0:nly-1,0:nly-1))

  call rotate_array_f()
  call rotate_calc( nlx, 'r', primx(1:5),  &
  &                 omegarx(0:primx(5)-1,0:primx(5)-1),  &
  &                 omeganrx(0:nlx-1,0:nlx-1) )
  call rotate_calc( nlx, 'i', primx(1:5),  &
  &                 omegaix(0:primx(5)-1,0:primx(5)-1),  &
  &                 omeganix(0:nlx-1,0:nlx-1) )

  call rotate_calc( nly, 'r', primy(1:5),  &
  &                 omegary(0:primy(5)-1,0:primy(5)-1),  &
  &                 omeganry(0:nly-1,0:nly-1) )
  call rotate_calc( nly, 'i', primy(1:5),  &
  &                 omegaiy(0:primy(5)-1,0:primy(5)-1),  &
  &                 omeganiy(0:nly-1,0:nly-1) )

  do k=1,na
     do j=1,nly
     do i=1,nlx
        ccval(i,j,k)=val(i,j,k)
     end do
     end do
     call ffttp_2d( nlx, nly, ccval(1:nlx,1:nly,k), co(1:nlx,1:nly,k),  &
  &                 csign='r', prim='o', prim_factx=primx, prim_facty=primy,  &
  &                 omegax_fix=omegarx, omegaxn_fix=omeganrx,  &
  &                 omegay_fix=omegary, omegayn_fix=omeganry )
     call ffttp_2d( nlx, nly, co(1:nlx,1:nly,k), crval(1:nlx,1:nly,k),  &
  &                 csign='i', prim='o', prim_factx=primx, prim_facty=primy,  &
  &                 omegax_fix=omegaix, omegaxn_fix=omeganix,  &
  &                 omegay_fix=omegaiy, omegayn_fix=omeganiy )
     do i=1,nlx
        do j=2,nly/2-1
           sp(i,j,k)=abs(co(i,j,k))+abs(co(i,nly-(j-2),k))
        end do
        sp(i,1,k)=abs(co(i,1,k))
        sp(i,nly/2,k)=abs(co(i,nly/2,k))
!        sp(1,j)=abs(real(co(1,j)))
!        sp(nlx/2+1,j)=abs(aimag(co(1,j)))
     end do
     do j=1,nly
     do i=1,nlx
        ren(i,j,k)=real(crval(i,j,k))
     end do
     end do
  end do

  do j=1,nly
  do i=1,nlx
     write(*,*) val(i,j,1), ren(i,j,1), val(i,j,2), ren(i,j,2), val(i,j,3), ren(i,j,3)
  end do
  end do

  write(*,*) "### Finished calculating."
  write(*,*) "Input the output file name."
  read(*,*) foname

  write(*,*) "Input the calculating period."
  write(*,*) "(data period)"
  read(*,*) period

!-- formatting of output

  fom='(1P,'//trim(adjustl(i2c_convert( na+6 )))//'E14.5)'
write(*,*) "check a format", trim(fom)

  ctitle='wave-number frequency period '

  do i=1,na
     ctitle=trim(ctitle)//' val'
  end do

  fomc='(a'//trim(adjustl(i2c_convert( len_trim(ctitle) )))//')'

!-- output another file

  open(unit=11,file=trim(foname),status='unknown')

     write(11,trim(fomc)) trim(ctitle)
     write(11,trim(fomc)) trim(ctitle)

     write(11,trim(fom)) 0.0, 0.0, period, 0.0, 0.0, period, (sp(1,1,i),i=1,na)

     do j=2,nly/2
     do i=2,nlx
        write(11,trim(fom)) real(i-1), real(i-1)/period, period/real(i-1),  &
  &                         real(j-1), real(j-1)/period, period/real(j-1),  &
  &                         (sp(i,j,k),k=1,na)
     end do
     end do

  close(unit=11,status='keep')

end program
