program normal_poly
! 多項式, 特殊関数ルーチンのデモ
  use poly_function
  use special_function

  implicit none

  integer, parameter :: n=4, nmax=100
  integer i, j, num, m
  real :: xmin, xmax, dx, ymin, ymax
  real :: x(nmax), p(0:n,nmax)
  real :: y0(nmax), y1(nmax), y2(nmax), y3(nmax), y4(nmax)
  real :: alpha, beta, lambda
  character(10) :: title

! 対応する整数を代入すると, その関数が計算される.
  write(*,*) "input the calculate num."
  write(*,*) "1->Legendre."
  write(*,*) "2->Hermite."
  write(*,*) "3->Laguerre."
  write(*,*) "4->Jacobi."
  write(*,*) "5->Gegenbauer."
  write(*,*) "6->Chevishev"
  write(*,*) "7->Sonine"
  write(*,*) "8->Bessel"
  write(*,*) "9->Gamma"
  write(*,*) "10->Neumann"
  write(*,*) "11->df_Bess"
  write(*,*) "12->df_Neum"
  read(*,*) num

  select case (num)
  case(1)
     xmin=-1.0
     xmax=1.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     call legendre(n,x,p)
     title="LEGENDRE"

  case(2)
     xmin=-5.0
     xmax=5.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     call hermite(n,x,p)

     do j=0,n
        if(j.eq.0)then
           m=1
        else
           m=j*m
        end if
        do i=1,nmax
           p(j,i)=(exp(-0.5*(x(i)**2)))*p(j,i)/(sqrt(2.0**j*m))
        end do
     end do

     title="HERMITE"

  case(3)
     xmin=0.0
     xmax=20.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     call laguerre(n,x,p)

     do j=0,n
        if(j.eq.0)then
           m=1
        else
           m=j*m
        end if
        do i=1,nmax
           p(j,i)=(exp(-0.5*x(i))/m)*p(j,i)
        end do
     end do

     title="LAGUERRE"

  case(4)
     xmin=-1.0
     xmax=1.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     write(*,*) "input the alpha, beta."
     read(*,*) alpha, beta
     call jacobi_poly(n,x,p,alpha,beta)
     title="JACOBI"

  case(5)
     xmin=-1.0
     xmax=1.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     write(*,*) "input the lambda."
     read(*,*) lambda
     call gegenbauer(n,x,p,lambda)
     title="GEGENBAUER"

  case(6)
     xmin=-1.0
     xmax=1.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     call chebyshev(n,x,p)
     title="CHEBYSHEV"

  case(7)
     xmin=0.0
     xmax=20.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
     end do

     write(*,*) "input the alpha."
     read(*,*) alpha
     call sonine(n,x,p,alpha)

!     do j=0,n
!    if(j.eq.0)then
!       m=1
!    else
!       m=j*m
!    end if

     do j=0,n
        do i=1,nmax
           p(j,i)=(exp(-0.5*x(i)))*p(j,i)
        end do
     end do

     title="SONINE"

  case(8)
     xmin=0.0
     xmax=10.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
        p(0,i)=bessj(0,x(i))
        p(1,i)=bessj(1,x(i))
        p(2,i)=bessj(2,x(i))
        p(3,i)=bessj(3,x(i))
        p(4,i)=bessj(4,x(i))
     end do

     title="BESSEL"

  case(9)
     xmin=-0.5
     xmax=2.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
        p(0,i)=gamma_func(x(i))
        p(1,i)=0.0
        p(2,i)=0.0
        p(3,i)=0.0
        p(4,i)=0.0
     end do

     title="GAMMA"

  case(10)
     xmin=1.0
     xmax=10.5
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
        p(0,i)=bessy(0,x(i))
        p(1,i)=bessy(1,x(i))
        p(2,i)=bessy(2,x(i))
        p(3,i)=bessy(3,x(i))
        p(4,i)=bessy(4,x(i))
        do j=0,4
           if(p(j,i)<-1.0)then
              p(j,i)=999.0
           end if
        end do
     end do

     title="NEUMANN"

  case(11)
     xmin=0.25
     xmax=3.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
        p(0,i)=df_bessj(0,x(i))
        p(1,i)=df_bessj(1,x(i))
        p(2,i)=df_bessj(2,x(i))
        p(3,i)=df_bessj(3,x(i))
        p(4,i)=df_bessj(4,x(i))
     end do

     title="DFBESS"

  case(12)
     xmin=0.5
     xmax=3.0
     dx=(xmax-xmin)/(nmax-1)

     do i=1,nmax
        x(i)=xmin+dx*(i-1)
        p(0,i)=df_bessy(0,x(i))
        p(1,i)=df_bessy(1,x(i))
        p(2,i)=df_bessy(2,x(i))
        p(3,i)=df_bessy(3,x(i))
        p(4,i)=df_bessy(4,x(i))
        do j=0,4
           if(p(j,i)>10.0)then
              p(j,i)=999.0
           end if
        end do
     end do

     title="DFNEUM"
  end select

  do i=1,nmax
     y0(i)=p(0,i)
     y1(i)=p(1,i)
     y2(i)=p(2,i)
     y3(i)=p(3,i)
     y4(i)=p(4,i)
  end do

  select case (num)
  case(10)
     ymin=-1.0
     ymax=1.0
  case(11)
     ymin=0.0
     ymax=10.0
  case(12)
     ymin=0.0
     ymax=10.0
  end select

!-- text writing

  open(unit=10,file='normal_poly.dat',status='unknown')
  write(10,'(1000a)') "'x-axis', ", "'", trim(title), "',", "'", trim(title), "',","'", trim(title), "',","'", trim(title), "',","'", trim(title), "'"
  write(10,'(1000a)') "'', '', '', '', '', ''"
  do i=1,nmax
     write(10,'(f10.5,1a,f10.5,1a,f10.5,1a,f10.5,1a,f10.5,1a,f10.5)') x(i), ',', y0(i), ',', y1(i), ',', y2(i), ',', y3(i), ',', y4(i)
  end do
  close(unit=10,status='keep')

end program
