program adjust
! ϹĴǥǸڤץ
! 1 ǥ

  use file_operate
  use Derivation
  use Phys_Const
  use basis
  use gtool_history

  implicit none

! namelist values
  integer :: nt, dmpstep
  real :: height, corioli, dt
  character(100) :: fname, oname

  integer :: i, it, counter
  integer :: nx, dn, bound
  real :: cp, lambda, bound_phase
  real, allocatable, dimension(:) :: ini_x, ini_h, ini_u, ini_v, dx, time
  real, allocatable, dimension(:) :: old_h, old_u, old_v
  real, allocatable, dimension(:) :: mid_h, mid_u, mid_v
  real, allocatable, dimension(:) :: force_h, force_u, force_v
  real, allocatable, dimension(:) :: h, u, v
  real, allocatable, dimension(:) :: dhdx, dudx, dvdx
  real, allocatable, dimension(:) :: dh2dx, du2dx, dv2dx
  real, allocatable, dimension(:,:) :: dval_h, dval_u, dval_v
  real, allocatable, dimension(:,:) :: dval_pe, dval_ke, dval_ae
  character(10) :: x_axis, val_h, val_u, val_v

! reading namelist
  namelist /input /height, corioli, fname, oname, nt, nx, dt, dmpstep,  &
  &                x_axis, val_h, val_u, val_v, bound
  read(5,nml=input)

! calculate each parameter

  cp=sqrt(g*height)
  bound_phase=cp
  lambda=cp/corioli
  dn=nt/dmpstep+1

  write(*,*) "phase speed is ", cp, "m/s."
  write(*,*) "deformation radius is ", lambda, "m."

! allocate array
  allocate(ini_x(nx))
  allocate(ini_h(nx))
  allocate(ini_u(nx))
  allocate(ini_v(nx))
  allocate(old_h(nx))
  allocate(old_u(nx))
  allocate(old_v(nx))
  allocate(mid_h(nx))
  allocate(mid_u(nx))
  allocate(mid_v(nx))
  allocate(force_h(nx))
  allocate(force_u(nx))
  allocate(force_v(nx))
  allocate(dhdx(nx))
  allocate(dudx(nx))
  allocate(dvdx(nx))
  allocate(dh2dx(nx))
  allocate(du2dx(nx))
  allocate(dv2dx(nx))
  allocate(h(nx))
  allocate(u(nx))
  allocate(v(nx))
  allocate(dx(nx))
  allocate(dval_h(nx,dn))
  allocate(dval_u(nx,dn))
  allocate(dval_v(nx,dn))
  allocate(dval_pe(nx,dn))
  allocate(dval_ke(nx,dn))
  allocate(dval_ae(nx,dn))
  allocate(time(dn))

  time=(/((dt*dmpstep*real(i-1)),i=1,dn)/)

!-- reading initial data

  call HistoryGet( trim(fname), trim(x_axis), ini_x )
  call HistoryGet( trim(fname), trim(val_h), ini_h )
  call HistoryGet( trim(fname), trim(val_u), ini_u )
  call HistoryGet( trim(fname), trim(val_v), ini_v )

!-- opening history file

  call HistoryCreate( file=trim(oname), title='shallow result data',  &
  &                   source='test', institution='test', dims=(/'x', 't'/),  &
  &                   dimsizes=(/nx,dn/),  &
  &                   longnames=(/'x-coordinate', 'time        '/),  &
  &                   units=(/'m','s'/), origin=0.0, interval=0.0 )

  call HistoryPut( 'x', ini_x )
  call HistoryPut( 't', time )

  call HistoryAddVariable( varname='h', dims=(/'x','t'/),  &
  &                        longname='height', units='m', xtype='float' )
  call HistoryAddVariable( varname='u', dims=(/'x','t'/),  &
  &                        longname='zonal wind', units='m s-1', xtype='float' )
  call HistoryAddVariable( varname='v', dims=(/'x','t'/),  &
  &                        longname='meridional wind', units='m s-1',  &
  &                        xtype='float' )
  call HistoryAddVariable( varname='pe', dims=(/'x','t'/),  &
  &                        longname='potential energy', units='J kg-1',  &
  &                        xtype='float' )
  call HistoryAddVariable( varname='ke', dims=(/'x','t'/),  &
  &                        longname='kinetic energy', units='J kg-1',  &
  &                        xtype='float' )
  call HistoryAddVariable( varname='ae', dims=(/'x','t'/),  &
  &                        longname='all energy', units='J kg-1',  &
  &                        xtype='float' )

!-- define grid interval

  do i=2,nx-1
     dx(i)=(ini_x(i+1)-ini_x(i-1))*0.5
  end do
  dx(1)=ini_x(2)-ini_x(1)
  dx(nx)=ini_x(nx)-ini_x(nx-1)

  do i=1,nx
     old_h(i)=ini_h(i)
     old_u(i)=ini_u(i)
     old_v(i)=ini_v(i)
     dval_h(i,1)=ini_h(i)
     dval_u(i,1)=ini_u(i)
     dval_v(i,1)=ini_v(i)
     dval_pe(i,1)=0.5*g*ini_h(i)*ini_h(i)
     dval_ke(i,1)=0.5*(ini_v(i)*ini_v(i)+ini_u(i)*ini_u(i))
     dval_ae(i,1)=dval_pe(i,1)+dval_ke(i,1)
  end do

  counter=1

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  write(*,*) "starting time integration"

! time step start

  do it=1,nt

     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

  ! compute gradient

     call grad_1d( ini_x, old_h, dhdx )
     call grad_1d( ini_x, old_u, dudx )
     call grad_1d( ini_x, old_v, dvdx )
     call laplacian_1d( ini_x, old_h, dh2dx )
     call laplacian_1d( ini_x, old_u, du2dx )
     call laplacian_1d( ini_x, old_v, dv2dx )

  ! compute forcing term

     do i=2,nx-1
        force_h(i)=-height*dudx(i)+dh2dx(i)
        force_u(i)=-g*dhdx(i)+corioli*old_v(i)+du2dx(i)
        force_v(i)=-corioli*old_u(i)+dv2dx(i)
     end do

  ! time integration

     if(it==1)then
        do i=2,nx-1
           h(i)=old_h(i)+dt*force_h(i)
           u(i)=old_u(i)+dt*force_u(i)
           v(i)=old_v(i)+dt*force_v(i)
        end do
     else
        do i=2,nx-1
           h(i)=mid_h(i)+2.0*dt*force_h(i)
           u(i)=mid_u(i)+2.0*dt*force_u(i)
           v(i)=mid_v(i)+2.0*dt*force_v(i)
        end do
     end if

  ! boundary coditions

     select case (bound)
     case (1)
        h(1)=h(2)
        u(1)=u(2)
        v(1)=v(2)
        h(nx)=h(nx-1)
        u(nx)=u(nx-1)
        v(nx)=v(nx-1)
     case (2)
        if(it==1)then
           h(1)=old_h(1)+bound_phase*dt*(old_h(2)-old_h(1))/dx(1)
           v(1)=old_v(1)+bound_phase*dt*(old_v(2)-old_v(1))/dx(1)
           u(1)=old_u(1)+bound_phase*dt*(old_u(2)-old_u(1))/dx(1)
           h(nx)=old_h(nx)-bound_phase*dt*(old_h(nx)-old_h(nx-1))/dx(nx)
           v(nx)=old_v(nx)-bound_phase*dt*(old_v(nx)-old_v(nx-1))/dx(nx)
           u(nx)=old_u(nx)-bound_phase*dt*(old_u(nx)-old_u(nx-1))/dx(nx)
        else
           h(1)=mid_h(1)+2.0*bound_phase*dt*(mid_h(2)-mid_h(1))/dx(1)
           v(1)=mid_v(1)+2.0*bound_phase*dt*(mid_v(2)-mid_v(1))/dx(1)
           u(1)=mid_u(1)+2.0*bound_phase*dt*(mid_u(2)-mid_u(1))/dx(1)
           h(nx)=mid_h(nx)-2.0*bound_phase*dt*(mid_h(nx)-mid_h(nx-1))/dx(nx)
           v(nx)=mid_v(nx)-2.0*bound_phase*dt*(mid_v(nx)-mid_v(nx-1))/dx(nx)
           u(nx)=mid_u(nx)-2.0*bound_phase*dt*(mid_u(nx)-mid_u(nx-1))/dx(nx)
        end if
     case (3)
        h(1)=h(nx-1)
        u(1)=u(nx-1)
        v(1)=v(nx-1)
        h(nx)=h(2)
        u(nx)=u(2)
        v(nx)=v(2)
     end select

  ! replace new values to old values

     do i=1,nx
        mid_h(i)=old_h(i)
        mid_u(i)=old_u(i)
        mid_v(i)=old_v(i)
     end do

     do i=1,nx
        old_h(i)=h(i)
        old_u(i)=u(i)
        old_v(i)=v(i)
     end do

  ! output file

     if(mod((it),dmpstep)==0)then
        counter=counter+1
        do i=1,nx
           dval_h(i,counter)=h(i)
           dval_u(i,counter)=u(i)
           dval_v(i,counter)=v(i)
           dval_pe(i,counter)=0.5*g*h(i)*h(i)
           dval_ke(i,counter)=0.5*(u(i)*u(i)+v(i)*v(i))
           dval_ae(i,counter)=dval_pe(i,counter)+dval_ke(i,counter)
        end do
        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

     end if
  end do

  call HistoryPut( 'h', dval_h )
  call HistoryPut( 'u', dval_u )
  call HistoryPut( 'v', dval_v )
  call HistoryPut( 'pe', dval_pe )
  call HistoryPut( 'ke', dval_ke )
  call HistoryPut( 'ae', dval_ae )

end program
