module Alge_Solv   ! 黻Ѥʬ򤯥⥸塼

  public :: Poisson_GauSei
  public :: Poisson_Jacobi

contains
subroutine Poisson_GauSei(x, y, rho, eps, boundary, psi, bound_opt,  &
  &                       a, b, c, d, e)
! =ǥˡˤݥε
! ƥץ, ݥϤγʬ. ǥեȤϥꤵ.
! $$a\dfrac{\partial ^2\psi}{\partial x^2} +b\dfrac{\partial ^2\psi}{\partial x\partial y} +c\dfrac{\partial ^2\psi}{\partial y^2} +d\dfrac{\partial \psi}{\partial x} +e\dfrac{\partial \psi}{\partial y} =\rho $$
! γƷбƤ.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
                             ! Υޥ󶭳ξ : եå
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ
  integer :: i, j
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb, signd, signe  ! Ʒ׻뤫ɤ
  real :: tmp, err, err_max
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac
  character(4) :: bound
  real :: tmp_b, tmp_adm, tmp_adp, tmp_cem, tmp_cep

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

  psi = 0.0

!-- ǧ.
!-- ʤΤ, ξüȤ 3 ꤵƤʤȤʤ.
  if(bound(1:1)=='3')then
     if(bound(3:3)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(3:3)=='3')then
     if(bound(1:1)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(2:2)=='3')then
     if(bound(4:4)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(4:4)=='3')then
     if(bound(2:2)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .
  if(present(a))then
     do j=1,ny
        do i=1,nx
           at(i,j)=a(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           at(i,j)=1.0
        end do
     end do
  end if

  if(present(c))then
     do j=1,ny
        do i=1,nx
           ct(i,j)=c(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           ct(i,j)=1.0
        end do
     end do
  end if

  if(present(b))then
     do j=1,ny
        do i=1,nx
           bt(i,j)=b(i,j)
        end do
     end do
     signb=1
  else
     signb=0
  end if

  if(present(d))then
     do j=1,ny
        do i=1,nx
           dt(i,j)=d(i,j)
        end do
     end do
     signd=1
  else
     signd=0
  end if

  if(present(e))then
     do j=1,ny
        do i=1,nx
           et(i,j)=e(i,j)
        end do
     end do
     signe=1
  else
     signe=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻

  if(signd==0)then  ! ղù d ĤƤʤȤ
     do j=2,ny-1
        do i=2,nx-1
           adp(i,j)=at(i,j)/(dx2(i))
           adm(i,j)=at(i,j)/(dx2(i))
        end do
     end do
  else
     do j=2,ny-1
        do i=2,nx-1
           adp(i,j)=at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i)
           adm(i,j)=at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i)
        end do
     end do
  end if

  if(signe==0)then  ! ղù e ĤƤʤȤ
     do j=2,ny-1
        do i=2,nx-1
           cep(i,j)=ct(i,j)/(dy2(j))
           cem(i,j)=ct(i,j)/(dy2(j))
        end do
     end do
  else
     do j=2,ny-1
        do i=2,nx-1
           cep(i,j)=ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j)
           cem(i,j)=ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j)
        end do
     end do
  end if

!-- ǹ⼡ ac η׻ (ˤäɾѤ.)
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.
  do j=2,ny-1  !  ac ˤĤƤ, ¦ǶˤäƼۤʤ.
     do i=2,nx-1  ! Ǥ, üǤͤƤ, ʳξϰʲνǾ񤭤.
        ac(i,j)=2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))
     end do
  end do

!-- ʲ, ¦Ǥη ac η׻
!-- ܷ׻Ǥ, 궭ʤ, ΰϤ٤ƤͤǸꤹ褦ˤƤ,
!-- 궭ͤȿ׻ͿͤѤΤ,  1 ǤɾѤʤ.
!-- ޤ, Ǥ, ξüǤʤФʤʤ, bound Ȥ߹碌
!-- ¤.
!-- ºݤ˷ѤΤ,  2 ΤȤǤΤ, 2 ˤĤɾ׻.
!-- (3 ϷǤϤʤ, ݥμѲ.)
!-- ʲǤ,  4 ¦׻Ƥ.
!--  2 ŴꤵΤ, ξ¦Ȥ⤬ 2 ξΤȤʤΤ,
!-- ˡѤʬʤƺѤ.
!-- 2 ŴꤷȤ, Ⱦʬ.

  if(bound(1:1)=='2')then  ! x üΥޥ : psi(i,1)=psi(i,2)-f(i,1)*dy(1)
     do i=2,nx-1
        ac(i,2)=ac(i,2)-cem(i,2)
     end do
  end if

  if(bound(2:2)=='2')then  ! y üΥޥ : psi(1,j)=psi(2,j)-f(1,j)*dx(1)
     do j=2,ny-1
        ac(2,j)=ac(2,j)-adm(2,j)
     end do
  end if

  if(bound(3:3)=='2')then  ! x üΥޥ : psi(i,ny)=psi(i,ny-1)+f(i,ny)*dy(ny)
     do i=2,nx-1
        ac(i,ny-1)=ac(i,ny-1)-cep(i,ny-1)
     end do
  end if

  if(bound(4:4)=='2')then  ! y üΥޥ : psi(nx,j)=psi(nx-1,j)+f(nx,j)*dx(nx)
     do j=2,ny-1
        ac(nx-1,j)=ac(nx-1,j)-adp(nx-1,j)
     end do
  end if

!-- ¦ 4 Ǥ 2 Ŵβ  bt ˤĤƤϤǤΤ߷׻Τ, ­碌Ƥ.

  if(bound(1:2)=='22')then  ! β
     ac(2,2)=ac(2,2)+(cem(2,2)+adm(2,2))*0.5-0.25*bt(2,2)/dxdy(2,2)
  end if

  if(bound(2:3)=='22')then  ! β
     ac(2,ny-1)=ac(2,ny-1)+(cep(2,ny-1)+adm(2,ny-1))*0.5+0.25*bt(2,ny-1)/dxdy(2,ny-1)
  end if

  if(bound(3:4)=='22')then  ! β
     ac(nx-1,ny-1)=ac(nx-1,ny-1)+(cep(nx-1,ny-1)+adp(nx-1,ny-1))*0.5  &
  &                -0.25*bt(nx-1,ny-1)/dxdy(nx-1,ny-1)
  end if

  if(bound(1:1)=='2'.and.bound(4:4)=='2')then  ! β
     ac(nx-1,2)=ac(nx-1,2)+(cem(nx-1,2)+adp(nx-1,2))*0.5+0.25*bt(nx-1,2)/dxdy(nx-1,2)
  end if

!-- ͤ
  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

!-- γǧ (+ 궭ʤ, ͤ.)
  if(bound(1:1)=='1')then
     do i=1,nx
        psi(i,1)=bnd(i,1)
     end do
  end if

  if(bound(2:2)=='1')then
     do j=1,ny
        psi(1,j)=bnd(1,j)
     end do
  end if

  if(bound(3:3)=='1')then
     do i=1,nx
        psi(i,ny)=bnd(i,ny)
     end do
  end if

  if(bound(4:4)=='1')then
     do j=1,ny
        psi(1,j)=bnd(1,j)
     end do
  end if

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1

        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &            +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)  &
  &            -rho(i,j)

           if(signb==1)then
              tmp=tmp+0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &               -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
           end if

           tmp=tmp/ac(i,j)

        else

!-- ʲǶ¦׻
!-- ɤ򸫤䤹뤿, adm, adp, cem, cep ιऴȤ case ʬ.

           if(i==2)then  ! Ǥΰ. Ǥ, adm ʳι϶̷׻Ǥ.
              if(j/=2.or.j/=ny-1)then  ! ʳ
                 tmp=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                  +cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(2:2))  ! y ü
                 case ('1')
                    tmp_adm=adm(i,j)*psi(i-1,j)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                    tmp_adm=-adm(i,j)*bnd(i-1,j)*dx(i-1)
            
                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                          +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                          -psi(i+1,j-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('3')  ! u(1,j)=u(nx-1,j)
                    tmp_adm=adm(i,j)*psi(nx-1,j)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 end select

                 tmp=(tmp+tmp_adm+tmp_b)/ac(i,j)

              else

                 if(j==2)then  !   ! adp, cep ϶˰¸ʤ.
                    tmp=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                     -rho(i,j)

                    select case (bound(1:1))  ! x ü -> cem η׻
                    case ('1')
                       tmp_cem=cem(i,j)*psi(i,j-1)

                    case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                       tmp_cem=-cem(i,j)*bnd(i,j-1)*dy(j-1)

                    case ('3')  ! u(i,1)=u(i,ny-1)
                       tmp_cem=cem(i,j)*psi(i,ny-1)

                    end select

                    select case (bound(2:2))
                    case ('1')
                       tmp_adm=adm(i,j)*psi(i-1,j)

                    case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                       tmp_adm=-adm(i,j)*bnd(i-1,j)*dx(i-1)

                    case ('3')  ! u(1,j)=u(nx-1,j)
                       tmp_adm=adm(i,j)*psi(nx-1,j)

                    end select

                    if(signb==1)then
                       select case (bound(1:2))
                       case ('11')  ! ξ궭
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ
                          ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1), j-1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('13')  ! x  y   u(1,j)=u(nx-1,j)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(i-1,j-1)=u(i,j)-0.5*(f(i-1,j)*dx(i-1)+f(i,j-1)*dy(j-1))
                          ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             -0.5*(bnd(i-1,j)*dx(i-1)+bnd(i,j-1)*dy(j-1))  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1) &
  &                             -psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          ! u(1,1)=u(nx-1,1)=u(nx-1,2)-f(nx-1,1)*dy(1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(nx-1,2)-bnd(nx-1,1)*dy(1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,j-1)=u(i,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,ny-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(1,1)=u(1,ny-1)=u(2,ny-1)-f(1,ny-1)*dx(1)
                          ! u(i,j-1)=u(i,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,ny-1)-bnd(i-1,ny-1)*dx(i-1)  &
  &                             -psi(i+1,ny-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('33')  ! x, y   u(1,1)=u(nx-1,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,ny-1)  &
  &                             -psi(i+1,ny-1)-psi(nx-1,j+1))/dxdy(i,j)

                       end select
                    else
                       tmp_b=0.0
                    end if

                    tmp=(tmp+tmp_adm+tmp_cem+tmp_b)/ac(i,j)

                 else  !   adp, cem ϶˴طʤ.

                    tmp=adp(i,j)*psi(i+1,j)+cem(i,j)*psi(i,j-1)  &
  &                     -rho(i,j)

                    select case (bound(3:3))  ! x ü -> cep η׻
                    case ('1')
                       tmp_cep=cep(i,j)*psi(i,j+1)

                    case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                       tmp_cep=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    case ('3')  ! u(i,ny)=u(i,2)
                       tmp_cep=cep(i,j)*psi(i,2)

                    end select

                    select case (bound(2:2))
                    case ('1')
                       tmp_adm=adm(i,j)*psi(i-1,j)

                    case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                       tmp_adm=-adm(i,j)*bnd(i-1,j)*dx(i-1)

                    case ('3')  ! u(1,j)=u(nx-1,j)
                       tmp_adm=adm(i,j)*psi(nx-1,j)

                    end select

                    if(signb==1)then
                       select case (bound(2:3))
                       case ('11')  ! ξ궭
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x Υޥ y 
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1), i-1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(i,ny)=u(i,2), i-1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,2)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! j+1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(i-1,j+1)=u(i,j)+0.5*(-f(i-1,j+1)*dx(i-1)+f(i-1,j+1)*dy(j+1))
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)  &
  &                             +0.5*(bnd(i-1,j+1)*dx(i-1)-bnd(i-1,j+1)*dy(j+1)))/dxdy(i,j)
                       case ('23')  ! x  y Υޥ  u(i,ny)=u(i,2)
                          ! u(1,ny)=u(1,2)=u(2,2)-f(1,2)*dx(1)
                          ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,2)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)-psi(2,2)+bnd(1,2)*dx(1))/dxdy(i,j)
                       case ('31')  ! x  y   u(1,j)=u(nx-1,j),  j+1 ϸ궯
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x Υޥ y   u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          ! u(1,ny)=u(nx-1,ny)=u(nx-1,ny-1)+f(nx-1,ny)*dy(ny)
                          ! u(1,j)=u(nx-1,j)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(nx-1,j-1)-psi(i+1,j-1)  &
  &                             -psi(nx-1,ny-1)-bnd(nx-1,ny)*dy(ny))/dxdy(i,j)
                       case ('33')  ! x, y   u(1,ny)=u(nx-1,2)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,2)+psi(nx-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,2))/dxdy(i,j)

                       end select
                    else
                       tmp_b=0.0
                    end if

                    tmp=(tmp+tmp_adm+tmp_cep+tmp_b)/ac(i,j)


                 end if

              end if

           end if

           if(i==nx-1)then  ! Ǥΰ. Ǥ, adp ʳι϶̷׻ǽ.
              if(j/=2.or.j/=ny-1)then  ! ʳ
                 tmp=cep(i,j)*psi(i,j+1)  &
  &                  +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(4:4))  ! y ü
                 case ('1')
                    tmp_adp=adp(i,j)*psi(i+1,j)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                    tmp_adp=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                          +psi(i-1,j-1)-psi(i,j-1)-bnd(i+1,j-1)*dx(i+1)  &
  &                          -psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('3')  ! u(nx,j)=u(2,j)
                    tmp_adp=adp(i,j)*psi(2,j)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,j-1)  &
  &                          -psi(2,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 end select

                 tmp=(tmp+tmp_adp+tmp_b)/ac(i,j)

              else

                 if(j==2)then  !   adm, cep ϶˴طʤ.

                    tmp=adm(i,j)*psi(i-1,j)+cep(i,j)*psi(i,j+1)  &
  &                     -rho(i,j)

                    select case (bound(1:1))  ! x ü -> cem η׻
                    case ('1')
                       tmp_cem=cem(i,j)*psi(i,j-1)

                    case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                       tmp_cem=-cem(i,j)*bnd(i,j-1)*dy(j-1)

                    case ('3')  ! u(i,1)=u(i,ny-1)
                       tmp_cem=cem(i,j)*psi(i,ny-1)

                    end select

                    select case (bound(4:4))
                    case ('1')
                       tmp_adp=adp(i,j)*psi(i-1,j)

                    case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                       tmp_adp=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    case ('3')  ! u(nx,j)=u(2,j)
                       tmp_adp=adp(i,j)*psi(2,j)

                    end select

                    if(signb==1)then
                       select case (bound(1:1)//bound(4:4))
                       case ('11')  ! ξ궭
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ
                          ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1), j-1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                             +psi(i-1,j-1)-psi(i+1,j-1)-psi(i,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(nx,j)=u(2,j)
                          tmp_b=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! u(i+1,j-1)=u(i,j)+0.5*(f(i+1,j)*dx(i+1)-f(i,j-1)*dy(j-1))
                          ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                             -psi(i-1,j)+bnd(i-1,j-1)*dy(j-1) &
  &                             -0.5*(bnd(i+1,j)*dx(i+1)-bnd(i,j-1)*dy(j-1))  &
  &                             -psi(i-1,j+1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          ! u(nx,1)=u(2,1)=u(2,2)-f(2,1)*dy(1)
                          tmp_b=0.25*bt(i,j)*(psi(2,j+1)  &
  &                             +psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)  &
  &                             -psi(2,2)+bnd(2,1)*dy(1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,j-1)=u(i,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,ny-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(1,1)=u(1,ny-1)=u(2,ny-1)-f(1,ny-1)*dx(1)
                          ! u(i,j-1)=u(i,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,ny-1)-bnd(i-1,ny-1)*dx(i-1)  &
  &                             -psi(i+1,ny-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('33')  ! x, y   u(nx,1)=u(2,ny-1)
                          tmp_b=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,ny-1)  &
  &                             -psi(2,ny-1)-psi(i-1,j+1))/dxdy(i,j)

                      end select
                    else
                       tmp_b=0.0
                    end if

                    tmp=(tmp+tmp_adp+tmp_cem+tmp_b)/ac(i,j)

                 else  !   adm, cem ϶˴طʤ.

                    tmp=adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)  &
  &                     -rho(i,j)

                    select case (bound(3:3))  ! x ü -> cep η׻
                    case ('1')
                       tmp_cep=cep(i,j)*psi(i,j+1)

                    case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                       tmp_cep=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    case ('3')  ! u(i,ny)=u(i,2)
                       tmp_cep=cep(i,j)*psi(i,2)

                    end select

                    select case (bound(4:4))
                    case ('1')
                       tmp_adp=adp(i,j)*psi(i-1,j)

                    case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                       tmp_adp=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    case ('3')  ! u(nx,j)=u(2,j)
                       tmp_adp=adp(i,j)*psi(2,j)

                    end select

                    if(signb==1)then
                       select case (bound(3:4))
                       case ('11')  ! ξ궭
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! j+1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)-bnd(i+1,j-1)*dx(i+1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(nx,j)=u(2,j),  j+1 ϸ궯
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(2,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y 
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1), i+1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! u(i+1,j+1)=u(i,j)+0.5*(f(i+1,j)*dx(i+1)+f(i,j+1)*dy(j+1))
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          tmp_b=0.25*bt(i,j)*(0.5*(bnd(i+1,j)*dx(i+1)  &
  &                             +bnd(i,j+1)*dy(j+1))+psi(i-1,j-1)  &
  &                             -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1)  &
  &                             -psi(i,j-1)-bnd(i+1,j-1)*dx(i+1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          ! u(nx,ny)=u(2,ny)=u(2,ny-1)+f(2,ny)*dy(ny)
                          ! u(nx,j)=u(2,j)
                          tmp_b=0.25*bt(i,j)*(psi(2,ny-1)+bnd(2,ny)*dy(ny)  &
  &                             +psi(i-1,j-1)-psi(2,j-1)  &
  &                             -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,ny)=u(i,2), i+1 ϸ궯.
                          tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,2))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i,ny)=u(i,2)
                          ! u(nx,ny)=u(nx,2)=u(nx-1,2)+f(nx,2)*dx(nx)
                          ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          tmp_b=0.25*bt(i,j)*(psi(nx-1,2)+bnd(nx,2)*dx(nx)  &
  &                             +psi(i-1,j-1)-psi(i,j-1)-bnd(i+1,j-1)*dx(i+1)  &
  &                             -psi(i-1,2))/dxdy(i,j)
                       case ('33')  ! x, y   u(nx,ny)=u(2,2)
                          tmp_b=0.25*bt(i,j)*(psi(2,2)+psi(i-1,j-1)  &
  &                             -psi(2,j-1)-psi(i-1,2))/dxdy(i,j)

                       end select
                    else
                       tmp_b=0.0
                    end if

                    tmp=(tmp+tmp_adp+tmp_cep+tmp_b)/ac(i,j)


                 end if

              end if
           end if

           if(j==2)then  ! Ǥΰ. Ǥ, cem ʳι϶̷׻Ǥ.
              if(i/=2.or.i/=nx-1)then  ! ʳ
                 tmp=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                  +adm(i,j)*psi(i-1,j)-rho(i,j)

                 select case (bound(1:1))  ! x ü
                 case ('1')
                    tmp_cem=cem(i,j)*psi(i,j-1)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                    tmp_cem=-cem(i,j)*bnd(i,j-1)*dy(j-1)
            
                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                          +psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)  &
  &                          -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('3')  ! u(i,1)=u(i,ny-1)
                    tmp_cem=cem(i,j)*psi(i,ny-1)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,ny-1)  &
  &                          -psi(i+1,ny-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 end select

                 tmp=(tmp+tmp_cem+tmp_b)/ac(i,j)

              end if
           end if

           if(j==ny-1)then  ! 嶭Ǥΰ. Ǥ, cep ʳι϶̷׻ǽ.
              if(i/=2.or.i/=nx-1)then  ! ʳ
                 tmp=adp(i,j)*psi(i+1,j)  &
  &                  +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(3:3))  ! x ü
                 case ('1')
                    tmp_cep=cep(i,j)*psi(i,j+1)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                    tmp_cep=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                          +psi(i-1,j-i)-psi(i+1,j-1)  &
  &                          -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 case ('3')  ! u(i,ny)=u(i,2)
                    tmp_cep=cep(i,j)*psi(i,2)

                    if(signb==1)then
                       tmp_b=0.25*bt(i,j)*(psi(i+1,2)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,2))/dxdy(i,j)
                    else
                       tmp_b=0.0
                    end if

                 end select

                 tmp=(tmp+tmp_cep+tmp_b)/ac(i,j)

              end if

           end if
        end if
!!-- ޤǤ if ʸΥǥȤĴᤷʤ.
!        end if
!
!        tmp=tmp/ac(i,j)
!-- η׻ ---
!        if(psi(i,j)==0.0)then
!           if(tmp==0.0)then
!              err=0.0
!           else
!              err=abs(tmp-psi(i,j))/abs(tmp)
!           end if
!        else
!           if(abs(psi(i,j))<1.0.and.abs(tmp)<1.0)then
!              err=abs(tmp-psi(i,j))
!           else
!              err=abs(tmp-psi(i,j))/abs(psi(i,j))
!           end if
!        end if
        err=abs(tmp-psi(i,j))

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
!-- 
!-- x ü
  select case (bound(1:1))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do i=2,nx-1
        psi(i,1)=psi(i,2)-bnd(i,1)*dy(1)
     end do

  case ('3')
     do i=2,nx-1
        psi(i,1)=psi(i,ny-1)
     end do
  end select

!-- y ü
  select case (bound(2:2))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do j=2,ny-1
        psi(1,j)=psi(2,j)-bnd(1,j)*dx(1)
     end do

  case ('3')
     do j=2,ny-1
        psi(1,j)=psi(nx-1,j)
     end do
  end select

!-- x ü
  select case (bound(3:3))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do i=2,nx-1
        psi(i,ny)=psi(i,ny-1)+bnd(i,ny)*dy(ny)
     end do

  case ('3')
     do i=2,nx-1
        psi(i,ny)=psi(i,2)
     end do
  end select

!-- y ü
  select case (bound(4:4))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do j=2,ny-1
        psi(nx,j)=psi(nx-1,j)+bnd(nx,j)*dx(nx)
     end do

  case ('3')
     do j=2,ny-1
        psi(nx,j)=psi(2,j)
     end do
  end select

!-- 4 ü  ! ʲ, 궭ɤ餫ˤʤ, ͤ˶ ('11', '12,', '13', '21', '31')
!-- ޤ, bound(1:2) ͤʬ, bound(3:4) ͤդ˷ޤ.
!-- üΤ߼ʤ, ͤ򹹿, ΤȤ˥եåή֤ˤ.
  select case (bound(1:2))
  case ('23')  ! ξ y ξüǼʤΤ, (1,1), (nx,1) ͤǷޤ.
     psi(1,1)=psi(nx-1,2)-bnd(nx-1,1)*dy(1)
     psi(nx,1)=psi(2,2)-bnd(2,1)*dy(1)

     if(bound(3:3)=='2')then  ! x ü 1 ʤ餹Ǥ˶ƤΤ, ⤷ʤ.
        psi(1,ny)=psi(nx-1,ny-1)+bnd(nx-1,ny)*dy(ny)
        psi(nx,ny)=psi(2,ny-1)+bnd(2,ny)*dy(ny)
     end if

  case ('32')  ! ξ x ξüǼʤΤ, (1,1), (1,ny) ͤǷޤ.
     psi(1,1)=psi(2,ny-1)-bnd(1,ny-1)*dx(1)
     psi(1,ny)=psi(2,2)-bnd(1,2)*dx(1)

     if(bound(4:4)=='2')then  ! y ü 1 ʤ餹Ǥ˶ƤΤ, ⤷ʤ.
        psi(nx,1)=psi(nx-1,ny-1)+bnd(nx,ny-1)*dx(nx)
        psi(nx,ny)=psi(nx-1,2)+bnd(nx,2)*dx(nx)
     end if

  case ('33')  ! ξΰ
     psi(1,1)=psi(nx-1,ny-1)
     psi(nx,1)=psi(2,ny-1)
     psi(1,ny)=psi(nx-1,2)
     psi(nx,ny)=psi(2,2)

  case default  ! Ȥ, ɤζˤƤ, '22' Ǥʤ, 궯.
     if(bound(1:2)=='22')then
        psi(1,1)=psi(2,2)-0.5*(bnd(1,2)*dy(1)+bnd(2,1)*dx(1))
     end if

     if(bound(2:3)=='22')then
        psi(1,ny)=psi(2,ny-1)+0.5*(bnd(1,ny-1)*dy(ny)-bnd(2,ny)*dx(1))
     end if

     if(bound(3:4)=='22')then
        psi(nx,ny)=psi(nx-1,ny-1)+0.5*(bnd(nx,ny-1)*dy(ny)+bnd(nx-1,ny)*dx(nx))
     end if

     if(bound(1:1)=='2'.and.bound(4:4)=='2')then
        psi(nx,1)=psi(nx-1,2)+0.5*(-bnd(nx,2)*dy(1)+bnd(nx-1,1)*dx(nx))
     end if

  end select
  end do
  

end subroutine Poisson_GauSei


subroutine Poisson_Jacobi(x, y, rho, eps, boundary, psi, bound_opt,  &
  &                       a, b, c, d, e)
  ! 䥳ˡˤݥεѡʳȯopenmp
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ
  integer :: i, j
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb, signd, signe  ! Ʒ׻뤫ɤ
  real :: err, err_max
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac
  character(4) :: bound
  real, dimension(size(x),size(y)) :: tmp, tmp_b, tmp_adm, tmp_adp, tmp_cem, tmp_cep

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

  psi = 0.0

!-- ǧ.
!-- ʤΤ, ξüȤ 3 ꤵƤʤȤʤ.
  if(bound(1:1)=='3')then
     if(bound(3:3)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(3:3)=='3')then
     if(bound(1:1)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(2:2)=='3')then
     if(bound(4:4)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(4:4)=='3')then
     if(bound(2:2)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .
  if(present(a))then
     do j=1,ny
        do i=1,nx
           at(i,j)=a(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           at(i,j)=1.0
        end do
     end do
  end if

  if(present(c))then
     do j=1,ny
        do i=1,nx
           ct(i,j)=c(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           ct(i,j)=1.0
        end do
     end do
  end if

  if(present(b))then
     do j=1,ny
        do i=1,nx
           bt(i,j)=b(i,j)
        end do
     end do
     signb=1
  else
     signb=0
  end if

  if(present(d))then
     do j=1,ny
        do i=1,nx
           dt(i,j)=d(i,j)
        end do
     end do
     signd=1
  else
     signd=0
  end if

  if(present(e))then
     do j=1,ny
        do i=1,nx
           et(i,j)=e(i,j)
        end do
     end do
     signe=1
  else
     signe=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻

  if(signd==0)then  ! ղù d ĤƤʤȤ
     do j=2,ny-1
        do i=2,nx-1
           adp(i,j)=at(i,j)/(dx2(i))
           adm(i,j)=at(i,j)/(dx2(i))
        end do
     end do
  else
     do j=2,ny-1
        do i=2,nx-1
           adp(i,j)=at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i)
           adm(i,j)=at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i)
        end do
     end do
  end if

  if(signe==0)then  ! ղù e ĤƤʤȤ
     do j=2,ny-1
        do i=2,nx-1
           cep(i,j)=ct(i,j)/(dy2(j))
           cem(i,j)=ct(i,j)/(dy2(j))
        end do
     end do
  else
     do j=2,ny-1
        do i=2,nx-1
           cep(i,j)=ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j)
           cem(i,j)=ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j)
        end do
     end do
  end if

!-- ǹ⼡ ac η׻ (ˤäɾѤ.)
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.
  do j=2,ny-1  !  ac ˤĤƤ, ¦ǶˤäƼۤʤ.
     do i=2,nx-1  ! Ǥ, üǤͤƤ, ʳξϰʲνǾ񤭤.
        ac(i,j)=2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))
     end do
  end do

!-- ʲ, ¦Ǥη ac η׻
!-- ܷ׻Ǥ, 궭ʤ, ΰϤ٤ƤͤǸꤹ褦ˤƤ,
!-- 궭ͤȿ׻ͿͤѤΤ,  1 ǤɾѤʤ.
!-- ޤ, Ǥ, ξüǤʤФʤʤ, bound Ȥ߹碌
!-- ¤.
!-- ºݤ˷ѤΤ,  2 ΤȤǤΤ, 2 ˤĤɾ׻.
!-- (3 ϷǤϤʤ, ݥμѲ.)
!-- ʲǤ,  4 ¦׻Ƥ.
!--  2 ŴꤵΤ, ξ¦Ȥ⤬ 2 ξΤȤʤΤ,
!-- ˡѤʬʤƺѤ.
!-- 2 ŴꤷȤ, Ⱦʬ.

  if(bound(1:1)=='2')then  ! x üΥޥ : psi(i,1)=psi(i,2)-f(i,1)*dy(1)
     do i=2,nx-1
        ac(i,2)=ac(i,2)-cem(i,2)
     end do
  end if

  if(bound(2:2)=='2')then  ! y üΥޥ : psi(1,j)=psi(2,j)-f(1,j)*dx(1)
     do j=2,ny-1
        ac(2,j)=ac(2,j)-adm(2,j)
     end do
  end if

  if(bound(3:3)=='2')then  ! x üΥޥ : psi(i,ny)=psi(i,ny-1)+f(i,ny)*dy(ny)
     do i=2,nx-1
        ac(i,ny-1)=ac(i,ny-1)-cep(i,ny-1)
     end do
  end if

  if(bound(4:4)=='2')then  ! y üΥޥ : psi(nx,j)=psi(nx-1,j)+f(nx,j)*dx(nx)
     do j=2,ny-1
        ac(nx-1,j)=ac(nx-1,j)-adp(nx-1,j)
     end do
  end if

!-- ¦ 4 Ǥ 2 Ŵβ  bt ˤĤƤϤǤΤ߷׻Τ, ­碌Ƥ.

  if(bound(1:2)=='22')then  ! β
     ac(2,2)=ac(2,2)+(cem(2,2)+adm(2,2))*0.5-0.25*bt(2,2)/dxdy(2,2)
  end if

  if(bound(2:3)=='22')then  ! β
     ac(2,ny-1)=ac(2,ny-1)+(cep(2,ny-1)+adm(2,ny-1))*0.5+0.25*bt(2,ny-1)/dxdy(2,ny-1)
  end if

  if(bound(3:4)=='22')then  ! β
     ac(nx-1,ny-1)=ac(nx-1,ny-1)+(cep(nx-1,ny-1)+adp(nx-1,ny-1))*0.5  &
  &                -0.25*bt(nx-1,ny-1)/dxdy(nx-1,ny-1)
  end if

  if(bound(1:1)=='2'.and.bound(4:4)=='2')then  ! β
     ac(nx-1,2)=ac(nx-1,2)+(cem(nx-1,2)+adp(nx-1,2))*0.5+0.25*bt(nx-1,2)/dxdy(nx-1,2)
  end if

!-- ͤ
  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

!-- γǧ (+ 궭ʤ, ͤ.)
  if(bound(1:1)=='1')then
     do i=1,nx
        psi(i,1)=bnd(i,1)
     end do
  end if

  if(bound(2:2)=='1')then
     do j=1,ny
        psi(1,j)=bnd(1,j)
     end do
  end if

  if(bound(3:3)=='1')then
     do i=1,nx
        psi(i,ny)=bnd(i,ny)
     end do
  end if

  if(bound(4:4)=='1')then
     do j=1,ny
        psi(1,j)=bnd(1,j)
     end do
  end if

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel default(shared)
!$omp do private(i,j)
  do j=2,ny-1
     do i=2,nx-1

        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp(i,j)=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &            +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)  &
  &            -rho(i,j)

           if(signb==1)then
              tmp(i,j)=tmp(i,j)+0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &               -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
           end if

           tmp(i,j)=tmp(i,j)/ac(i,j)

        else

!-- ʲǶ¦׻
!-- ɤ򸫤䤹뤿, adm, adp, cem, cep ιऴȤ case ʬ.

           if(i==2)then  ! Ǥΰ. Ǥ, adm ʳι϶̷׻Ǥ.
              if(j/=2.or.j/=ny-1)then  ! ʳ
                 tmp(i,j)=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                  +cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(2:2))  ! y ü
                 case ('1')
                    tmp_adm(i,j)=adm(i,j)*psi(i-1,j)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                               -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                    tmp_adm(i,j)=-adm(i,j)*bnd(i-1,j)*dx(i-1)
            
                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                          +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                          -psi(i+1,j-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('3')  ! u(1,j)=u(nx-1,j)
                    tmp_adm(i,j)=adm(i,j)*psi(nx-1,j)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 end select

                 tmp(i,j)=(tmp(i,j)+tmp_adm(i,j)+tmp_b(i,j))/ac(i,j)

              else

                 if(j==2)then  !   ! adp, cep ϶˰¸ʤ.
                    tmp(i,j)=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                     -rho(i,j)

                    select case (bound(1:1))  ! x ü -> cem η׻
                    case ('1')
                       tmp_cem(i,j)=cem(i,j)*psi(i,j-1)

                    case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                       tmp_cem(i,j)=-cem(i,j)*bnd(i,j-1)*dy(j-1)

                    case ('3')  ! u(i,1)=u(i,ny-1)
                       tmp_cem(i,j)=cem(i,j)*psi(i,ny-1)

                    end select

                    select case (bound(2:2))
                    case ('1')
                       tmp_adm(i,j)=adm(i,j)*psi(i-1,j)

                    case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                       tmp_adm(i,j)=-adm(i,j)*bnd(i-1,j)*dx(i-1)

                    case ('3')  ! u(1,j)=u(nx-1,j)
                       tmp_adm(i,j)=adm(i,j)*psi(nx-1,j)

                    end select

                    if(signb==1)then
                       select case (bound(1:2))
                       case ('11')  ! ξ궭
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ
                          ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1), j-1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('13')  ! x  y   u(1,j)=u(nx-1,j)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(i-1,j-1)=u(i,j)-0.5*(f(i-1,j)*dx(i-1)+f(i,j-1)*dy(j-1))
                          ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             -0.5*(bnd(i-1,j)*dx(i-1)+bnd(i,j-1)*dy(j-1))  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1) &
  &                             -psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          ! u(1,1)=u(nx-1,1)=u(nx-1,2)-f(nx-1,1)*dy(1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(nx-1,2)-bnd(nx-1,1)*dy(1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,j-1)=u(i,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,ny-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(1,1)=u(1,ny-1)=u(2,ny-1)-f(1,ny-1)*dx(1)
                          ! u(i,j-1)=u(i,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,ny-1)-bnd(i-1,ny-1)*dx(i-1)  &
  &                             -psi(i+1,ny-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('33')  ! x, y   u(1,1)=u(nx-1,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,ny-1)  &
  &                             -psi(i+1,ny-1)-psi(nx-1,j+1))/dxdy(i,j)

                       end select
                    else
                       tmp_b(i,j)=0.0
                    end if

                    tmp(i,j)=(tmp(i,j)+tmp_adm(i,j)+tmp_cem(i,j)+tmp_b(i,j))/ac(i,j)

                 else  !   adp, cem ϶˴طʤ.

                    tmp(i,j)=adp(i,j)*psi(i+1,j)+cem(i,j)*psi(i,j-1)  &
  &                     -rho(i,j)

                    select case (bound(3:3))  ! x ü -> cep η׻
                    case ('1')
                       tmp_cep(i,j)=cep(i,j)*psi(i,j+1)

                    case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                       tmp_cep(i,j)=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    case ('3')  ! u(i,ny)=u(i,2)
                       tmp_cep(i,j)=cep(i,j)*psi(i,2)

                    end select

                    select case (bound(2:2))
                    case ('1')
                       tmp_adm(i,j)=adm(i,j)*psi(i-1,j)

                    case ('2')  ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                       tmp_adm(i,j)=-adm(i,j)*bnd(i-1,j)*dx(i-1)

                    case ('3')  ! u(1,j)=u(nx-1,j)
                       tmp_adm(i,j)=adm(i,j)*psi(nx-1,j)

                    end select

                    if(signb==1)then
                       select case (bound(2:3))
                       case ('11')  ! ξ궭
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x Υޥ y 
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1), i-1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(i,ny)=u(i,2), i-1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,2)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! j+1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(i-1,j+1)=u(i,j)+0.5*(-f(i-1,j+1)*dx(i-1)+f(i-1,j+1)*dy(j+1))
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)  &
  &                             +0.5*(bnd(i-1,j+1)*dx(i-1)-bnd(i-1,j+1)*dy(j+1)))/dxdy(i,j)
                       case ('23')  ! x  y Υޥ  u(i,ny)=u(i,2)
                          ! u(1,ny)=u(1,2)=u(2,2)-f(1,2)*dx(1)
                          ! u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,2)  &
  &                             +psi(i,j-1)-bnd(i-1,j-1)*dx(i-1)  &
  &                             -psi(i+1,j-1)-psi(2,2)+bnd(1,2)*dx(1))/dxdy(i,j)
                       case ('31')  ! x  y   u(1,j)=u(nx-1,j),  j+1 ϸ궯
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(nx-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x Υޥ y   u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          ! u(1,ny)=u(nx-1,ny)=u(nx-1,ny-1)+f(nx-1,ny)*dy(ny)
                          ! u(1,j)=u(nx-1,j)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                             +psi(nx-1,j-1)-psi(i+1,j-1)  &
  &                             -psi(nx-1,ny-1)-bnd(nx-1,ny)*dy(ny))/dxdy(i,j)
                       case ('33')  ! x, y   u(1,ny)=u(nx-1,2)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,2)+psi(nx-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(nx-1,2))/dxdy(i,j)

                       end select
                    else
                       tmp_b(i,j)=0.0
                    end if

                    tmp(i,j)=(tmp(i,j)+tmp_adm(i,j)+tmp_cep(i,j)+tmp_b(i,j))/ac(i,j)


                 end if

              end if

           end if

           if(i==nx-1)then  ! Ǥΰ. Ǥ, adp ʳι϶̷׻ǽ.
              if(j/=2.or.j/=ny-1)then  ! ʳ
                 tmp(i,j)=cep(i,j)*psi(i,j+1)  &
  &                  +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(4:4))  ! y ü
                 case ('1')
                    tmp_adp(i,j)=adp(i,j)*psi(i+1,j)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                    tmp_adp(i,j)=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                          +psi(i-1,j-1)-psi(i,j-1)-bnd(i+1,j-1)*dx(i+1)  &
  &                          -psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('3')  ! u(nx,j)=u(2,j)
                    tmp_adp(i,j)=adp(i,j)*psi(2,j)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,j-1)  &
  &                          -psi(2,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 end select

                 tmp(i,j)=(tmp(i,j)+tmp_adp(i,j)+tmp_b(i,j))/ac(i,j)

              else

                 if(j==2)then  !   adm, cep ϶˴طʤ.

                    tmp(i,j)=adm(i,j)*psi(i-1,j)+cep(i,j)*psi(i,j+1)  &
  &                     -rho(i,j)

                    select case (bound(1:1))  ! x ü -> cem η׻
                    case ('1')
                       tmp_cem(i,j)=cem(i,j)*psi(i,j-1)

                    case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                       tmp_cem(i,j)=-cem(i,j)*bnd(i,j-1)*dy(j-1)

                    case ('3')  ! u(i,1)=u(i,ny-1)
                       tmp_cem(i,j)=cem(i,j)*psi(i,ny-1)

                    end select

                    select case (bound(4:4))
                    case ('1')
                       tmp_adp(i,j)=adp(i,j)*psi(i-1,j)

                    case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                       tmp_adp(i,j)=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    case ('3')  ! u(nx,j)=u(2,j)
                       tmp_adp(i,j)=adp(i,j)*psi(2,j)

                    end select

                    if(signb==1)then
                       select case (bound(1:1)//bound(4:4))
                       case ('11')  ! ξ궭
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ
                          ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1), j-1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                             +psi(i-1,j-1)-psi(i+1,j-1)-psi(i,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(nx,j)=u(2,j)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! u(i+1,j-1)=u(i,j)+0.5*(f(i+1,j)*dx(i+1)-f(i,j-1)*dy(j-1))
                          ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i,j+1)+bnd(i+1,j+1)*dx(i+1)  &
  &                             -psi(i-1,j)+bnd(i-1,j-1)*dy(j-1) &
  &                             -0.5*(bnd(i+1,j)*dx(i+1)-bnd(i,j-1)*dy(j-1))  &
  &                             -psi(i-1,j+1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                          ! u(nx,1)=u(2,1)=u(2,2)-f(2,1)*dy(1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(2,j+1)  &
  &                             +psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)  &
  &                             -psi(2,2)+bnd(2,1)*dy(1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,j-1)=u(i,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,ny-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i-1,j)=u(i,j)-f(i-1,j)*dx(i-1)
                          ! u(1,1)=u(1,ny-1)=u(2,ny-1)-f(1,ny-1)*dx(1)
                          ! u(i,j-1)=u(i,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                             +psi(i,ny-1)-bnd(i-1,ny-1)*dx(i-1)  &
  &                             -psi(i+1,ny-1)-psi(i,j+1)+bnd(i-1,j+1)*dx(i-1))/dxdy(i,j)
                       case ('33')  ! x, y   u(nx,1)=u(2,ny-1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(2,j+1)+psi(i-1,ny-1)  &
  &                             -psi(2,ny-1)-psi(i-1,j+1))/dxdy(i,j)

                      end select
                    else
                       tmp_b(i,j)=0.0
                    end if

                    tmp(i,j)=(tmp(i,j)+tmp_adp(i,j)+tmp_cem(i,j)+tmp_b(i,j))/ac(i,j)

                 else  !   adm, cem ϶˴طʤ.

                    tmp(i,j)=adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)  &
  &                     -rho(i,j)

                    select case (bound(3:3))  ! x ü -> cep η׻
                    case ('1')
                       tmp_cep(i,j)=cep(i,j)*psi(i,j+1)

                    case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                       tmp_cep(i,j)=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    case ('3')  ! u(i,ny)=u(i,2)
                       tmp_cep(i,j)=cep(i,j)*psi(i,2)

                    end select

                    select case (bound(4:4))
                    case ('1')
                       tmp_adp(i,j)=adp(i,j)*psi(i-1,j)

                    case ('2')  ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                       tmp_adp(i,j)=adp(i,j)*bnd(i+1,j)*dx(i+1)

                    case ('3')  ! u(nx,j)=u(2,j)
                       tmp_adp(i,j)=adp(i,j)*psi(2,j)

                    end select

                    if(signb==1)then
                       select case (bound(3:4))
                       case ('11')  ! ξ궭
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('12')  ! x  y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! j+1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j)-bnd(i+1,j-1)*dx(i+1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('13')  ! x  y   u(nx,j)=u(2,j),  j+1 ϸ궯
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(2,j-1)-psi(i-1,j+1))/dxdy(i,j)
                       case ('21')  ! x Υޥ y 
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1), i+1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                       case ('22')  ! x, y Υޥ  u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          ! u(i+1,j+1)=u(i,j)+0.5*(f(i+1,j)*dx(i+1)+f(i,j+1)*dy(j+1))
                          ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          tmp_b(i,j)=0.25*bt(i,j)*(0.5*(bnd(i+1,j)*dx(i+1)  &
  &                             +bnd(i,j+1)*dy(j+1))+psi(i-1,j-1)  &
  &                             -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1)  &
  &                             -psi(i,j-1)-bnd(i+1,j-1)*dx(i+1))/dxdy(i,j)
                       case ('23')  ! x Υޥ y   u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                          ! u(nx,ny)=u(2,ny)=u(2,ny-1)+f(2,ny)*dy(ny)
                          ! u(nx,j)=u(2,j)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(2,ny-1)+bnd(2,ny)*dy(ny)  &
  &                             +psi(i-1,j-1)-psi(2,j-1)  &
  &                             -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                       case ('31')  ! x  y   u(i,ny)=u(i,2), i+1 ϸ궯.
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,2))/dxdy(i,j)
                       case ('32')  ! x  y Υޥ  u(i,ny)=u(i,2)
                          ! u(nx,ny)=u(nx,2)=u(nx-1,2)+f(nx,2)*dx(nx)
                          ! u(i+1,j)=u(i,j)+f(i+1,j)*dx(i+1)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(nx-1,2)+bnd(nx,2)*dx(nx)  &
  &                             +psi(i-1,j-1)-psi(i,j-1)-bnd(i+1,j-1)*dx(i+1)  &
  &                             -psi(i-1,2))/dxdy(i,j)
                       case ('33')  ! x, y   u(nx,ny)=u(2,2)
                          tmp_b(i,j)=0.25*bt(i,j)*(psi(2,2)+psi(i-1,j-1)  &
  &                             -psi(2,j-1)-psi(i-1,2))/dxdy(i,j)

                       end select
                    else
                       tmp_b(i,j)=0.0
                    end if

                    tmp(i,j)=(tmp(i,j)+tmp_adp(i,j)+tmp_cep(i,j)+tmp_b(i,j))/ac(i,j)


                 end if

              end if
           end if

           if(j==2)then  ! Ǥΰ. Ǥ, cem ʳι϶̷׻Ǥ.
              if(i/=2.or.i/=nx-1)then  ! ʳ
                 tmp(i,j)=adp(i,j)*psi(i+1,j)+cep(i,j)*psi(i,j+1)  &
  &                  +adm(i,j)*psi(i-1,j)-rho(i,j)

                 select case (bound(1:1))  ! x ü
                 case ('1')
                    tmp_cem(i,j)=cem(i,j)*psi(i,j-1)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('2')  ! u(i,j-1)=u(i,j)-f(i,j-1)*dy(j-1)
                    tmp_cem(i,j)=-cem(i,j)*bnd(i,j-1)*dy(j-1)
            
                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)  &
  &                          +psi(i-1,j)-bnd(i-1,j-1)*dy(j-1)  &
  &                          -psi(i+1,j)+bnd(i+1,j-1)*dy(j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('3')  ! u(i,1)=u(i,ny-1)
                    tmp_cem(i,j)=cem(i,j)*psi(i,ny-1)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,ny-1)  &
  &                          -psi(i+1,ny-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 end select

                 tmp(i,j)=(tmp(i,j)+tmp_cem(i,j)+tmp_b(i,j))/ac(i,j)

              end if
           end if

           if(j==ny-1)then  ! 嶭Ǥΰ. Ǥ, cep ʳι϶̷׻ǽ.
              if(i/=2.or.i/=nx-1)then  ! ʳ
                 tmp(i,j)=adp(i,j)*psi(i+1,j)  &
  &                  +adm(i,j)*psi(i-1,j)+cem(i,j)*psi(i,j-1)-rho(i,j)

                 select case (bound(3:3))  ! x ü
                 case ('1')
                    tmp_cep(i,j)=cep(i,j)*psi(i,j+1)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('2')  ! u(i,j+1)=u(i,j)+f(i,j+1)*dy(j+1)
                    tmp_cep(i,j)=cep(i,j)*bnd(i,j+1)*dy(j+1)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,j)+bnd(i+1,j+1)*dy(j+1)  &
  &                          +psi(i-1,j-i)-psi(i+1,j-1)  &
  &                          -psi(i-1,j)-bnd(i-1,j+1)*dy(j+1))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 case ('3')  ! u(i,ny)=u(i,2)
                    tmp_cep(i,j)=cep(i,j)*psi(i,2)

                    if(signb==1)then
                       tmp_b(i,j)=0.25*bt(i,j)*(psi(i+1,2)+psi(i-1,j-1)  &
  &                          -psi(i+1,j-1)-psi(i-1,2))/dxdy(i,j)
                    else
                       tmp_b(i,j)=0.0
                    end if

                 end select

                 tmp(i,j)=(tmp(i,j)+tmp_cep(i,j)+tmp_b(i,j))/ac(i,j)

              end if

           end if
        end if
     end do
  end do
!$omp end do
!$omp end parallel

!!-- ޤǤ if ʸΥǥȤĴᤷʤ.
!        end if
!
!        tmp=tmp/ac(i,j)
!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
!        if(psi(i,j)==0.0)then
!           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
!        else
!           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
!        end if
        err=abs(tmp(i,j)-psi(i,j))

!-- ι
        if(err_max<=err)then
           err_max=err
        end if
     end do
  end do

  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do

!-- 
!-- x ü
  select case (bound(1:1))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do i=2,nx-1
        psi(i,1)=psi(i,2)-bnd(i,1)*dy(1)
     end do

  case ('3')
     do i=2,nx-1
        psi(i,1)=psi(i,ny-1)
     end do
  end select

!-- y ü
  select case (bound(2:2))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do j=2,ny-1
        psi(1,j)=psi(2,j)-bnd(1,j)*dx(1)
     end do

  case ('3')
     do j=2,ny-1
        psi(1,j)=psi(nx-1,j)
     end do
  end select

!-- x ü
  select case (bound(3:3))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do i=2,nx-1
        psi(i,ny)=psi(i,ny-1)+bnd(i,ny)*dy(ny)
     end do

  case ('3')
     do i=2,nx-1
        psi(i,ny)=psi(i,2)
     end do
  end select

!-- y ü
  select case (bound(4:4))  ! bound = 1 ϶ǤιʤΤ, ʬʤ.
  case ('2')
     do j=2,ny-1
        psi(nx,j)=psi(nx-1,j)+bnd(nx,j)*dx(nx)
     end do

  case ('3')
     do j=2,ny-1
        psi(nx,j)=psi(2,j)
     end do
  end select

!-- 4 ü  ! ʲ, 궭ɤ餫ˤʤ, ͤ˶ ('11', '12,', '13', '21', '31')
!-- ޤ, bound(1:2) ͤʬ, bound(3:4) ͤդ˷ޤ.
!-- üΤ߼ʤ, ͤ򹹿, ΤȤ˥եåή֤ˤ.
  select case (bound(1:2))
  case ('23')  ! ξ y ξüǼʤΤ, (1,1), (nx,1) ͤǷޤ.
     psi(1,1)=psi(nx-1,2)-bnd(nx-1,1)*dy(1)
     psi(nx,1)=psi(2,2)-bnd(2,1)*dy(1)

     if(bound(3:3)=='2')then  ! x ü 1 ʤ餹Ǥ˶ƤΤ, ⤷ʤ.
        psi(1,ny)=psi(nx-1,ny-1)+bnd(nx-1,ny)*dy(ny)
        psi(nx,ny)=psi(2,ny-1)+bnd(2,ny)*dy(ny)
     end if

  case ('32')  ! ξ x ξüǼʤΤ, (1,1), (1,ny) ͤǷޤ.
     psi(1,1)=psi(2,ny-1)-bnd(1,ny-1)*dx(1)
     psi(1,ny)=psi(2,2)-bnd(1,2)*dx(1)

     if(bound(4:4)=='2')then  ! y ü 1 ʤ餹Ǥ˶ƤΤ, ⤷ʤ.
        psi(nx,1)=psi(nx-1,ny-1)+bnd(nx,ny-1)*dx(nx)
        psi(nx,ny)=psi(nx-1,2)+bnd(nx,2)*dx(nx)
     end if

  case ('33')  ! ξΰ
     psi(1,1)=psi(nx-1,ny-1)
     psi(nx,1)=psi(2,ny-1)
     psi(1,ny)=psi(nx-1,2)
     psi(nx,ny)=psi(2,2)

  case default  ! Ȥ, ɤζˤƤ, '22' Ǥʤ, 궯.
     if(bound(1:2)=='22')then
        psi(1,1)=psi(2,2)-0.5*(bnd(1,2)*dy(1)+bnd(2,1)*dx(1))
     end if

     if(bound(2:3)=='22')then
        psi(1,ny)=psi(2,ny-1)+0.5*(bnd(1,ny-1)*dy(ny)-bnd(2,ny)*dx(1))
     end if

     if(bound(3:4)=='22')then
        psi(nx,ny)=psi(nx-1,ny-1)+0.5*(bnd(nx,ny-1)*dy(ny)+bnd(nx-1,ny)*dx(nx))
     end if

     if(bound(1:1)=='2'.and.bound(4:4)=='2')then
        psi(nx,1)=psi(nx-1,2)+0.5*(-bnd(nx,2)*dy(1)+bnd(nx-1,1)*dx(nx))
     end if

  end select
  end do
  
end subroutine Poisson_Jacobi

end module
