!-----------------------------------------------------------------------
!     Copyright (C) 2000-2013 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module typhoon_analy  ! ټ¸ѥڥϥ⥸塼

  private :: search_region_1d  ! ʿѤǽȾ¤ܺ.

contains

subroutine tangent_mean_scal( x, y, xc, yc, u, r, theta, v, undef,  &
  &                           undefg, undefgc )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u(size(x),size(y))  ! ǥȺɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef   ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  integer :: i, j, nx, ny, nr, nrr, nt
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  character(1) :: undefgcflag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf

  nx=size(x)
  ny=size(y)
  nrr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---

  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr )

!--  v  undef ͤƤ.
  do i=1,nrr
     if(present(undef))then
        v(i)=undef
     else
        v(i)=0.0
     end if
  end do

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)

        if(present(undefg))then
           ucf=undef_checker_2d( tmpz, undefg )
           if(ucf.eqv..false.)then
              inter(1)=point(i,j,1)
              inter(2)=point(i,j,2)
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           else
              work(i,j)=undefg
              undefgc_check(i)=.false.
           end if
        else
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
        end if
     end do
  end do

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=2,nr
           call Mean_1d( work(i,:), v(i), error=undefg )
        end do
     else
        do i=2,nr
           if(undefgc_check(i).eqv..true.)then
              call Mean_1d( work(i,:), v(i) )
           else
              v(i)=undefg
           end if
        end do
     end if
  else
     do i=2,nr
        call Mean_1d( work(i,:), v(i) )
     end do
  end if

  v(1)=work(1,1)

end subroutine tangent_mean_scal

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal( x, y, xc, yc, u, r, theta, v, undef,  &
  &                                undefg, undefgc )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt к׻ Anomaly_1d .
  ! ʾǳ nr ˤĤкͤ.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u(size(x),size(y))  ! ǥȺɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
                ! ǥեȤ "inc".
  integer :: i, j, nx, ny, nr, nrr, nt
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  character(1) :: undefgcflag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf

  nx=size(x)
  ny=size(y)
  nrr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---

  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr )

!--  v  undef ͤƤ.
  do j=1,nt
     do i=1,nrr
        if(present(undef))then
           v(i,j)=undef
        else
           v(i,j)=0.0
        end if
     end do
  end do

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)

        if(present(undefg))then
           ucf=undef_checker_2d( tmpz, undefg )
           if(ucf.eqv..false.)then
              inter(1)=point(i,j,1)
              inter(2)=point(i,j,2)
              call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
           else
              work(i,j)=undefg
              undefgc_check(i)=.false.
           end if
        else
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
        end if
     end do
  end do

!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=2,nr
           call Anomaly_1d( work(i,:), v(i,:), error=undefg )
        end do
     else
        do i=2,nr
           if(undefgc_check(i).eqv..true.)then
              call Anomaly_1d( work(i,:), v(i,:) )
           else
              do j=1,nt
                 v(i,j)=undefg
              end do
           end if
        end do
     end if
  else
     do i=2,nr
        call Anomaly_1d( work(i,:), v(i,:) )
     end do
  end if

  v(1,:)=work(1,1)

end subroutine tangent_mean_anom_scal

!--------------------------------------------------------------
!--------------------------------------------------------------
subroutine tangent_mean_anom_scal_Cart( x, y, xc, yc, scal, r, theta,  &
  &                                     scal_anom, undef, undefg, undefgc )
  ! 濴Υޥ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ε᤿ͤ򸵤ΥǥȥǡȤǥΥޥȤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use statistics
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: scal_anom(size(x),size(y))  ! ǥȷϤǤΥΥޥ.
  real, optional :: undef  ! ͤĤʤȤ̤.
                           ! ǥեȤǤ dcl ̤
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  integer :: j, k, nx, ny, nr, nt, itmpr
  real :: tmp(size(r))
  real :: tmpr, tmp_anom, undeff
  character(3) :: undefgcflag

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:3)
     else
        undefgcflag="inc"
     end if
  end if

  if(present(undefg))then
     call tangent_mean_scal( x, y, xc, yc, scal, r, theta, tmp,  &
  &                    undef=undeff, undefg=undefg, undefgc=undefgcflag(1:3) )
  else
     call tangent_mean_scal( x, y, xc, yc, scal, r, theta, tmp, undef=undeff )
  end if

!-- ʿͤޤ, ͤƥΥޥ.
  if(present(undefg))then
     if(undefgcflag(1:3)=='err')then
        do k=1,ny
           do j=1,nx
              tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              call interpo_search_1d( r, tmpr, itmpr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     else
        do k=1,ny
           do j=1,nx
              tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
              call interpo_search_1d( r, tmpr, itmpr )
              if(nr>itmpr)then
                 if(tmp(itmpr)/=undefg.and.tmp(itmpr+1)/=undefg.and.  &
  &                 scal(j,k)/=undefg)then
                    call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                       (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
                    scal_anom(j,k)=scal(j,k)-tmp_anom
                 else
                    scal_anom(j,k)=undefg
                 end if
              else
                 scal_anom(j,k)=undeff
              end if
           end do
        end do
     end if
  else
     do k=1,ny
        do j=1,nx
           tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
           call interpo_search_1d( r, tmpr, itmpr )
           if(nr>itmpr)then
              call interpolation_1d( (/r(itmpr), r(itmpr+1)/),  &
  &                               (/tmp(itmpr), tmp(itmpr+1)/), tmpr, tmp_anom )
              scal_anom(j,k)=scal(j,k)-tmp_anom
           else
              scal_anom(j,k)=undeff
           end if
        end do
     end do
  end if

end subroutine tangent_mean_anom_scal_Cart

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_vec( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                          undef, undefg, undefgc )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r.
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  integer :: i, j, nx, ny, nr, nrr, nt
  real :: work1(size(r),size(theta),1), work2(size(r),size(theta),1), work3(size(r),size(theta),1)
  real :: posx(size(r),size(theta),1), posy(size(r),size(theta),1), posz(size(r),size(theta),1)
  real :: vecx(size(r),size(theta),1), vecy(size(r),size(theta),1), vecz(size(r),size(theta),1)
  real :: abpos(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  character(1) :: undefgcflag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf

  nx=size(x)
  ny=size(y)
  nrr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---

  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr )

!--  v  undef ͤƤ.
  do i=1,nrr
     if(present(undef))then
        v(i)=undef
     else
        v(i)=0.0
     end if
  end do

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do


!-- (3) ---
!-- 1. ٥ȥ 2 ʬˤĤޤͤ˳Ǽ ---
  if(present(undefg))then
     do j=1,nt
        do i=1,nr
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
           ucf=undef_checker_2d( tmpz, undefg )
           if(ucf.eqv..false.)then
              inter(1)=point(i,j,1)
              inter(2)=point(i,j,2)

              call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )

              tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
              tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
              tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
              tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
              ucf=undef_checker_2d( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
              else
                 work1(i,j,1)=undefg
                 work2(i,j,1)=undefg
              end if
           else  ! λ undefg äƤ, work2 Ȥʤ.
              work1(i,j,1)=undefg
              work2(i,j,1)=undefg
           end if
        end do
     end do
  else
     do j=1,nt
        do i=1,nr
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )
           tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
        end do
     end do
  end if

!-- 2. ޤȤä, Ǥ x,y ɸ(ֹ, ix,iy ˳Ǽ)
!--    ΰ֥٥ȥȤγѤ׻
  do j=1,nt
     do i=1,nr
        work3(i,j,1)=0.0
        posx(i,j,1)=point(i,j,1)-xc
        posy(i,j,1)=point(i,j,2)-yc
        posz(i,j,1)=0.0
     end do
  end do

  select case (charc)
  case ('vector')
     call vec_prod( posx, posy, posz, work1, work2, work3, vecx, vecy, vecz )
  case ('scalar')
     call dot_prod( posx, posy, posz, work1, work2, work3, vecz )
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

!-- , work1  undefg äƤ뤫å.
!-- , work1  undefg äƤ, work2 ˤ undefg 
!-- äƤΤ, work1 åФ褤.

  if(present(undefg))then
     do j=1,nt
        do i=1,nr
           if(work1(i,j,1)==undefg)then
              vecz(i,j,1)=undefg
           end if
        end do
     end do
  end if

!-- 3. ٥ȥγʬΤ, z ʬˤĤ (2 ʿ̥٥ȥƱΤγ)
!--    ֥٥ȥͤǳ. -> ®ʬޤͤ.
  call abst( posx, posy, posz, abpos )

  if(present(undefg))then
     do j=1,nt
        do i=2,nr   
           if(vecz(i,j,1)/=undefg)then
              vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
           end if
        end do
     end do
  else
     do j=1,nt
        do i=2,nr   
           vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
        end do
     end do
  end if


!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=2,nr
           call Mean_1d( vecz(i,:,1), v(i), error=undefg )
        end do
     else
        do i=2,nr
           ucf=undef_checker_1d( vecz(i,:,1), undefg )
           if(ucf.eqv..false.)then
              call Mean_1d( vecz(i,:,1), v(i) )
           else
              v(i)=undefg
           end if
        end do
     end if
  else
     do i=2,nr
        call Mean_1d( vecz(i,:,1), v(i) )
     end do
  end if

  v(1)=0.0

end subroutine tangent_mean_vec


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_vec( charc, x, y, xc, yc, u1, u2, r, theta, v,  &
  &                               undef, undefg, undefgc )
  ! Ǥդʪ̤濴ʿѥΥޥ׻롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʳξ, r ͿΥΰ賰ϰϤˤĤƤ
  ! undef ꤵ줿ͤ. undef ʤȤϥ.
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  ! ʲ, Թǽ꡹ present(undefg) äƤ뤬,
  ! ʽˤϴطʤΤ, ɤ, present(undefg)  else
  ! βս򻲾Ȥ줿.
  use algebra
  use Derivation
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! Υޥ u .
  real, intent(in), optional :: undef  ! ΰ賰
  real, intent(in), optional :: undefg  ! ʻ˷»̤
  character(3), intent(in), optional :: undefgc  ! undefg ν
                ! "inc" = γʻ򻲾ͤȤޤΤʿ˽Ʒ׻.
                ! "err" = γʻ򻲾ͤȤޤʿ˴ޤ, ʿͤΤΤ̤ȤƷ׻. ξ, ̤ͤ undefg Ȥʤ.
  integer :: i, j, nx, ny, nr, nrr, nt
  real :: work1(size(r),size(theta),1), work2(size(r),size(theta),1), work3(size(r),size(theta),1)
  real :: posx(size(r),size(theta),1), posy(size(r),size(theta),1), posz(size(r),size(theta),1)
  real :: vecx(size(r),size(theta),1), vecy(size(r),size(theta),1), vecz(size(r),size(theta),1)
  real :: abpos(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)
  character(1) :: undefgcflag
  logical, dimension(size(r)) :: undefgc_check
  logical :: ucf

  nx=size(x)
  ny=size(y)
  nrr=size(r)
  nt=size(theta)

  undefgc_check(:)=.true.

  if(present(undefg))then
     if(present(undefgc))then
        undefgcflag=undefgc(1:1)
     else
        undefgcflag="i"
     end if
  end if

!-- ΰ򥯥ꥢƤ뤫ǧ ---

  call search_region_1d( (/x(1),x(nx)/), (/y(1),y(ny)/), (/xc,yc/), r, nr )

!--  v  undef ͤƤ.
  do j=1,nt
     do i=1,nrr
        if(present(undef))then
           v(i,j)=undef
        else
           v(i,j)=0.0
        end if
     end do
  end do

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do


!-- (3) ---
!-- 1. ٥ȥ 2 ʬˤĤޤͤ˳Ǽ ---
  if(present(undefg))then
     do j=1,nt
        do i=1,nr
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
           ucf=undef_checker_2d( tmpz, undefg )
           if(ucf.eqv..false.)then
              inter(1)=point(i,j,1)
              inter(2)=point(i,j,2)

              call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )

              tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
              tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
              tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
              tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
              ucf=undef_checker_2d( tmpz, undefg )
              if(ucf.eqv..false.)then
                 call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
              else
                 work1(i,j,1)=undefg
                 work2(i,j,1)=undefg
              end if
           else  ! λ undefg äƤ, work2 Ȥʤ.
              work1(i,j,1)=undefg
              work2(i,j,1)=undefg
           end if
        end do
     end do
  else
     do j=1,nt
        do i=1,nr
           tmpx(1)=x(ip(i,j,1))
           tmpx(2)=x(ip(i,j,1)+1)
           tmpy(1)=y(ip(i,j,2))
           tmpy(2)=y(ip(i,j,2)+1)
           tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
           inter(1)=point(i,j,1)
           inter(2)=point(i,j,2)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )
           tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
           tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
           tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
           tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
           call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
        end do
     end do
  end if

!-- 2. ޤȤä, Ǥ x,y ɸ(ֹ, ix,iy ˳Ǽ)
!--    ΰ֥٥ȥȤγѤ׻
  do j=1,nt
     do i=1,nr
        work3(i,j,1)=0.0
        posx(i,j,1)=point(i,j,1)-xc
        posy(i,j,1)=point(i,j,2)-yc
        posz(i,j,1)=0.0
     end do
  end do

  select case (charc)
  case ('vector')
     call vec_prod( posx, posy, posz, work1, work2, work3, vecx, vecy, vecz )
  case ('scalar')
     call dot_prod( posx, posy, posz, work1, work2, work3, vecz )
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

!-- , work1  undefg äƤ뤫å.
!-- , work1  undefg äƤ, work2 ˤ undefg 
!-- äƤΤ, work1 åФ褤.

  if(present(undefg))then
     do j=1,nt
        do i=1,nr
           if(work1(i,j,1)==undefg)then
              vecz(i,j,1)=undefg
           end if
        end do
     end do
  end if

!-- 3. ٥ȥγʬΤ, z ʬˤĤ (2 ʿ̥٥ȥƱΤγ)
!--    ֥٥ȥͤǳ. -> ®ʬޤͤ.
  call abst( posx, posy, posz, abpos )

  if(present(undefg))then
     do j=1,nt
        do i=2,nr
           if(vecz(i,j,1)/=undefg)then
              vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
           end if
        end do
     end do
  else
     do j=1,nt
        do i=2,nr
           vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
        end do
     end do
  end if


!-- (4) ---
  if(present(undefg))then
     if(undefgcflag(1:1)=='i')then
        do i=2,nr
           call Anomaly_1d( vecz(i,:,1), v(i,:), error=undefg )
        end do
     else
        do i=2,nr
           ucf=undef_checker_1d( vecz(i,:,1), undefg )
           if(ucf.eqv..false.)then
              call Anomaly_1d( vecz(i,:,1), v(i,:) )
           else
              v(i,:)=undefg
           end if
        end do
     end if
  else
     do i=2,nr
        call Anomaly_1d( vecz(i,:,1), v(i,:) )
     end do
  end if

  v(1,:)=0.0

end subroutine tangent_mean_anom_vec

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_turb( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
!  ʿѤήեå׻.
!  ʿѤƤΤ, tau_{*2} ʬ (\theta ʬʬ) ϴޤޤʤ.
  use algebra
  use Derivation
  implicit none
  character(1) :: signal  ! ɸϤβܤήʬȽꤹ.
                  ! [1] = ɸˤ radial ɸʬ ( vr ʬ)
                  ! [2] = ɸˤ tangential ɸʬ ( vt ʬ)
                  ! [3] = ɸˤ vertical ɸʬ ( w ʬ)
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  real, intent(in) :: z(:)  ! ľΰֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! y б 2 >ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: id   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]
  character(1) :: signaltau(3)
  real, dimension(size(r),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  real, dimension(size(r),size(z)) :: tmp
  real, dimension(size(r)) :: stau

  signaltau=(/ '1', '2', '3' /)

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z) 

  val=0.0

  do id=1,3
     if(id/=2)then  ! tau_{*2} ʬϥʤΤ, ׻ʤ.
        if(present(sfctau))then
           stau(:)=sfctau(:)
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id), sfctau=stau )
        else
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id) )
        end if
     end if
  end do

!-- (signal, 1) ʬη׻
  do k=1,nz
     call grad_1d( r, tau(:,k,1), tmp(:,k))
     do i=1,nr
        if(r(i)/=0.0)then
           val(i,k)=tmp(i,k)+val(i,k)+tau(i,k,1)/r(i)
        else
           val(i,k)=tmp(i,k)+val(i,k)
        end if
     end do
  end do

!-- (signal, 3) ʬη׻
  do i=1,nr
     call grad_1d( z, tau(i,:,3), tmp(i,:))
     do k=1,nz
        val(i,k)=tmp(i,k)+val(i,k)
     end do
  end do



end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_Reynolds( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
! ɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  use algebra
  use Derivation
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
!  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 3 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]
  real :: sxx(size(r),size(z)), nu(size(r),size(z))
  real :: stau(size(r))

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

  val=0.0
  stau=0.0

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:)=sfctau(:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='11')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='22')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

  if(signal(1:2)=='33')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

!-- ʲμ, ǽ val = 0  if ʸǷ׻ƤΤȤƤʤ
!-- ΤʬΤ, μɾǤ.
!-- ׻ƤʤΤˤĤƤϤ⤽⥼Ǥ.

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do i=1,nr
        val(i,1)=stau(i)
     end do
  else
     do i=1,nr
        val(i,1)=rho(1)*nu(i,1)*(sxx(i,1)-(2.0/3.0)*val(i,1))
     end do
  end if

  do k=2,nz
     do i=1,nr
        val(i,k)=rho(k)*nu(i,k)*(sxx(i,k)-(2.0/3.0)*val(i,k))
     end do
  end do

end subroutine


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_deform( signal, r, z, u, v, w, val, undef )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  use algebra
  use Derivation
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     do k=1,nz
        call grad_1d( r, v(:,k), val(:,k) )
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)-v(i,k)/r(i)
           end if
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nr
        call grad_1d( z, v(k,:), val(k,:) )
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call div( r, z, w, u, val )
  end if

  if(signal(1:2)=='11')then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call grad_1d( r, u(:,k), val(:,k) )
        val(:,k)=2.0*val(:,k)
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='22')then
!$omp parallel default(shared)
!$omp do private(j,k)
     do k=1,nz
        do j=1,nr
           if(r(j)/=0.0)then
              val(j,k)=2.0*u(j,k)/r(j)
           else
              val(j,k)=0.0
           end if
        end do
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='33')then
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,nr
        call grad_1d( z, w(j,:), val(j,:) )
        val(j,:)=2.0*val(j,:)
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine hydro_grad_eqb( r, z, coril, v, pres_s, rho_s, pres, rho, error )
!  ǥ󥰤ȼоήϳءʿվη׻.
  use Thermo_Const
  use Phys_Const
  use algebra
  use Derivation
  implicit none
  real, intent(in) :: r(:)  ! ưºɸ [m]
  real, intent(in) :: z(:)  ! ľɸ [m]
  real, intent(in) :: coril(size(r),size(z))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r),size(z))  ! оή [m/s]
  real, intent(in) :: pres_s(size(z))  ! ǥ󥰤ε [Pa]
  real, intent(in) :: rho_s(size(z))  ! ǥ󥰤̩ [kg/m^3]
  real, intent(in), optional :: error  ! 졼μ«
                    ! default = 1.0e-5
  real, intent(inout) :: pres(size(r),size(z))  ! ʿվε [Pa]
  real, intent(inout) :: rho(size(r),size(z))  ! ʿվ̩ [kg/m^3]
  real :: old_pres(size(r),size(z)), old_rho(size(r),size(z))
  integer :: nr, nz
  integer :: i, j
  real :: err, err_tmp, err_max

  nr=size(r)
  nz=size(z)

  if(present(error))then
     err_max=error
  else
     err_max=1.0e-5
  end if

!-- ʲǳƹ٤ˤ, ̩٤ϰǤȤƷʿդ鵤׻,
!-- ͤѤϳʿդ̩٤. eps ʲˤʤޤǷ֤.
!--  2 ȥǥ󥰤.
  do i=1,nz
     old_pres(nr,i)=pres_s(i)
  end do
!-- ̩٤ˤĤƤ, ʿ̰ͤ
  do j=1,nz
     do i=1,nr
        old_rho(i,j)=rho_s(j)
     end do
  end do

!-- ʲǥ졼󳫻.
  err=err_max

  do while(err>=err_max)
     err=0.0
!-- ʿդ鰵Ͼ׻
     do j=1,nz
        call grad_wind_pres( r, coril(:,j), v(:,j), old_rho(:,j), r(nr), old_pres(nr,j), pres(:,j) )
     end do

!-- ϳʿդ̩پ
     do i=1,nr
        call grad_1d( z, pres(i,:), rho(i,:) )
        do j=1,nz
if(i==1)then
write(*,*) "#### pres", pres(i,j), rho(i,j)
end if
           rho(i,j)=-rho(i,j)/g  ! ϳؤμ, dp/dz=-g*rho ǤΤ
        end do
     end do

!-- ̩پμ«׻
     do j=1,nz
        do i=1,nr
           if(rho(i,j)==0.0)then
              err_tmp=abs(old_rho(i,j)-rho(i,j))/abs(old_rho(i,j))
           else
              err_tmp=abs(old_rho(i,j)-rho(i,j))/abs(old_rho(i,j))
           end if

!-- ι
           if(err<=err_tmp)then
              err=err_tmp
           end if

           old_rho(i,j)=rho(i,j)
           old_pres(i,j)=pres(i,j)

        end do
     end do

  end do

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine grad_wind_pres( r, coril, v, rho, r_ref, p_ref, pres )
!  ʿվ׻.
  use Algebra
  implicit none
  real, intent(in) :: r(:)  ! r ΰֺɸ [m]
  real, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r))  ! r ΰֺɸ [m]
  real, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  real, intent(in) :: r_ref  ! ʬȤʤֺɸ [m]
  real, intent(in) :: p_ref  ! r_ref Ǥε (ʬ) [Pa]
  real, intent(inout) :: pres(size(r))  ! ʿդǤε [Pa]
  integer :: i, nr
  real :: grad(size(r))

  nr=size(r)

  do i=1,nr
     if(r(i)/=0.0)then
        grad(i)=rho(i)*(v(i)*v(i)/r(i)+coril(i)*v(i))
     else
        grad(i)=0.0
     end if
  end do

  do i=1,nr
     if(r(i)<r_ref)then
        call rectangle_int( r, grad, r(i), r_ref, pres(i) )
        pres(i)=p_ref-pres(i)
     else
        if(r(i)>r_ref)then
           call rectangle_int( r, grad, r_ref, r(i), pres(i) )
           pres(i)=p_ref+pres(i)
        else
           pres(i)=p_ref
        end if
     end if
  end do

end subroutine

!--------------------------------------------------------------
!  ʲ, private 롼
!--------------------------------------------------------------

subroutine search_region_1d( x, y, c, r, nr )
! ʿѲǽȾ¤׻롼
  use Statistics
  implicit none
  real, intent(in) :: x(2)  ! x ξüɸ [m]
  real, intent(in) :: y(2)  ! y ξüɸ [m]
  real, intent(in) :: c(2)  ! 濴ΰֺɸ (x,y) [m]
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  integer, intent(inout) :: nr  ! ʿѲǽȾ¤ֹ (r(nr) ǽȾ)
  integer :: nrr, tmp_nr
  real :: xc, yc

  nrr=size(r)
  xc=c(1)
  yc=c(2)

  nr=nrr
  if(abs(x(1)-xc) < r(nrr))then
     write(*,*) "typhoon_analy WARNING :"
     write(*,*) "|x(1)-xc| >= rmax. "
     write(*,*) "undef value is substituted out of region."
     call interpo_search_1d( r, abs(x(1)-xc), tmp_nr )
     nr=tmp_nr+1  ! interpo_search  abs ͤ꾮 r ֹ椬뤿.
                  ! ʲƱͳ
  else
     if(abs(x(2)-xc) < r(nrr))then
     write(*,*) "typhoon_analy WARNING :"
        write(*,*) "|x(nx)-xc| >= rmax. "
        write(*,*) "undef value is substituted out of region."
        call interpo_search_1d( r, abs(x(2)-xc), tmp_nr )
        if(tmp_nr+1<nr)then
           nr=tmp_nr+1
        end if
     else
        if(abs(y(1)-yc) < r(nrr))then
           write(*,*) "typhoon_analy WARNING :"
           write(*,*) "|y(1)-yc| >= rmax. "
           write(*,*) "undef value is substituted out of region."
           call interpo_search_1d( r, abs(y(1)-yc), tmp_nr )
           if(tmp_nr+1<nr)then
              nr=tmp_nr+1
           end if
        else
           if(abs(y(2)-yc) < r(nrr))then
              write(*,*) "typhoon_analy WARNING :"
              write(*,*) "|y(ny)-yc| >= rmax. "
              write(*,*) "undef value is substituted out of region."
              call interpo_search_1d( r, abs(y(2)-yc), tmp_nr )
              if(tmp_nr+1<nr)then
                 nr=tmp_nr+1
              end if
           end if
        end if
     end if
  end if

end subroutine search_region_1d

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_1d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val)
  checker=.false.

  do i=1,nx
     if(val(i)==undef)then
        checker=.true.
        exit
     end if
  end do

  undef_checker_1d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_2d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,2)
  checker=.false.

  do i=1,nx
     checker=undef_checker_1d( val(:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_2d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

logical function undef_checker_3d( val, undef )
! Ǥ val ˤĤ, ٤ƤǤˤĤ undef ȤͤäƤ뤫
! ɤå. 1 ĤǤ undef äƤ .true. ֤.
  implicit none
  real, dimension(:,:,:), intent(in) :: val  ! å
  real, intent(in) :: undef  ! åѿ
  integer :: i, nx
  logical :: checker

  nx=size(val,3)
  checker=.false.

  do i=1,nx
     checker=undef_checker_2d( val(:,:,i), undef )
     if(checker.eqv..true.)then
        exit
     end if
  end do

  undef_checker_3d=checker

  return
end function

!--------------------------------------------------------------
!--------------------------------------------------------------

!subroutine Rangular_moment(xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!
!end subroutine Rangular_moment
!
!
!subroutine Aangular_moment(xp,yp,x,y,u,v,f,mome)
!! Ǥդޤгѱư̤׻롼
!!
!! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!!
!! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!!
!! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
!! ׻뤳Ȥǽ.
!!
!! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
!  use algebra
!  implicit none
!  real, intent(in) :: x(:)  ! x ΰֺɸ
!  real, intent(in) :: y(:)  ! y ΰֺɸ
!  real, intent(in) :: xp  ! ž x ֺɸ
!  real, intent(in) :: yp  ! ž y ֺɸ
!  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
!  real, intent(in) :: f(size(x),size(y))  !  i,j ǤΥꥪѥ᡼
!  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
!  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
!  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
!  integer :: i, j, nx, ny
!  real :: tmp(size(x),size(y),1), rp(size(x),size(y)), tmp1(1)
!
!  nx=size(x)
!  ny=size(y)
!
!!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        xxp(i,j,1)=x(i)-xp
!        yyp(i,j,1)=y(j)-yp
!     end do
!  end do
!!$omp end parallel do
!
!  tmp=0.0
!  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
!  call radius(xp,yp,0.0,x,y,tmp1,rp)
!
!!$omp parallel do shared(mome,f,rp) private(i,j)
!  do j=1,ny
!     do i=1,nx
!        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
!     end do
!  end do
!!$omp end parallel do
!
!end subroutine Aangular_moment

!-----------------------------------------
!-----------------------------------------

!-----------------------------------------
!-----------------------------------------

end module typhoon_analy
