program draw
  use dcl
  use Dcl_Automatic
  use gtool_history
  use Statistics
  use max_min
  use Thermo_Const
  use file_operate
  use basis

  implicit none

  integer :: i, j, k
  integer :: nx, ny, nt, nl
  integer :: nargv, fig_type
  integer :: xdmin, xdmax, ydmin, ydmax, tdmin, tdmax
  integer, dimension(2) :: ind 
  real :: xmin, xmax, ymin, ymax, tmin, tmax, xscale, yscale
  real, allocatable, dimension(:) :: x, y, t
  real, allocatable, dimension(:,:,:) :: val1, val2, val3, val4
  real, allocatable, dimension(:,:) :: xd, yd
  real, allocatable, dimension(:,:,:) :: dum1, dum2
  real, allocatable, dimension(:,:) :: draw_val1, draw_val2, draw_val3, draw_val4
  character(80) :: argv
  character(80) :: cont_val, shade_val, vx_val, vy_val, fname, txtname
  character(80) :: x_axis, y_axis, t_axis
  character(80), allocatable, dimension(:,:) :: cval
  character(80) :: draw_title, title
  character(1) :: line_flag
  character(10) :: tmp_c
  real :: cmin, cmax, smin, smax, sfact, cfact, vxfact, vyfact
  logical :: t_anim(2)

  cont_val=''
  shade_val=''
  vx_val=''
  vy_val=''

  namelist /drawinput /fig_type, nx, ny, nt, xmin, xmax, ymin, ymax,  &
  &                    tmin, tmax, fname,  &
  &                    txtname, cont_val, shade_val, vx_val, vy_val,  &
  &                    cmin, cmax, smin, smax, x_axis, y_axis, t_axis,  &
  &                    sfact, cfact, vxfact, vyfact, xscale, title
  read(5,nml=drawinput)

  allocate(x(nx))
  allocate(y(ny))
  allocate(t(nt))
  allocate(val1(nx,ny,nt))
  allocate(val2(nx,ny,nt))
  allocate(val3(nx,ny,nt))
  allocate(val4(nx,ny,nt))

  if(xmin==xmax)then  ! y-t Υۥե顼ؤѿ
     allocate(draw_val1(nt,ny))
     allocate(draw_val2(nt,ny))
     allocate(draw_val3(nt,ny))
     allocate(draw_val4(nt,ny))
  end if

  call SGISET('IFONT',2 )
  call UZFACT( 0.6 )
  call GLLSET('LMISS',.TRUE.)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )

  if(trim(title)=='')then
     draw_title=trim(cont_val)//' and '//trim(shade_val)
  else
     draw_title=trim(title)
  end if

!-- ѿ
  call HistoryGet( trim(fname), trim(x_axis), x(1:nx) )
  call HistoryGet( trim(fname), trim(y_axis), y(1:ny) )
  call HistoryGet( trim(fname), trim(t_axis), t(1:nt) )
  if(cont_val/='')then
     call HistoryGet( trim(fname), trim(cont_val), val1(1:nx,1:ny,1:nt) )

     do k=1,nt
        do j=1,ny
           do i=1,nx
              if(val1(i,j,k)/=999.0)then
                 val1(i,j,k)=val1(i,j,k)*cfact
              end if
           end do
        end do
     end do
  end if
  if(shade_val/='')then
     call HistoryGet( trim(fname), trim(shade_val), val2(1:nx,1:ny,1:nt) )

     do k=1,nt
        do j=1,ny
           do i=1,nx
              if(val2(i,j,k)/=999.0)then
                 val2(i,j,k)=val2(i,j,k)*sfact
              end if
           end do
        end do
     end do
  end if
  if(vx_val/='')then
     call HistoryGet( trim(fname), trim(vx_val), val3(1:nx,1:ny,1:nt) )

     do k=1,nt
        do j=1,ny
           do i=1,nx
              if(val3(i,j,k)/=999.0)then
                 val3(i,j,k)=val3(i,j,k)
              end if
           end do
        end do
     end do
  end if
  if(vy_val/='')then
     call HistoryGet( trim(fname), trim(vy_val), val4(1:nx,1:ny,1:nt) )

     do k=1,nt
        do j=1,ny
           do i=1,nx
              if(val4(i,j,k)/=999.0)then
                 val4(i,j,k)=val4(i,j,k)
              end if
           end do
        end do
     end do
  end if

!-- ƥȥǡ뤫ǧ
  if(txtname/='')then
     nl=line_number_counter( trim(txtname) )
     allocate(xd(nl,1))
     allocate(yd(nl,1))
     allocate(cval(2,nl))

     call read_file_text( trim(txtname), 2, nl, cval )

     do i=1,nl
        xd(i,1)=c2r_convert( cval(1,i) )
        yd(i,1)=c2r_convert( cval(2,i) )
     end do
     ind=(/8,8/)  ! index define
  end if

!-- ΰη
  t_anim=.true.
  if(xmin==xmax)then
     call nearest_search_1d( x, xmin, xdmin )
     xdmax=xdmin
     call nearest_search_1d( t, tmin, tdmin )
     call nearest_search_1d( t, tmax, tdmax )
     t_anim(1)=.false.
  else
     call nearest_search_1d( x, xmin, xdmin )
     call nearest_search_1d( x, xmax, xdmax )
  end if
  if(ymin==ymax)then
     call nearest_search_1d( y, ymin, ydmin )
     ydmax=ydmin
     call nearest_search_1d( t, tmin, tdmin )
     call nearest_search_1d( t, tmax, tdmax )
     t_anim(2)=.false.
  else
     call nearest_search_1d( y, ymin, ydmin )
     call nearest_search_1d( y, ymax, ydmax )
  end if

  if(t_anim(1).eqv..true..and.t_anim(2).eqv..true.)then
     call nearest_search_1d( t, tmin, tdmin )
     call nearest_search_1d( t, tmax, tdmax )
  end if

  if(xmax/=xmin.and.ymax/=ymin)then
     call calc_vscale( (/(xmax-xmin), (ymax-ymin)/), (/0.6, 0.6/), xscale, yscale )
!  yscale=yscale
     if(yscale>xscale)then
        xscale=xscale*xscale/yscale
        yscale=0.025
     end if
  else
     yscale=xscale
  end if

!  dummy=-10.0
write(*,*) "draw", trim(draw_title)
  call color_setting( 10, (/smin, smax/), min_tab=10999, max_tab=99999 )  

  call DclOpenGraphics(2)

  if(fig_type==1)then
     if(trim(txtname)/='')then
        if(t_anim(1).eqv..false.)then ! t-y 
           do j=1,ny
              do i=1,nt
                 draw_val1(i,j)=val1(xdmin,j,i)
                 draw_val2(i,j)=val2(xdmin,j,i)
              end do
           end do
           call Dcl_2D_cont_shade( trim(draw_title),  &
  &             t(tdmin:tdmax), y(ydmin:ydmax),  &
  &             draw_val1(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val2(tdmin:tdmax,ydmin:ydmax),  &
  &             (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind )  !,  &
        end if
        if(t_anim(2).eqv..false.)then  ! x-t 
           call Dcl_2D_cont_shade( trim(draw_title),  &
  &             x(xdmin:xdmax), t(tdmin:tdmax),  &
  &             val1(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val2(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind )  !,  &
        end if
        if(t_anim(1).eqv..true..and.t_anim(2).eqv..true.)then
           do i=tdmin,tdmax
              tmp_c=trim(adjustl(i2c_convert(i)))
              call Dcl_2D_cont_shade(  &
  &                trim(draw_title)//'_(tstep='//trim(adjustl(tmp_c))//')"',  &
  &                x(xdmin:xdmax), y(ydmin:ydmax),  &
  &                val1(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val2(xdmin:xdmax,ydmin:ydmax,i),  &
  &                (/cmin, cmax/), (/smin, smax/),  &
  &                (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &                c_num=(/10, 10/),  &
  &                viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &                xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind )  !,  &
           end do
        end if
     else
        if(t_anim(1).eqv..false.)then
           do j=1,ny
              do i=1,nt
                 draw_val1(i,j)=val1(xdmin,j,i)
                 draw_val2(i,j)=val2(xdmin,j,i)
              end do
           end do
           call Dcl_2D_cont_shade( trim(draw_title),  &
  &             t(tdmin:tdmax), y(ydmin:ydmax),  &
  &             draw_val1(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val2(tdmin:tdmax,ydmin:ydmax),  &
  &             (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             trigleg='a' )  !,  &
        end if
        if(t_anim(2).eqv..false.)then
           call Dcl_2D_cont_shade( trim(draw_title),  &
  &             x(xdmin:xdmax), t(tdmin:tdmax),  &
  &             val1(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val2(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             trigleg='a' )  !,  &
        end if
        if(t_anim(1).eqv..true..and.t_anim(2).eqv..true.)then
           do i=tdmin,tdmax
              tmp_c=trim(adjustl(i2c_convert(i)))
              call Dcl_2D_cont_shade(  &
  &                trim(draw_title)//'_(tstep='//trim(adjustl(tmp_c))//')"',  &
  &                x(xdmin:xdmax), y(ydmin:ydmax),  &
  &                val1(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val2(xdmin:xdmax,ydmin:ydmax,i),  &
  &                (/cmin, cmax/), (/smin, smax/),  &
  &                (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &                c_num=(/10, 10/),  &
  &                viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &                trigleg='a' )  !,  &
           end do
        end if
     end if
  end if

  if(fig_type==2)then
     if(trim(txtname)/='')then
        if(t_anim(1).eqv..false.)then
           do j=1,ny
              do i=1,nt
                 draw_val1(i,j)=val1(xdmin,j,i)
                 draw_val2(i,j)=val2(xdmin,j,i)
                 draw_val3(i,j)=val3(xdmin,j,i)
                 draw_val4(i,j)=val4(xdmin,j,i)
              end do
           end do
           call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &             t(tdmin:tdmax), y(ydmin:ydmax),  &
  &             draw_val1(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val2(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val3(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val4(tdmin:tdmax,ydmin:ydmax),  &
  &             (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind,  &
  &             unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &             unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        end if
        if(t_anim(2).eqv..false.)then
           call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &             x(xdmin:xdmax), t(tdmin:tdmax),  &
  &             val1(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val2(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val3(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val4(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind,  &
  &             unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &             unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        end if
        if(t_anim(1).eqv..true..and.t_anim(2).eqv..true.)then
           do i=tdmin,tdmax
              tmp_c=trim(adjustl(i2c_convert(i)))
              call Dcl_2D_cont_shade_vec(  &
  &                trim(draw_title)//'_(tstep='//trim(adjustl(tmp_c))//')"',  &
  &                x(xdmin:xdmax), y(ydmin:ydmax),  &
  &                val1(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val2(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val3(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val4(xdmin:xdmax,ydmin:ydmax,i),  &
  &                (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &                (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &                c_num=(/10, 10/),  &
  &                viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &                xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind,  &
  &                unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &                unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
           end do
        end if
     else
        if(t_anim(1).eqv..false.)then
           do j=1,ny
              do i=1,nt
                 draw_val1(i,j)=val1(xdmin,j,i)
                 draw_val2(i,j)=val2(xdmin,j,i)
                 draw_val3(i,j)=val3(xdmin,j,i)
                 draw_val4(i,j)=val4(xdmin,j,i)
              end do
           end do
           call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &             t(tdmin:tdmax), y(ydmin:ydmax),  &
  &             draw_val1(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val2(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val3(tdmin:tdmax,ydmin:ydmax),  &
  &             draw_val4(tdmin:tdmax,ydmin:ydmax),  &
  &             (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             trigleg='a', l_idx=ind,  &
  &             unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &             unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        end if
        if(t_anim(2).eqv..false.)then
           call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &             x(xdmin:xdmax), t(tdmin:tdmax),  &
  &             val1(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val2(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val3(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             val4(xdmin:xdmax,ydmin,tdmin:tdmax),  &
  &             (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &             (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &             c_num=(/10, 10/),  &
  &             viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &             trigleg='a', l_idx=ind,  &
  &             unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &             unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
        end if
        if(t_anim(1).eqv..true..and.t_anim(2).eqv..true.)then
           do i=tdmin,tdmax
              tmp_c=trim(adjustl(i2c_convert(i)))
              call Dcl_2D_cont_shade_vec(  &
  &                trim(draw_title)//'_(tstep='//trim(adjustl(tmp_c))//')"',  &
  &                x(xdmin:xdmax), y(ydmin:ydmax),  &
  &                val1(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val2(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val3(xdmin:xdmax,ydmin:ydmax,i),  &
  &                val4(xdmin:xdmax,ydmin:ydmax,i),  &
  &                (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &                (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &                c_num=(/10, 10/),  &
  &                viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &                trigleg='a', l_idx=ind,  &
  &                unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &                unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
           end do
        end if
     end if
  end if

  call DclCloseGraphics

end program
