module Dcl_Automatic  ! Dclf90 ưǹԤ⥸塼

use dcl

contains

subroutine Dcl_2D_cont_shade( outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg )
  ! 2  2 ѿȥ顼ɤ褹.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  logical :: monoto

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.true.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_MapPro( map_pro, outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, form_typec,  &
  &  form_types, viewx_min, viewx_max, viewy_min,  &
  &  viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg, mlitv )
  ! 2  2 ѿȥ顼ɤ褹.
  !  map_pro Ͽֹ, Ͽƥ⡼ɤڤؤ.
  ! , xg, yg ץϿƤδط, ǽƤʤ.
  use dcl
  implicit none
  integer, intent(in) :: map_pro  ! DCL ϿѴؿֹ
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ [deg]
  real, intent(in) :: y(:)  ! y γʻɸ [deg]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  real, intent(in), optional :: mlitv  ! ᥸㡼饤, ɽֳ [degree]. ǥեȤ 1 degree.
  real, parameter :: pi=3.14159265
  real, parameter :: radius=6.38e6
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: uratio
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  real :: map_lat_min, map_lat_max, map_lon_min, map_lon_max
  real :: mlat2dis_min, mlat2dis_max, mditv
  logical :: monoto

  nx=size(x)
  ny=size(y)

!--  rad ñ̤Ѵ
  map_lon_min=x(1)*pi/180.0
  map_lon_max=x(nx)*pi/180.0
  map_lat_min=y(1)*pi/180.0
  map_lat_max=y(ny)*pi/180.0

  mlat2dis_min=log(tan(0.25*pi+0.5*map_lat_min))
  mlat2dis_max=log(tan(0.25*pi+0.5*map_lat_max))

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

  if(present(mlitv))then
     mditv=mlitv
  else
     mditv=1.0
  end if

!-- ϿȼΥץ ---
!-- MapFit 롼Ѥ, Ͽޤ vp ŪѹΤ,
!-- νԤ.
!-- u ɸϤǤΥڥȤ, ĹĹ vp ˤ,
!-- û vp .
  uratio=(mlat2dis_max-mlat2dis_min)/(map_lon_max-map_lon_min)  ! u ɸϤǤ ratio
  if( uratio>1.0 )then
  ! y ĹΤ, vratio  vxmin, vxmax  0.5 ˽.
  ! ϰʲΤȤ : 
  ! vxmax+vxmin=1.0, vxmax-vxmin=(vymax-vymin)/uratio
  ! 򤽤줾򤯤, vymax, vymin ϴϤʤΤǰΤΤѤ,
  ! vxmax=0.5*(1.0+(vymax-vymin)/uratio)
  ! vxmin=0.5*(1.0-(vymax-vymin)/uratio)
     vx_max=0.5*(1.0+(vy_max-vy_min)/uratio)
     vx_min=0.5*(1.0-(vy_max-vy_min)/uratio)
  else
  ! x ĹΤ, vratio  vymin, vymax  0.5 ˽.
  ! ϰʲΤȤ : 
  ! vymax+vymin=1.0, vymax-vymin=uratio*(vxmax-vxmin)
  ! 򤽤줾򤯤, vxmax, vxmin ϴϤʤΤǰΤΤѤ,
  ! vymax=0.5*(1.0+(uratio*(vxmax-vxmin))
  ! vymin=0.5*(1.0-(uratio*(vxmax-vxmin))
     vy_max=0.5*(1.0+uratio*(vx_max-vx_min))
     vy_min=0.5*(1.0-uratio*(vx_max-vx_min))
  end if

  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetParm( 'MAP:LGRIDMN', .false. )
  call DclSetParm( 'MAP:INDEXMJ', 1 )
  call DclSetParm( 'MAP:dgridmj', mditv )

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber( map_pro )
  call DclFitMapParm
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  call DclSetParm( 'GRAPH:LCLIP', .true. )
!     call DclDrawViewPortFrame( 1 )
  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )

  call DclDrawAxis( 'bt', mditv, 0.5*mditv )
  call DclDrawAxis( 'rl', mditv, 0.5*mditv )
!  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )
  call DclDrawMap( 'coast_world' )
  call DclDrawGlobe()

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_terrain( outname,  &
  &  x, y, grid_point, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg, trn_paint, trn_col, layer_line )
  ! 2  2 ѿȥ顼ɤ褹.
  ! terrain following 
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(in) :: grid_point(size(x),size(y))  ! terrain following ɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: trn_paint  ! Ϸ˿ɤ뤫. [def:.false.]
  integer, intent(in), optional :: trn_col  ! Ϸɤ뿧Υ顼ֹ
  logical, intent(in), optional :: layer_line  ! ؤγʻɽ. [def:.false.]
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS, interc
  logical :: monoto
  real :: cx(size(x),size(y)), cy(size(x),size(y))
  real :: trn(size(x)+2), trn_x(size(x)+2)
  real :: cxmax, cxmin, cymax, cymin
  character(10) :: val_c
  integer :: maxcy, maxcx, trn_color

  nx=size(x)
  ny=size(y)

!-- c ɸϤؤѴ
  do j=1,ny
     do i=1,nx
        cx(i,j)=x(i)
        cy(i,j)=grid_point(i,j)
     end do
  end do

!-- c ɸ϶ͤη׻

  cxmin=x(1)
  cxmax=x(nx)
  cymin=cy(1,1)
  cymax=cy(1,ny)
  do i=2,nx
     if(cymin>cy(i,1))then
        cymin=cy(i,1)
     end if
     if(cymax<cy(i,ny))then
        cymax=cy(i,ny)
     end if
  end do

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

!-- contour  axis Τ,  contour interval ɽʤ
!-- 褦ˤ롼. contour interval .
  call udlset('LMSG',.false.)

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber(51)
  call g2sctr(nx, ny, x, y, cx, cy )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclSetParm('ENABLE_SOFTFILL',.true.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  call uelset('ltone',.true.)

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

!  if(monoto.eqv..true.)then
!     call DclShadeContour( shade )
!  else
     call DclShadeContour( shade )
!  end if

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  call g2qctm( cxmin, cxmax, cymin, cymax )
  call DclSetWindow( cxmin, cxmax, cymin, cymax )
  call DclSetTransNumber(1)
  call DclSetTransFunction

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- Ϸΰ˿ɤ
  if(present(trn_paint))then
     if(trn_paint.eqv..true.)then
        if(present(trn_col))then
           trn_color=trn_col
        else
           trn_color=1999
        end if
        do i=1,nx
           trn(i)=grid_point(i,1)
           trn_x(i)=x(i)
!        if(bot(i)==trn(i))then
!           call DclShadeRegion( )
!        end if
        end do
        trn(nx+1)=cymin
        trn(nx+2)=cymin
        trn_x(nx+1)=x(nx)
        trn_x(nx+2)=x(1)

        call DclShadeRegion( trn_x(1:nx+2), trn(1:nx+2), trn_color)
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
!  call DclDrawContour( contour )

  interc=DclGetContourInterval(1)
  write(*,*) interc
  write(val_c,'(E10.3)') interc

  call DclDrawTitle('b','_CONTOUR INTERVAL ='//val_c//'"',0.0,1)

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if

  if(present(layer_line))then
     if(layer_line.eqv..true.)then
        do i=1,ny
           call DclDrawLine( x, grid_point(:,i) )
        end do
     end if
  end if

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_calendar( outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, date, days,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg )
  ! 2  2 ѿȥ顼ɤ褹. calender б
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  logical :: monoto

  nx=size(x)
  ny=size(y)

!-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if
  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( 0.0, real(days), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec( outname,  &
  &  x, y, contour, shade, vecx, vecy, vnx, vny, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  intrinsic :: nint
  logical :: monoto

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(i,1)=vecx(1+nint(factx*(i-1)),1)
     vm(i,1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,j)=vecx(1,1+nint((j-1)*facty))
     vm(1,j)=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(i,j)=vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec_calendar( outname,  &
  &  x, y, contour, shade, vecx, vecy, vnx, vny, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, date, days,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, mono, mono_val, mono_lev, trigleg )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(6), intent(in) :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in) :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  integer :: i, j, k  ! ź
  integer :: nx, ny, s_num, c_num
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  logical :: monoto

  nx=size(x)
  ny=size(y)

 !-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(i,1)=vecx(1+nint(factx*(i-1)),1)
     vm(i,1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,j)=vecx(1,1+nint((j-1)*facty))
     vm(1,j)=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(i,j)=vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

  if(present(color_num))then
     s_num=color_num
  else
     s_num=56
  end if

  if(present(cont_num))then
     c_num=cont_num
  else
     c_num=10
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( 0.0, real(days), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if

  if(present(trigleg))then
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto, trigle=trigleg )
  else
     call tone_bar( s_num, shade_min, shade_max, vx_max+0.05, vx_max+0.075,   &
  &               vy_min, vy_max, form_types, mono_log=monoto )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL( judge, outname,  &
  &  xline, yline, xpoint, ypoint, x_title, y_title,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max, xmin, xmax, ymin, ymax )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  real, intent(in), optional :: xmin  ! x Υպü
  real, intent(in), optional :: xmax  ! x Υձü
  real, intent(in), optional :: ymin  ! y Υպü
  real, intent(in), optional :: ymax  ! y Υձü
  integer :: i, j, k  ! ź
  integer, parameter :: lim=990  ! 饤󥤥ǥåκ
  integer :: nnum, lstep, pstep, lnum, pnum
  real :: vx_min, vx_max, vy_min, vy_max

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  if(present(xmin))then
     call DclSetWindow( xmin, xmax, ymin, ymax )
  else
     if(judge=='p'.or.judge=='a')then
        do i=1,pnum
           call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
        end do
     end if

     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           call DclScalingPoint( xline(:,j), yline(:,j) )
        end do
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(judge=='p'.or.judge=='a')then
     if(pnum==1)then
        call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
     else
        do i=1,pnum
           call DclDrawMarker( xpoint(:,j), ypoint(:,j), type=j )
        end do
     end if
  end if

  if(judge=='l'.or.judge=='a')then
     if(lnum==1)then
        call DclDrawLine( xline(:,1), yline(:,1) )
     else
        nnum=lim/lnum
        do j=1,lnum
           call DclDrawLine( xline(:,j), yline(:,j), index=(100+nnum*(j-1)+1) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_vec( outname,  &
  &  x, y, xline, yline, xpoint, ypoint,  & 
  &  vecx, vecy, vnx, vny, x_title, y_title,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max )
  ! 2 ʿˤƥ٥ȥʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  real, intent(in) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(in) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  integer :: lstep, pstep, lnum, pnum
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
!-- ٹ
  if(mod(nx,(vnx-1))/=0.or.mod(ny,(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx or ny."
  end if

!-- ٥ȥδְ
  factx=real(nx)/real(vnx-1)
  facty=real(ny)/real(vny-1)

!--  1 Ϥ
     um(1,1)=vecx(1,1)
     vm(1,1)=vecy(1,1)
  do i=2,vnx
     um(i,1)=vecx(int(factx*(i-1)),1)
     vm(i,1)=vecy(int(factx*(i-1)),1)
  end do
  do j=2,vny
     um(1,j)=vecx(1,int((j-1)*facty))
     vm(1,j)=vecy(1,int((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(int(factx*(i-1)),int(facty*(j-1)))
        vm(i,j)=vecy(int(factx*(i-1)),int(facty*(j-1)))
     end do
  end do

!-- ޤ ---

!  call undef_CReSS2Dcl( nx, ny, 1, contour)
!  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(pnum==1)then
     call DclDrawMarker( xpoint(:,1), yline(:,1) )
  else
     do i=1,pnum
        call DclDrawMarker( xpoint(:,j), yline(:,j), type=j )
     end do
  end if

  if(lnum==1)then
     call DclDrawLine( xline(:,1), yline(:,1) )
  else
     do j=1,lnum
        call DclDrawLine( xline(:,j), yline(:,j), index=(90+10*j+1) )
     end do
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_calendar( judge, outname,  &
  &  xline, yline, xpoint, ypoint, x_title, y_title, date, days,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max, xmin, xmax, ymin, ymax )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  real, intent(in), optional :: xmin  ! x Υպü
  real, intent(in), optional :: xmax  ! x Υձü
  real, intent(in), optional :: ymin  ! y Υպü
  real, intent(in), optional :: ymax  ! y Υձü
  integer :: i, j, k  ! ź
  integer, parameter :: lim=990  ! 饤󥤥ǥåκ
  integer :: nnum
  integer :: lstep, pstep, lnum, pnum
  real :: vx_min, vx_max, vy_min, vy_max

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  if(present(xmin))then
     call DclSetWindow( xmin, xmax, ymin, ymax )
  else
     if(judge=='p'.or.judge=='a')then
        do i=1,pnum
           call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
        end do
     end if

     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           call DclScalingPoint( xline(:,j), yline(:,j) )
        end do
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(judge=='p'.or.judge=='a')then
     if(pnum==1)then
        call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
     else
        do i=1,pnum
           call DclDrawMarker( xpoint(:,j), ypoint(:,j), type=j )
        end do
     end if
  end if

  if(judge=='l'.or.judge=='a')then
     if(lnum==1)then
        call DclDrawLine( xline(:,1), yline(:,1) )
     else
        nnum=lim/lnum
        do j=1,lnum
           call DclDrawLine( xline(:,j), yline(:,j), index=(100+nnum*(j-1)+1) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine auto_title( head, time, title, forma, factor, unite )
!  ȯŸ, ưŪ˥դΥȥ
  implicit none
  character(*), intent(in) :: head  ! ȥإå
  integer, intent(in) :: time  ! 
  character(*), intent(inout) :: title  ! 륿ȥ
  character(6), intent(in), optional :: forma  ! ץȤƥեޥå
  integer, intent(in), optional :: factor  ! time factor
  character(*), intent(in), optional :: unite  ! unit
  character(6) :: formb
  character(8) :: tmpname
  integer :: facttime, len_num

  if(present(forma))then
     formb=forma
  else
     formb='(i8.8)'
  end if

  if(present(factor))then
     facttime=time/factor
  else
     facttime=time
  end if

  write(tmpname,formb) facttime

  len_num=len_trim(tmpname)

  if(present(unite))then
     title=trim(head)//'_(t='//tmpname(1:len_num)//trim(unite)//')"'
  else
     title=trim(head)//'_(t='//tmpname(1:len_num)//'[s])"'
  end if

end subroutine

!---------------------------------------------------------

subroutine tone_bar( color_num, shade_min, shade_max, vx_min, vx_max,  &
  &                  vy_min, vy_max, form_types, mono_log, trigle,  &
  &                  tricmin, tricmax, trifact )  ! ˥ȡСư
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ뿧ο
  real, intent(in) :: shade_min  ! Ǿ
  real, intent(in) :: shade_max  ! 
  real, intent(in) :: vx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in) :: vx_max  ! ӥ塼ݡȤ x κ
  real, intent(in) :: vy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in) :: vy_max  ! ӥ塼ݡȤ y κ
  character(6), intent(in) :: form_types  ! ٥եޥå
  logical, intent(in), optional :: mono_log
  character(1), intent(in), optional :: trigle  ! grads ʻѷФɤ
                ! [u] = , [d] = , [a] = ξ, ǥեȤǤʤ
  integer, intent(in), optional :: tricmin  ! üѤ顼ޥåֹ 5 
  integer, intent(in), optional :: tricmax  ! üѤ顼ޥåֹ 5 
                ! οꤵƤʤ, color_setting ǥåȤƤ뿧Ȥ褦ˤ.
  real, intent(in), optional :: trifact  ! ѷι⤵ (դƱĹ 1 ȤƤ factor ܤΨ. ǥեȤ 1.)
  real, parameter :: RMISS=999.0
  integer :: k
  real :: pi(2,color_num+1)
  real :: dp
  real :: coldim1(color_num+1), coldim2(color_num/2+1)
  logical :: monoto  ! Υȡν
  real, dimension(3) :: triux, triuy, tridx, tridy
  real :: factoru, clev1, clev2
  integer :: tricmin_num, tricmax_num
          ! ¿ѷΰλǤ, ѷĺֺɸ狼Ф褤Τ,
          ! ƺɸ 3 ɬ
  real :: vpx_min, vpx_max, vpy_min, vpy_max  ! ºݤˤȤ viewport, trigle ѥХåե.

!-- ץν
  if(present(mono_log))then
     monoto=mono_log
  else
     monoto=.false.
  end if

  if(present(trigle))then
     if(present(trifact))then
        factoru=trifact
     else
        factoru=1.0
     end if

     if(present(tricmin))then
        tricmin_num=tricmin
     else
        CALL DclGetShadeLevel( 1, clev1, clev2, tricmin_num )
        write(*,*) "### downer color is", tricmin_num
     end if

     if(present(tricmax))then
        tricmax_num=tricmax
     else
        CALL DclGetShadeLevel( color_num+2, clev1, clev2, tricmax_num )
        write(*,*) "### upper color is", tricmax_num
     end if

     select case(trigle)
     case('a')
        triux(1)=vx_min
        triux(2)=(vx_max+vx_min)*0.5
        triux(3)=vx_max
        triuy(1)=vy_max-factoru*(vx_max-vx_min)
        triuy(2)=vy_max
        triuy(3)=triuy(1)
        tridx=triux
        tridy(1)=vy_min+factoru*(vx_max-vx_min)
        tridy(2)=vy_min
        tridy(3)=tridy(1)
        vpy_min=tridy(1)
        vpy_max=triuy(1)
     case('u')
        triux(1)=vx_min
        triux(2)=(vx_max+vx_min)*0.5
        triux(3)=vx_max
        triuy(1)=vy_max
        triuy(2)=vy_max+factoru*(vx_max-vx_min)
        triuy(3)=triuy(1)
        vpy_min=vy_min
        vpy_max=triuy(1)
     case('d')
        tridx(1)=vx_min
        tridx(2)=(vx_max+vx_min)*0.5
        tridx(3)=vx_max
        tridy(1)=vy_min
        tridy(2)=vy_min-factoru*(vx_max-vx_min)
        tridy(3)=tridy(1)
        vpy_min=tridy(1)
        vpy_max=vy_max
     end select

     vpx_min=vx_min
     vpx_max=vx_max

  else

     vpx_min=vx_min
     vpx_max=vx_max
     vpy_min=vy_min
     vpy_max=vy_max

  end if

!-- ޤ

  call GRFIG
  call DclSetWindow( 0.0, 1.0, shade_min, shade_max )
  call DclSetViewPort( vpx_min, vpx_max, vpy_min, vpy_max )
  call GRSTRN(1)
  call DclSetTransFunction

  dp = (shade_max-shade_min)/color_num

  do k=1,color_num+1
     PI(1,K) = shade_min + (K-1)*DP
     PI(2,K) = shade_min + (K-1)*DP
  end do

!-- ȡĴ.

  do k=1,color_num+1
     coldim1(k)=PI(1,k)
  end do
  do k=1,color_num/2+1
     coldim2(k)=PI(1,2*k-1)
  end do

  call DclSetXGrid( (/0.0,1.0/) )
  call DclSetYGrid( PI(1,:) )

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclShadeContour( PI )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
     call DclShadeContourEx( PI )
  end if

  CALL SLPVPR( 3 )
  CALL UZLSET( 'LABELYR', .TRUE. )
  CALL UZLSET( 'LABELYL', .FALSE. )
  CALL UYSFMT( form_types )
  CALL UYAXNM( 'R', coldim1, color_num+1, coldim2, color_num/2+1 )
  CALL UYAXNM( 'L', coldim1, color_num+1, coldim2, color_num/2+1 )

!-- ºݤ˻ѷΰ
  if(present(trigle))then
     select case(trigle)
     case('a')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        call DclDrawLineNormalized( triux, triuy, index=13 )
        call DclDrawLineNormalized( tridx, tridy, index=13 )
     case('u')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        call DclDrawLineNormalized( triux, triuy, index=13 )
     case('d')
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        call DclDrawLineNormalized( tridx, tridy, index=13 )
     end select
  end if

!  CALL UYAXDV( 'R', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )
!  CALL UYAXDV( 'L', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )

end subroutine

!-----------------------------------------------------------

subroutine undef_CReSS2Dcl( nx, ny, nz, val )  ! CReSS ̤ͤ Dcl ̤ͤѴ롼
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  use dcl
  implicit none
  integer, intent(in) :: nx  !  1 Ǥǿ
  integer, intent(in) :: ny  !  2 Ǥǿ
  integer, intent(in) :: nz  !  3 Ǥǿ
  real, intent(inout) :: val(nx,ny,nz)  ! Ѵ
  integer :: i, j, k  ! 
  real :: RMISS, undef  ! ̤

!-- »ͽ ---
!-- Dcl ¦ undef ͥå
      CALL GLRGET( 'RMISS', RMISS )
      CALL GLLSET( 'LMISS', .TRUE. )

!-- CReSS ¦ undef ͥå
      call undef_get( undef )
!write(*,*) "undef=", undef

  do k=1,nz
  do j=1,ny
     do i=1,nx
        if(val(i,j,k)==undef)then
           val(i,j,k)=RMISS
        end if
     end do
  end do
  end do
    

end subroutine

!--------------------------------------------------------

subroutine color_setting( color_num, val_min, val_max, col_tab,   &
  &                       col_max, col_min, col_bg, reverse,  &
  &                       min_tab, max_tab )
  ! 顼ޥåפοȿͤб뼫ư롼
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ륫顼μ
  real, intent(in) :: val_min  ! 顼κǾ
  real, intent(in) :: val_max  ! 顼κ
  integer, intent(in), optional :: col_tab  ! dcl Υ顼ơ֥
  integer, intent(in), optional :: col_min  ! Ѥ륫顼ֹκǾ(2)
  integer, intent(in), optional :: col_max  ! Ѥ륫顼ֹκ(2)
  logical, intent(in), optional :: col_bg  ! طʿؤ ǥեȤʤ.
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  logical, intent(in), optional :: reverse  ! 顼ֹȿž.
  integer, intent(in), optional :: min_tab  ! val_min ʲͤб륫顼ֹ, ǥեȤϹ
  integer, intent(in), optional :: max_tab  ! val_max ʾͤб륫顼ֹ, ǥեȤϹ
  integer :: ipat
  real :: dv  ! 顼ޥåפбͤ
  integer :: cmap_min, cmap_max
  real :: tlev1, tlev2
  logical :: rev
  real :: white_min, black_max
  real :: RMISS
  integer :: white, black, ITON

!-- Dcl ¦ undef ͥå
   CALL GLRGET( 'RMISS', RMISS )
   CALL GLLSET( 'LMISS', .TRUE. )

  if(present(col_tab))then
     map_num=col_tab
  else
     map_num=1
  end if

  if(present(col_min))then
     cmap_min=col_min
  else
     cmap_min=14
  end if

  if(present(col_max))then
     cmap_max=col_max
  else
     cmap_max=85
  end if

  if(present(col_bg))then
     call SWpSET( 'LFGBG', col_bg )     
  end if

  if(present(reverse))then
     rev=reverse
  else
     rev=.false.
  end if

  if(present(min_tab))then
     white=min_tab
  else
     white=999
  end if

  if(present(max_tab))then
     black=max_tab
  else
     black=1999
  end if

  call sgscmn(map_num)

  call UEITLV

!-- val_max ʾ black ɤ
  TLEV1=RMISS
  TLEV2=val_min
  IPAT=white
  CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!  CALL UEQTLV( TLEV1, TLEV2, IPAT, color_num+2 )
!  write(*,*) TLEV1, TLEV2, IPAT

  dv=(val_max-val_min)/color_num

  if(rev.eqv..true.)then
     do k=1,color_num
        TLEV1=val_min+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=(cmap_min+int((color_num-k)*(real(cmap_max-cmap_min)/real(color_num-1))))*1000+999
        CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!        CALL UEQTLV( TLEV1, TLEV2, IPAT, k )
!        write(*,*) TLEV1, TLEV2, IPAT
     end do
  else
     do k=1,color_num
        TLEV1=val_min+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=(cmap_min+int((k-1)*(real(cmap_max-cmap_min)/real(color_num-1))))*1000+999
        CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!        CALL UEQTLV( TLEV1, TLEV2, IPAT, k )
!        write(*,*) TLEV1, TLEV2, IPAT
     end do
  end if

  TLEV1=val_max
  TLEV2=RMISS
  IPAT=black
  CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!  CALL UEQTLV( TLEV1, TLEV2, IPAT, color_num+1 )
  write(*,*) TLEV1, TLEV2, IPAT

end subroutine

!---------------------------------------------------

subroutine monotone_setting( ton_tab, val_min, val_max, nega_ton_tab,  &
  &                          full_tone )
! color_setting ΥΥȡС
! ȡơ֥ȴ 5 षʤΤ, val_min, val_max Ū 5 ʬ䤷, ȡƤϤ.
! ޤ, nega_ton_tab ꤵƤ, 10 ʬ䤹.
  use dcl
  implicit none
  integer, intent(in), optional :: ton_tab  ! dcl Υȡơ֥
  real, intent(in) :: val_min  ! 顼κǾ
  real, intent(in) :: val_max  ! 顼κ
  integer, intent(in), optional :: nega_ton_tab  ! ȡơ֥ 2 ȤȤ, ͤξΰ˸äǻƤ˻. Υȡ 0 ǻƤ.
  logical, intent(in), optional :: full_tone  ! 碌, ƥȡ 6 ʳΤ, val_min, val_max κŪ 6 ʬ䤷ƥȡƤ. , 򤹤, ȡζͤڤΤ褤ͤˤʤʤ. ͤ .true. ͭȤʤ.
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  integer :: ipat, itvtone, tone_mapping
  real :: dv  ! 顼ޥåפбͤ
  integer :: cmap_min, cmap_max
  real :: tlev1, tlev2

  call UEITLV

  if(present(nega_ton_tab))then
     if(present(full_tone))then
        if(full_tone.eqv..true.)then
           itvtone=12
        else
           itvtone=10
        end if
     else
        itvtone=10
     end if
  else
     if(present(full_tone))then
        if(full_tone.eqv..true.)then
           itvtone=6
        else
           itvtone=5
        end if
     else
        itvtone=5
     end if
  end if

  dv=(val_max-val_min)/real(itvtone)

  if(itvtone==10.or.itvtone==12)then
     tone_mapping=itvtone/2
  else
     tone_mapping=itvtone
  end if

  if(itvtone==tone_mapping)then
     do k=1,tone_mapping
        TLEV1=val_min+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=100*ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
     end do
  else
     do k=1,tone_mapping
        TLEV1=0.5*(val_max+val_min)+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=100*ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
write(*,*) "tlev", tlev1, tlev2
     end do
     do k=1,tone_mapping
        TLEV1=0.5*(val_max+val_min)-k*dv
        TLEV2=TLEV1+dv
        IPAT=100*nega_ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
write(*,*) "bgtlev", tlev1, tlev2
     end do
  end if


end subroutine

!---------------------------------------------------

subroutine undef_get( undef )  ! CReSS ΥǥեȤ̤ͤ롼
  implicit none
  real, intent(inout) :: undef  ! ̤

  undef = -1.0e+35

end subroutine


subroutine format_make( val_type, order_num, form_name, frac_num )  ! ͥ٥ѥեޥåȺ롼
  implicit none
  character(1), intent(in) :: val_type  ! ٥벽ѿη : f = ¿(ץꤹ), i = 
  character(1), intent(in) :: order_num  ! ɽ
  character(1), intent(in), optional :: frac_num  ! ¿ΤȤΤ, 
  character(*), intent(out) :: form_name

  select case(val_type)
  case('f')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('F')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('i')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  case('I')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  end select

end subroutine format_make

end module
