!-----------------------------------------------------------------------
!     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------
  program g2pk02

  use dcl
  use dcl_Automatic

  integer, parameter :: nx=15, ny=15
  integer :: i, j

  real :: ux(nx), uy(ny)
  real :: uyw(nx), uxw(ny)
  real :: cx(nx,ny), cy(nx,ny)
  real :: z(nx,ny)
  real :: terrain(nx)
  real :: interc
  character(10) :: val_c

!     / set parameters /

!      call glrget('rundef',rundef)
!      call udlset('LMSG',.false.)

  call color_setting( 10, 0.0, 1.0, col_tab=14 )

      do 10 i=1,nx
        ux(i)=(i-1.0)/(nx-1.0) - 0.5
        terrain(i) = 0.1 * exp(-24*ux(i)**2)
   10 continue
      do 15 j=1,ny
        uy(j)=(j-1.0)/(ny-1.0)
   15 continue

!      cx(1,1) = rundef
      do 25 j=1,ny
        do 20 i=1,nx
          cx(i,j) = ux(i)
          cy(i,j) = uy(j)*(1.0-terrain(i)) + terrain(i)
   20   continue
   25 continue

!     / tone /

      do 35 j=1,ny
        do 30 i=1,nx
          z(i,j) = 1-uy(j)
!          z(i,j) = ux(i) * (1-uy(j))
   30   continue
   35 continue

!     / graphic /

      call DclOpenGraphics()
!      call DclNewFrame
!      call DclSetViewPort(0.15,0.85,0.15,0.85)
!      call DclSetWindow(ux(1),ux(nx),uy(1),uy(ny))
!      call DclSetTransNumber(51)
!      call g2sctr(nx, ny, ux,uy, cx,cy)
!      call DclSetTransFunction

!call DclSetParm('ENABLE_SOFTFILL',.true.)
!      call uelset('ltone',.true.)
!      call DclSetXGrid( ux )
!      call DclSetYGrid( uy )

!      call uetonf(z, nx, nx, ny)
!      call DclShadeContour(z)
!      call DclDrawContour(z)

!-- 
!      do 45 j=1,ny
!        do 40 i=1,nx
!          uyw(i) = uy(j)
!   40   continue
!        call sgplu(nx,ux,uyw)
!   45 continue

!      do 55 i=1,nx
!        do 50 j=1,ny
!          uxw(j) = ux(i)
!   50   continue
!        call sgplu(ny,uxw,uy)
!   55 continue

!     / axes  (switch to itr==1) /

!      call g2qctm(cxmin, cxmax, cymin, cymax)
!      call DclSetWindow(cxmin,cxmax,cymin,cymax)
!      call DclSetTransNumber(1)
!      call DclSetTransFunction
!      call DclDrawScaledAxis
!      call DclDrawTitle('t','terrain following',0.0,1)

!      interc=DclGetContourInterval(1)
!      write(*,*) interc
!      write(val_c,'(E10.3)') interc

!      call DclDrawTitle('b','_CONTOUR INTERVAL ='//val_c//'"',0.0,1)

      call Dcl_2d_cont_shade( 'terrain following', ux, uy,  &
  &   z, z, 0.0, 1.0, 0.0, 1.0, 'horizon', 'vertical', '(f6.1)', '(f6.1)', &
  &   color_num=10 )

      call DclCloseGraphics

      end
