!= Nakajima et al. (1992) Ѥ˰漾λ
!
!= Evaluate saturation specific humidity with Nakajima et al. (1992)
!
! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA
! Version::   $Id: saturate_nha1992.F90,v 1.2 2008-11-23 15:08:26 morikawa Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_nha1992
  !
  != Nakajima et al. (1992) Ѥ˰漾λ
  !
  != Evaluate saturation specific humidity with Nakajima et al. (1992)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Nakajima et al. (1992) Ѥ줿˰¾ $ p^{*} $ ˴ؤʲμ
  ! Ѥ, ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a folloing formula for saturation watar vapor pressure 
  ! $ p^{*} $ in Nakajima et al. (1992). 
  ! 
  ! \[
  !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right). 
  ! \]
  !
  ! , $ T $ ϲ, $ R $ ׵Ǥ. 
  ! $ R $ Ǯ $ l $ , 
  ! ˰¶ $ p_0^{*} $ ϰʲΤ褦Ϳޤ. 
  !
  ! where $ T $ is temperature, $ R $ is the gas constant. 
  ! $ R $ and latent heat $ l $ , 
  ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
  ! 
  ! * $ R = 8.314 $ [J mol-1 K-1]
  ! * $ l = 43655 $ [J mol-1]
  ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
  !
  ! ˰¿˰漾 $ q^{*} $ ݤˤ, ʲμѤޤ. 
  !
  ! Saturation specific humidity $ q^{*} $ is calculated from 
  ! saturation watar vapor pressure as follows.
  !
  ! \[
  !    q^{*} (T, p) = \varepsilon \frac{p^{*} (T)}{p}
  ! \]
  !
  !  $ \varepsilon $ ϶ŷʬ絤ʬ, 
  ! $ p $ ϵǤ. 
  !
  ! where $ \varepsilon $ is molecular weight ratio of water vapor to air, 
  ! $ p $ is air pressure. 
  ! 
  ! ä, ˰漾, ˰漾βѲ뼰ϰʲΤ褦
  ! ʤޤ. 
  !
  ! Therefore, saturation specific humidity and temperature derivative of it 
  ! are calculated as follows. 
  !
  ! \[
  !    q^{*} (T, p) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
  !    \DP{q^{*} (T, p)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right) 
  !    = q^{*} \frac{l}{RT^2}
  ! \]
  !
  !== References
  !
  ! * Nakajima, S., Hayashi, Y.-Y., Abe, Y., 1992: 
  !   A study on the "runaway greenhouse effect" with a 
  !   one dimensional radiative convective equilibrium model. 
  !   <i>J. Atmos. Sci.</i>, <b>49</b>, 2256--2266.
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_nha1992_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: CalcQVapSat, CalcDQVapSatDTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_nha1992_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate_nha1992'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: saturate_nha1992.F90,v 1.2 2008-11-23 15:08:26 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  function CalcQVapSat( Temp, Press ) result( QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &           ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . Air pressure
    real(DP):: QVapSat
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ˰漾׻Τʸؿ (CalcQVapSatSF, CalcDQVapSatDTempSF)
    ! Declaration of statement function for 
    !   calculation of saturation specific humidity 
    !   ("CalcQVapSatSF", "CalcDQVapSatDTempSF")
    !
#include "../saturate/saturate_nha1992_sf.f90"
    EpsVSF     = EpsV
    GasRUnivSF = GasRUniv

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    ! CalcQVapSatSF ʸؿ. (¹ʸľ)
    ! "CalcQVapSatSF" is statement function and 
    !   is declared just before executable statement. 
    ! 
    QVapSat = CalcQVapSatSF( Temp, Press )

  end function CalcQVapSat

  !-------------------------------------------------------------------

  function CalcDQVapSatDTemp( Temp, QVapSat ) result( DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &           ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: QVapSat
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: DQVapSatDTemp
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ˰漾׻Τʸؿ (CalcQVapSatSF, CalcDQVapSatDTempSF)
    ! Declaration of statement function for 
    !   calculation of saturation specific humidity 
    !   ("CalcQVapSatSF", "CalcDQVapSatDTempSF")
    !
#include "../saturate/saturate_nha1992_sf.f90"
    EpsVSF     = EpsV
    GasRUnivSF = GasRUniv

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾βʬη׻
    ! Calculate temperature derivative of saturation specific humidity
    !
    ! CalcDQVapSatDTempSF ʸؿ. (¹ʸľ)
    ! "CalcDQVapSatDTempSF" is statement function and 
    !   is declared just before executable statement. 
    ! 
    DQVapSatDTemp = CalcDQVapSatDTempSF( Temp, QVapSat )

  end function CalcDQVapSatDTemp

  !-------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate_nha1992 ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_nha1992_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_nha1992" module is initialized. 
    !--
    ! "NAMELIST#saturate_nha1992_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_nha1992_nml/ 
          !
          ! ǥեͤˤĤƤϽ³ "saturate_nha1992#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_nha1992#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_nha1992_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_nha1992_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
    saturate_nha1992_inited = .true.
  end subroutine SaturateInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

  end subroutine InitCheck

end module saturate_nha1992
