!= ľȻեå (Mellor and Yamada, 1974)
!
!= Vertical diffusion flux (Mellor and Yamada, 1974)
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: vdiffusion_my1974.f90,v 1.22 2010-02-24 08:14:42 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module vdiffusion_my1974
  !
  != ľȻեå (Mellor and Yamada, 1974)
  !
  != Vertical diffusion flux (Mellor and Yamada, 1974)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ľȻեå׻ޤ. 
  !
  ! Vertical diffusion flux is calculated. 
  !
  !== Procedures List
  ! 
  ! VDiffusion       :: ľȻեåη׻
  ! VDiffusionOutPut :: եåν
  ! ------------     :: ------------
  ! VDiffusion       :: Calculate vertical diffusion fluxes
  ! VDiffusionOutPut :: Output fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#vdiffusion_my1974_nml
  !

  ! ⥸塼 ; USE statements
  !
  !== References
  !
  ! * Mellor, G. L, Yamada, T., 1974: 
  !   A hierarchy of turbulence closure models for 
  !   planetary boundary layers. 
  !   <i>J. Atmos. Sci.</i>, <b>31</b>, 1791--1806.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: ncmax, IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: VDiffusion, VDiffExp, VDiffusionOutPut

  ! ѿ
  ! Public variables
  !
  logical, save, public:: vdiffusion_my1974_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !


  ! ľȻեåФΤѿ
  ! Variables for calculation of vertical diffusion flux
  !
  logical , save:: FlagConstDiffCoef
                              ! Flag for use of constant diffusion coefficient
  real(DP), save:: ConstDiffCoefM
                              ! Diffusion coefficient for momentum that is used in the
                              ! case of FlagConstDiffCoef == .true.
  real(DP), save:: ConstDiffCoefH
                              ! Diffusion coefficient for heat that is used in the
                              ! case of FlagConstDiffCoef == .true.
  real(DP), save:: SquareVelMin
                              ! 躹Ǿ. 
                              ! Minimum value of square of velocity
  real(DP), save:: BulkRiNumMin
                              ! Х륯 $ R_i $ Ǿ. 
                              ! Minimum value of bulk $ R_i $

  ! ȻФΤѿ
  ! Veriables for calculation of diffusion coefficients
  !
  real(DP), save:: MixLengthMax
                              ! 纮Υ. 
                              ! Maximum mixing length
  real(DP), save:: TildeShMin
                              ! $ \tilde{S_h} $ Ǿ. 
                              ! Minimum $ \tilde{S_h} $
  real(DP), save:: TildeSmMin
                              ! $ \tilde{S_m} $ Ǿ. 
                              ! Minimum $ \tilde{S_m} $
  real(DP), save:: VelDiffCoefMin
                              ! $ \Dvect{u} $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ \Dvect{u} $
  real(DP), save:: TempDiffCoefMin
                              ! $ T $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ T $
  real(DP), save:: QMixDiffCoefMin
                              ! $ q $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ q $
  real(DP), save:: VelDiffCoefMax
                              ! $ \Dvect{u} $ Ȼ. 
                              ! Maximum diffusion coefficient of $ \Dvect{u} $
  real(DP), save:: TempDiffCoefMax
                              ! $ T $ Ȼ. 
                              ! Maximum diffusion coefficient of $ T $
  real(DP), save:: QMixDiffCoefMax
                              ! $ q $ Ȼ. 
                              ! Maximum diffusion coefficient of $ q $

  ! Mellor Yamada Level 2 
  ! Constants for Mellor Yamada Level 2
  !
  real(DP), save:: MYLv2ParamA1
  real(DP), save:: MYLv2ParamB1
  real(DP), save:: MYLv2ParamA2
  real(DP), save:: MYLv2ParamB2
  real(DP), save:: MYLv2ParamC1


  character(*), parameter:: module_name = 'vdiffusion_my1974'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: vdiffusion_my1974.f90,v 1.22 2010-02-24 08:14:42 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface VDiffusion
    module procedure VDiffusion
  end interface

contains

  subroutine VDiffusion(                                   &
    & xyz_U,      xyz_V,      xyzf_QMix,                   & ! (in)
    & xyz_Temp,   xyr_Temp,   xyr_Press, &                  ! (in)
    & xy_SurfHeight,                                       & ! (in)
    & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner, &       ! (in)
    & xyr_UFlux,  xyr_VFlux,  xyr_TempFlux, xyrf_QMixFlux, & ! (out)
    & xyr_VelTransCoef, xyr_TempTransCoef, &                ! (out)
    & xyr_QMixTransCoef                                    & ! (out)
    & )
    !
    ! ľȻեå׻ޤ. 
    !
    ! Vertical diffusion flux is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & FKarm, &
                              ! $ k $ .
                              ! ޥ. 
                              ! Karman constant
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .   ̺. Mass mixing ratio
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(in):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xy_SurfHeight (0:imax-1,1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
                              !  (٥). 
                              ! Height (full level)
    real(DP), intent(in):: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
                              !  (Ⱦ٥). 
                              ! Height (half level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    real(DP), intent(out):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(out):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(out):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! ̥եå. 
                              ! Mass flux of compositions
    real(DP), intent(out):: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP), intent(out):: xyr_TempTransCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(out):: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: mass (composition)

    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_DVelDz (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \DD{|\Dvect{v}|}{z} $
    real(DP):: xyr_BulkRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $
    real(DP):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼư. 
                              ! Diffusion coefficient: velocity
    real(DP):: xyr_TempDiffCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ. 
                              ! Transfer coefficient: temperature
    real(DP):: xyr_QMixDiffCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ漾. 
                              ! Diffusion coefficient: specific humidity

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VDiffInit


    ! Ȼη׻
    ! Calculation of diffusion coefficient
    !
    if ( FlagConstDiffCoef ) then

      xyr_VelDiffCoef (:,:,0       ) = 0.0d0
      xyr_VelDiffCoef (:,:,1:kmax-1) = ConstDiffCoefM
      xyr_VelDiffCoef (:,:,kmax    ) = 0.0d0

      xyr_TempDiffCoef(:,:,0       ) = 0.0d0
      xyr_TempDiffCoef(:,:,1:kmax-1) = ConstDiffCoefH
      xyr_TempDiffCoef(:,:,kmax    ) = 0.0d0

      xyr_QMixDiffCoef(:,:,0       ) = 0.0d0
      xyr_QMixDiffCoef(:,:,1:kmax-1) = ConstDiffCoefH
      xyr_QMixDiffCoef(:,:,kmax    ) = 0.0d0

    else

      ! Х륯 $ R_i $ 
      ! Calculate bulk $ R_i $
      !
      xyr_DVelDz(:,:,0)       = 0.
      xyr_DVelDz(:,:,kmax)    = 0.
      xyr_BulkRiNum(:,:,0)    = 0.
      xyr_BulkRiNum(:,:,kmax) = 0.

      do k = 1, kmax-1
        xyr_DVelDz(:,:,k) = &
          &  sqrt( max( SquareVelMin , &
          &             ( xyz_U(:,:,k+1) - xyz_U(:,:,k) )**2 &
          &           + ( xyz_V(:,:,k+1) - xyz_V(:,:,k) )**2 &
          &           )    &
          &      ) &
          &  / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )

        xyr_BulkRiNum(:,:,k) = &
          &  Grav / ( xyr_Temp(:,:,k) / xyr_Exner(:,:,k) ) &
          &  * (   xyz_Temp(:,:,k+1) / xyz_Exner(:,:,k+1)   &
          &      - xyz_Temp(:,:,k)   / xyz_Exner(:,:,k)   ) &
          &  / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) ) &
          &  / xyr_DVelDz(:,:,k)**2

        xyr_BulkRiNum(:,:,k) = max( xyr_BulkRiNum(:,:,k) , BulkRiNumMin )
      end do

      ! Ȼη׻
      ! Calculate diffusion coefficients
      !
      call VDiffCoefficient(                                  &
        & xy_SurfHeight,                                      & ! (in)
        & xyr_Height, xyr_DVelDz, xyr_BulkRiNum,              & ! (in)
        & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef & ! (out)
        & )

    end if

    ! ѱή
    ! Shallow cumulus convection
    !
    ! (AGCM5 Ƴͽ)


    ! Ȼν
    ! Output diffusion coefficients
    !
    ! (嵭ΡѱήƳ˺)

    ! Ȼ
    ! Diffusion coeffficients output
    !
    call HistoryAutoPut( TimeN, 'VelDiffCoef',  xyr_VelDiffCoef  )
    call HistoryAutoPut( TimeN, 'TempDiffCoef', xyr_TempDiffCoef )
    call HistoryAutoPut( TimeN, 'QVapDiffCoef', xyr_QMixDiffCoef )


    ! ͢η׻
    ! Calculate transfer coefficient
    !
    xyr_VelTransCoef (:,:,0)    = 0.
    xyr_VelTransCoef (:,:,kmax) = 0.
    xyr_TempTransCoef(:,:,0)    = 0.
    xyr_TempTransCoef(:,:,kmax) = 0.
    xyr_QMixTransCoef(:,:,0)    = 0.
    xyr_QMixTransCoef(:,:,kmax) = 0.

    do k = 1, kmax-1
      xyr_VelTransCoef(:,:,k) = &
        &                 xyr_VelDiffCoef(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )

      xyr_TempTransCoef(:,:,k) = &
        &                 xyr_TempDiffCoef(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )

      xyr_QMixTransCoef(:,:,k) = &
        &                 xyr_QMixDiffCoef(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_Height(:,:,k+1) - xyz_Height(:,:,k) )
    end do

    ! եåη׻
    ! Calculate fluxes
    !
    xyr_UFlux(:,:,0)       = 0.
    xyr_UFlux(:,:,kmax)    = 0.
    xyr_VFlux(:,:,0)       = 0.
    xyr_VFlux(:,:,kmax)    = 0.
    xyr_TempFlux(:,:,0)    = 0.
    xyr_TempFlux(:,:,kmax) = 0.
    do n = 1, ncmax
      xyrf_QMixFlux(:,:,0,n)    = 0.
      xyrf_QMixFlux(:,:,kmax,n) = 0.
    end do

    do k = 1, kmax-1
      xyr_UFlux(:,:,k) =   &
        & - xyr_VelTransCoef(:,:,k) * ( xyz_U(:,:,k+1) - xyz_U(:,:,k) )

      xyr_VFlux(:,:,k) =   &
        & - xyr_VelTransCoef(:,:,k) * ( xyz_V(:,:,k+1) - xyz_V(:,:,k) )

      xyr_TempFlux(:,:,k) = &
        & - CpDry * xyr_TempTransCoef(:,:,k) * xyr_Exner(:,:,k) &
        &   * (   xyz_Temp(:,:,k+1) / xyz_Exner(:,:,k+1) &
        &       - xyz_Temp(:,:,k)   / xyz_Exner(:,:,k)     )
    end do

    do n = 1, ncmax
      do k = 1, kmax-1
        xyrf_QMixFlux(:,:,k,n) = &
          & - xyr_QMixTransCoef(:,:,k) &
          &   * ( xyzf_QMix(:,:,k+1,n) - xyzf_QMix(:,:,k,n)  )
      end do
    end do

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine VDiffusion

  !-------------------------------------------------------------------

  subroutine VDiffCoefficient(                            &
    & xy_SurfHeight,                                      & ! (in)
    & xyr_Height, xyr_DVelDz, xyr_BulkRiNum,              & ! (in)
    & xyr_VelDiffCoef, xyr_TempDiffCoef, xyr_QMixDiffCoef & ! (out)
    & )
    !
    ! ľȻեå׻ޤ. 
    !
    ! Vertical diffusion flux is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & FKarm
                              ! $ k $ .
                              ! ޥ. 
                              ! Karman constant

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_SurfHeight (0:imax-1,1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(in):: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
                              !  (Ⱦ٥). 
                              ! Height (half level)
    real(DP), intent(in):: xyr_DVelDz (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \DD{|\Dvect{v}|}{z} $
    real(DP), intent(in):: xyr_BulkRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $
    real(DP), intent(out):: xyr_VelDiffCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(out):: xyr_TempDiffCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ. 
                              ! Transfer coefficient: temperature
    real(DP), intent(out):: xyr_QMixDiffCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ
                              ! Diffusion coefficient: mass of constituents



    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_FluxRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! եå $ R_i $ . 
                              ! Flux $ R_i $ number
    real(DP):: xyr_TildeSh (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \tilde{S_h} $ (, 漾). 
                              ! $ \tilde{S_h} $ (temperature, specific humidity)
    real(DP):: xyr_TildeSm (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \tilde{S_m} $ (ư). 
                              ! $ \tilde{S_m} $ (momentum)
    real(DP):: xyr_MixLength (0:imax-1, 1:jmax, 0:kmax)
                              ! Υ. 
                              ! Mixing length

    real(DP):: Alpha1, Alpha2
    real(DP):: Beta1, Beta2, Beta3, Beta4
    real(DP):: Gamma1, Gamma2
    real(DP):: CrtlFluxRiNum

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VDiffInit

    ! ׻
    ! Calculate constants
    !
    Gamma1 = ( 1. / 3. ) - ( 2. * MYLv2ParamA1 / MYLv2ParamB1 )
    Gamma2 =   ( MYLv2ParamB2 / MYLv2ParamB1 ) &
      &      + ( 6. * MYLv2ParamA1 / MYLv2ParamB1 )
    Alpha1 = 3.  * MYLv2ParamA2 * Gamma1
    Alpha2 = 3.  * MYLv2ParamA2 * ( Gamma1 + Gamma2 )
    Beta1  = MYLv2ParamA1 * MYLv2ParamB1 * ( Gamma1 - MYLv2ParamC1 )
    Beta2  = MYLv2ParamA1 &
      &      * (   MYLv2ParamB1 * ( Gamma1 - MYLv2ParamC1 ) &
      &          + 6. * MYLv2ParamA1 &
      &          + 3. * MYLv2ParamA2 )
    Beta3  = MYLv2ParamA2 * MYLv2ParamB1 * Gamma1
    Beta4  = MYLv2ParamA2 * (   MYLv2ParamB1 * ( Gamma1 + Gamma2 ) &
      &                       - 3. * MYLv2ParamA1 )
    CrtlFluxRiNum = Gamma1 / ( Gamma1 + Gamma2 )

    ! եå $ R_i $ λ
    ! Calculate flux $ R_i $ number
    !
    xyr_FluxRiNum = &
      & (   Beta1 &
      &   + Beta4 * xyr_BulkRiNum &
      &   - sqrt(   ( Beta1 + Beta4 * xyr_BulkRiNum )**2 &
      &           - 4. * Beta2 * Beta3 * xyr_BulkRiNum &
      &         ) &
      & ) / ( 2. * Beta2 )
 
    ! $ \tilde{S_h} $  $ \tilde{S_m} $ λ
    ! Calculate $ \tilde{S_h} $ and $ \tilde{S_m} $
    !
    xyr_TildeSh(:,:,kmax) = 0.
    xyr_TildeSm(:,:,kmax) = 0.
    
    do k = 0, kmax-1
      do i = 0, imax-1
        do j = 1, jmax
          
          if ( xyr_FluxRiNum(i,j,k) < CrtlFluxRiNum ) then 
            
            xyr_TildeSh(i,j,k) = &
              &   (   Alpha1 - Alpha2 * xyr_FluxRiNum(i,j,k) ) &
              &   / ( 1. - 1. * xyr_FluxRiNum(i,j,k) )

            xyr_TildeSm(i,j,k) = &
              &   (   Beta1 - Beta2 * xyr_FluxRiNum(i,j,k) ) &
              &   / ( Beta3 - Beta4 * xyr_FluxRiNum(i,j,k) ) &
              &   * xyr_TildeSh(i,j,k)

            xyr_TildeSh(i,j,k) = max( xyr_TildeSh(i,j,k), TildeShMin )
            xyr_TildeSm(i,j,k) = max( xyr_TildeSm(i,j,k), TildeSmMin )
            
          else
            
            xyr_TildeSh(i,j,k) = TildeShMin
            xyr_TildeSm(i,j,k) = TildeSmMin
            
          end if
          
        end do
      end do
    end do
    
    
    ! Υλ
    ! Calculate mixing length
    !
    do k = 0, kmax
      xyr_MixLength(:,:,k) = &
        & FKarm * ( xyr_Height(:,:,k) - xy_SurfHeight(:,:) ) &
        & / (1. + FKarm * ( xyr_Height(:,:,k) - xy_SurfHeight(:,:) ) / MixLengthMax )
    end do

    ! Ȼλ
    ! Calculate diffusion constants
    !
    xyr_VelDiffCoef = &
      &   xyr_MixLength**2 &
      &   * xyr_DVelDz &
      &   * sqrt ( MYLv2ParamB1 * ( 1. - xyr_FluxRiNum ) * xyr_TildeSm ) &
      &   * xyr_TildeSm

    xyr_TempDiffCoef = &
      &   xyr_MixLength ** 2 &
      &   * xyr_DVelDz &
      &   * sqrt ( MYLv2ParamB1 * ( 1. - xyr_FluxRiNum ) * xyr_TildeSm ) &
      &   * xyr_TildeSh

    xyr_QMixDiffCoef = xyr_TempDiffCoef

    do k = 0, kmax-1
      do i = 0, imax-1
        do j = 1, jmax
          xyr_VelDiffCoef(i,j,k) = &
            & max( min( xyr_VelDiffCoef(i,j,k), VelDiffCoefMax ), &
            &      VelDiffCoefMin &
            &    )
          xyr_TempDiffCoef(i,j,k) = &
            & max( min( xyr_TempDiffCoef(i,j,k), TempDiffCoefMax ), &
            &      TempDiffCoefMin &
            &    )
          xyr_QMixDiffCoef(i,j,k) = &
            & max( min( xyr_QMixDiffCoef(i,j,k), QMixDiffCoefMax ), &
            &      QMixDiffCoefMin &
            &    )
        end do
      end do
    end do

    xyr_VelDiffCoef (:,:,0)    = 0.
    xyr_VelDiffCoef (:,:,kmax) = 0.
    xyr_TempDiffCoef(:,:,0)    = 0.
    xyr_TempDiffCoef(:,:,kmax) = 0.
    xyr_QMixDiffCoef(:,:,0)    = 0.
    xyr_QMixDiffCoef(:,:,kmax) = 0.

  end subroutine VDiffCoefficient

  !-------------------------------------------------------------------

  subroutine VDiffExp(                           &
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyrf_QMixFlux, & ! (in)
    & xyr_Press,                                         & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt      & ! (out)
    & )
    !
    ! ѲΨη׻Ԥޤ.
    !
    ! Calculate tendencies.
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & CpDry
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå.
                              ! Eastward wind flux
    real(DP), intent(in):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå.
                              ! Northward wind flux
    real(DP), intent(in):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå.
                              ! Temperature flux
    real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! 漾եå.
                              ! Specific humidity flux
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥).
                              ! Air pressure (half level)
    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ.
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ.
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ.
                              ! Temperature tendency
    real(DP), intent(out):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ . ̺Ѳ.
                              ! Mass mixing ratio tendency

    ! ѿ
    ! Work variables
    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VDiffInit


    do k = 1, kmax
      xyz_DUDt(:,:,k) =                                      &
        & + Grav * ( xyr_UFlux(:,:,k) - xyr_UFlux(:,:,k-1) ) &
        &        / ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) )
      xyz_DVDt(:,:,k) =                                      &
        & + Grav * ( xyr_VFlux(:,:,k) - xyr_VFlux(:,:,k-1) ) &
        &        / ( xyr_Press(:,:,k) - xyr_Press(:,:,k-1) )
      xyz_DTempDt(:,:,k) =                                         &
        & + Grav / CpDry                                           &
        &        * ( xyr_TempFlux(:,:,k) - xyr_TempFlux(:,:,k-1) ) &
        &        / ( xyr_Press   (:,:,k) - xyr_Press   (:,:,k-1) )
    end do

    do n = 1, ncmax
      do k = 1, kmax
        xyzf_DQMixDt(:,:,k,n) =                                            &
          & + Grav * ( xyrf_QMixFlux(:,:,k,n) - xyrf_QMixFlux(:,:,k-1,n) ) &
          &        / ( xyr_Press    (:,:,k)   - xyr_Press    (:,:,k-1)   )
      end do
    end do


  end subroutine VDiffExp

  !-------------------------------------------------------------------

  subroutine VDiffusionOutPut(                    &
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyrf_QMixFlux, & ! (in)
    & xyz_DUDt,  xyz_DVDt,  xyz_DTempDt,  xyzf_DQMixDt,  & ! (in)
    & xyz_Exner, xyr_Exner, &                             ! (in)
    & xyr_VelTransCoef, xyr_TempTransCoef, &              ! (in)
    & xyr_QMixTransCoef                                  & ! (in)
    & )
    !
    ! եå (xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyrf_QMixFlux). 
    ! ˤĤ, ¾ΰѤ, ϤԤ. 
    !
    ! Fluxes (xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyrf_QMixFlux) are
    ! corrected by using other arguments, and the corrected values are output.
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(in):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(in):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! ̥եå. 
                              ! Mass flux of constituents
    real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ . Ѳ. 
                              ! Mass mixing ratio tendency
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)
    real(DP), intent(in):: xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP), intent(in):: xyr_TempTransCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: mass of constituents

    ! ϤΤκѿ
    ! Work variables for output
    !
    real(DP):: xyr_UFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP):: xyr_VFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP):: xyr_TempFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! ̥եå. 
                              ! Mass flux of constituents


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents
    real(DP):: LCp
                              ! $ L / C_p $ [K]. 

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VDiffInit

    ! ®, , 漾եå
    ! Correct fluxes of wind, temperature, specific humidity
    !
    LCp = LatentHeat / CpDry

    do k = 1, kmax-1
      do j = 1, jmax
        do i = 0, imax-1

          xyr_UFluxCor( i,j,k ) = xyr_UFlux( i,j,k ) & 
            & + ( xyz_DUDt( i,j,k ) - xyz_DUDt( i,j,k+1 ) ) &
            &       * xyr_VelTransCoef( i,j,k ) * DelTime

          xyr_VFluxCor( i,j,k ) = xyr_VFlux( i,j,k ) & 
            & + ( xyz_DVDt( i,j,k ) - xyz_DVDt( i,j,k+1 ) ) &
            &       * xyr_VelTransCoef( i,j,k ) * DelTime

          xyr_TempFluxCor( i,j,k ) = xyr_TempFlux( i,j,k ) &
            & + (   xyz_DTempDt( i,j,k   ) / xyz_Exner( i,j,k   ) &
            &     - xyz_DTempDt( i,j,k+1 ) / xyz_Exner( i,j,k+1 ) &
            &   ) * CpDry * xyr_TempTransCoef( i,j,k ) &
            &     * xyr_Exner( i,j,k ) * DelTime
        end do
      end do
    end do

    do n = 1, ncmax
      do k = 1, kmax-1
        do j = 1, jmax
          do i = 0, imax-1
            xyrf_QMixFluxCor( i,j,k,n ) = xyrf_QMixFlux( i,j,k,n ) &
              & + ( xyzf_DQMixDt( i,j,k,n ) - xyzf_DQMixDt( i,j,k+1,n ) ) &
              &       * CpDry * xyr_QMixTransCoef( i,j,k ) * LCp * DelTime
          end do
        end do
      end do
    end do

    xyr_UFluxCor      (:,:,0)    = 0.
    xyr_UFluxCor      (:,:,kmax) = 0.
    xyr_VFluxCor      (:,:,0)    = 0.
    xyr_VFluxCor      (:,:,kmax) = 0.
    xyr_TempFluxCor   (:,:,0)    = 0.
    xyr_TempFluxCor   (:,:,kmax) = 0.
    do n = 1, ncmax
      xyrf_QMixFluxCor(:,:,0,n)    = 0.
      xyrf_QMixFluxCor(:,:,kmax,n) = 0.
    end do

!!$    write( 6, * ) 'MEMO: Output values of surface fluxes in UFlux, VFlux, TempFlux, QVapFlux are not correct. (YOT, 2009/08/14)'

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'UFlux',    xyr_UFluxCor     )
    call HistoryAutoPut( TimeN, 'VFlux',    xyr_VFluxCor     )
    call HistoryAutoPut( TimeN, 'TempFlux', xyr_TempFluxCor  )
    call HistoryAutoPut( TimeN, 'QVapFlux', xyrf_QMixFluxCor )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine VDiffusionOutPut

  !-------------------------------------------------------------------

  subroutine VDiffInit
    !
    ! vdiffusion_my1974 ⥸塼νԤޤ. 
    ! NAMELIST#vdiffusion_my1974_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "vdiffusion_my1974" module is initialized. 
    ! "NAMELIST#vdiffusion_my1974_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /vdiffusion_my1974_nml/    &
      & FlagConstDiffCoef,              &
      & ConstDiffCoefM, ConstDiffCoefH, &
!
      & SquareVelMin, BulkRiNumMin,     &
!
      & MixLengthMax, TildeShMin, TildeSmMin, &
      & VelDiffCoefMin, TempDiffCoefMin, QMixDiffCoefMin, &
      & VelDiffCoefMax, TempDiffCoefMax, QMixDiffCoefMax, &
!
      & MYLv2ParamA1, MYLv2ParamB1, MYLv2ParamA2, MYLv2ParamB2, MYLv2ParamC1
          !
          ! ǥեͤˤĤƤϽ³ "vdiffusion_my1974#VDiffInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "vdiffusion_my1974#VDiffInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( vdiffusion_my1974_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    FlagConstDiffCoef = .false.
    ConstDiffCoefM    = 0.0d0
    ConstDiffCoefH    = 0.0d0

    SquareVelMin    =     0.1
    BulkRiNumMin    = - 100.

    MixLengthMax    = 300.
    TildeShMin      =   0.
    TildeSmMin      =   0.
    VelDiffCoefMin  =   0.1
    TempDiffCoefMin =   0.1
    QMixDiffCoefMin =   0.1
    VelDiffCoefMax  = 10000.
    TempDiffCoefMax = 10000.
    QMixDiffCoefMax = 10000.

    ! Parameters proposed by Mellor and Yamada (1982).
    !
    MYLv2ParamA1 =  0.92
    MYLv2ParamB1 = 16.6
    MYLv2ParamA2 =  0.74
    MYLv2ParamB2 = 10.1
    MYLv2ParamC1 =  0.08


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                   ! (in)
        & nml = vdiffusion_my1974_nml, &  ! (out)
        & iostat = iostat_nml )           ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = vdiffusion_my1974_nml )
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'VelDiffCoef', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'diffusion coef. momentum', 'm2 s-1' )
    call HistoryAutoAddVariable( 'TempDiffCoef', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'diffusion coef. heat    ', 'm2 s-1' )
    call HistoryAutoAddVariable( 'QVapDiffCoef', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'diffusion coef. moisture', 'm2 s-1' )

    call HistoryAutoAddVariable( 'UFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'eastward momentum flux', 'N m-2' )
    call HistoryAutoAddVariable( 'VFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'northward momentum flux', 'N m-2' )
    call HistoryAutoAddVariable( 'TempFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'heat flux', 'W m-2' )
    call HistoryAutoAddVariable( 'QVapFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'moisture flux', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'For vertical diffusion flux:' )
    call MessageNotify( 'M', module_name, '  FlagConstDiffCoef = %b', l = (/ FlagConstDiffCoef /) )
    call MessageNotify( 'M', module_name, '  ConstDiffCoefM    = %f', d = (/ ConstDiffCoefM /) )
    call MessageNotify( 'M', module_name, '  ConstDiffCoefH    = %f', d = (/ ConstDiffCoefH /) )
    call MessageNotify( 'M', module_name, '  SquareVelMin = %f', d = (/ SquareVelMin /) )
    call MessageNotify( 'M', module_name, '  BulkRiNumMin = %f', d = (/ BulkRiNumMin /) )
    call MessageNotify( 'M', module_name, 'For diffusion coefficients:' )
    call MessageNotify( 'M', module_name, '  MixLengthMax      = %f', d = (/ MixLengthMax     /) )
    call MessageNotify( 'M', module_name, '  TildeShMin        = %f', d = (/ TildeShMin       /) )
    call MessageNotify( 'M', module_name, '  TildeSmMin        = %f', d = (/ TildeSmMin       /) )
    call MessageNotify( 'M', module_name, '  VelDiffCoefMin    = %f', d = (/ VelDiffCoefMin  /) )
    call MessageNotify( 'M', module_name, '  TempDiffCoefMin   = %f', d = (/ TempDiffCoefMin /) )
    call MessageNotify( 'M', module_name, '  QMixDiffCoefMin   = %f', d = (/ QMixDiffCoefMin /) )
    call MessageNotify( 'M', module_name, '  VelDiffCoefMax    = %f', d = (/ VelDiffCoefMax  /) )
    call MessageNotify( 'M', module_name, '  TempDiffCoefMax   = %f', d = (/ TempDiffCoefMax /) )
    call MessageNotify( 'M', module_name, '  QMixDiffCoefMax   = %f', d = (/ QMixDiffCoefMax /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamA1      = %f', d = (/ MYLv2ParamA1     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamB1      = %f', d = (/ MYLv2ParamB1     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamA2      = %f', d = (/ MYLv2ParamA2     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamB2      = %f', d = (/ MYLv2ParamB2     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamC1      = %f', d = (/ MYLv2ParamC1     /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    vdiffusion_my1974_inited = .true.
  end subroutine VDiffInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module vdiffusion_my1974
