*=======================================================================
*     Conversion of bitmap data for HGX
*     Aug. 22, 1991;  S. Sakai
*=======================================================================

      PARAMETER (NPAT=500, NCH=2000)
      INTEGER*2 IPAT(NPAT,2),  IPOS(NPAT), ILEN(NPAT), NREC1, NREC2
      CHARACTER CPAT*8,  CDATA(NCH)*1,  CBFL1*32,  CBFL2*32

*      WRITE(6,*) ' INPUT & OUTPUT FILE > '
      READ (5,*) CBFL1, CBFL2
      OPEN(1, FILE= CBFL1)
      OPEN(2, FILE= CBFL2, FORM='UNFORMATTED')
      READ(2) NREC1, IPAT, IPOS, ILEN, CDATA
      CLOSE(2)

      OPEN(2, FILE= CBFL2, FORM='UNFORMATTED')

      READ (1,'(I4)') NREC
      NREC2 = NREC1+NREC
      IPOS0 = IPOS(NREC1)+ILEN(NREC1)+1
      DO 100 I=NREC1+1, NREC2
        READ(1,'(4I4)') IPAT(I,1), IPAT(I,2), IWDTH, JLEN

        IP1 = MOD(IPAT(I,1), 100)
        IP2 = MOD(IPAT(I,2), 100)
        IF(IP1.NE.IP2) THEN
          WRITE(6,*) 'PATTERN NUMBER MAY BE WRONG ! '
          PAUSE
        ENDIF

        IPOS(I) = IPOS0
        ILEN(I) = JLEN
        DO 110 J=1, JLEN
          READ(1, '(A8)') CPAT
          CALL BITPCI(CPAT, IPTN)
          CDATA(IPOS0) = CHAR(IPTN)
          IPOS0 = IPOS0+1
  110   CONTINUE

  100 CONTINUE

      WRITE(2) NREC2, IPAT, IPOS, ILEN, CDATA
      END
*-----------------------------------------------------------------------
*     BITPCI
*-----------------------------------------------------------------------
      SUBROUTINE BITPCI(CP,IP)
 
      CHARACTER CP*(*)
 
      PARAMETER (NB=32)
 
      INTEGER   MASK(NB)
      LOGICAL   LFST
 
      SAVE
 
      EXTERNAL  ISHIFT
 
      DATA      LFST/.TRUE./
 
 
      IF (LFST) THEN
*        CALL GLPGET('NBITSPW',NBITPW)
        NBITPW=32
        IF (NBITPW.NE.NB) THEN
*          CALL MSGDMP('E','BITPCI',
*     +      'NUMBER OF BITS PER ONE WORD IS INVALID / '//
*     +      'CHECK NB IN THE PARAMETER STATEMENT OF BITPCI '//
*     +      'AND CHANGE IT CORRECTLY.')
        END IF
        MASK(1)=1
        DO 10 I=2,NB
          MASK(I)=ISHIFT(MASK(I-1),1)
   10   CONTINUE
        LFST=.FALSE.
      END IF
 
      NBC=LEN(CP)
      IP=0
      DO 15 I=1,MIN(NBC,NB)
        II=NBC-I+1
        IF (CP(II:II).NE.'0') THEN
          IP=IP+MASK(I)
        END IF
   15 CONTINUE
 
      END
*-----------------------------------------------------------------------
*     ISHIFT   (Lahey Fortran version.)
*-----------------------------------------------------------------------
      INTEGER FUNCTION ISHIFT(IWORD,N)
 
      INTRINSIC IOR
 
      IF (N.GT.0) THEN
        NS=MOD(N,32)
        ILFT=ISHFT(IWORD,NS)
        IRGT=ISHFT(IWORD,NS-32)
        ISHIFT=IOR(ILFT,IRGT)
      ELSE
        ISHIFT=ISHFT(IWORD,N)
      END IF
 
      END
